/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.webbase;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.metric.impl.ESTHistogram;
import org.apache.inlong.tubemq.corebase.metric.impl.SimpleHistogram;
import org.apache.inlong.tubemq.corebase.metric.impl.SinceTime;

public class WebCallStatsHolder {
    private static final WebCallStatsItemSet[] switchableSets = new WebCallStatsItemSet[2];
    private static final AtomicInteger writableIndex = new AtomicInteger(0);
    private static final AtomicLong lstSnapshotTime = new AtomicLong(0L);
    private static volatile boolean isManualClosed = false;

    public static void getValue(Map<String, Long> statsMap) {
        WebCallStatsHolder.getStatsValue(switchableSets[WebCallStatsHolder.getIndex()], false, statsMap);
    }

    public static void getValue(StringBuilder strBuff) {
        WebCallStatsHolder.getStatsValue(switchableSets[WebCallStatsHolder.getIndex()], false, strBuff);
    }

    public static void snapShort(Map<String, Long> statsMap) {
        if (WebCallStatsHolder.switchWritingStatsUnit()) {
            WebCallStatsHolder.getStatsValue(switchableSets[WebCallStatsHolder.getIndex(writableIndex.get() - 1)], true, statsMap);
        } else {
            WebCallStatsHolder.getStatsValue(switchableSets[WebCallStatsHolder.getIndex()], false, statsMap);
        }
    }

    public static void snapShort(StringBuilder strBuff) {
        if (WebCallStatsHolder.switchWritingStatsUnit()) {
            WebCallStatsHolder.getStatsValue(switchableSets[WebCallStatsHolder.getIndex(writableIndex.get() - 1)], true, strBuff);
        } else {
            WebCallStatsHolder.getStatsValue(switchableSets[WebCallStatsHolder.getIndex()], false, strBuff);
        }
    }

    public static synchronized void setStatsStatus(boolean enableStats) {
        isManualClosed = !enableStats;
    }

    public static boolean isStatsClosed() {
        return isManualClosed;
    }

    public static void addMethodCall(String method, long callDlt) {
        SimpleHistogram tmpSimpleStat;
        if (isManualClosed) {
            return;
        }
        method = method == null ? "NULL" : method;
        WebCallStatsItemSet webCallStatsSet = switchableSets[WebCallStatsHolder.getIndex()];
        webCallStatsSet.totalCallStats.update(callDlt);
        SimpleHistogram curMethodStat = webCallStatsSet.methodStatsMap.get(method);
        if (curMethodStat == null && (curMethodStat = webCallStatsSet.methodStatsMap.putIfAbsent(method, tmpSimpleStat = new SimpleHistogram(method, "method"))) == null) {
            curMethodStat = tmpSimpleStat;
        }
        curMethodStat.update(callDlt);
    }

    private static boolean switchWritingStatsUnit() {
        long curSnapshotTime = lstSnapshotTime.get();
        if (System.currentTimeMillis() - curSnapshotTime >= 2000L && lstSnapshotTime.compareAndSet(curSnapshotTime, System.currentTimeMillis())) {
            switchableSets[WebCallStatsHolder.getIndex(writableIndex.incrementAndGet())].resetSinceTime();
            return true;
        }
        return false;
    }

    private static void getStatsValue(WebCallStatsItemSet statsSet, boolean resetValue, Map<String, Long> statsMap) {
        statsMap.put(statsSet.lstResetTime.getFullName(), statsSet.lstResetTime.getSinceTime());
        statsMap.put("isClosed", isManualClosed ? 1L : 0L);
        if (resetValue) {
            statsSet.totalCallStats.snapShort(statsMap, false);
        } else {
            statsSet.totalCallStats.getValue(statsMap, false);
        }
        statsSet.getMethodStatsInfo(statsMap, resetValue);
    }

    private static void getStatsValue(WebCallStatsItemSet statsSet, boolean resetValue, StringBuilder strBuff) {
        strBuff.append("{\"").append(statsSet.lstResetTime.getFullName()).append("\":\"").append(statsSet.lstResetTime.getStrSinceTime()).append("\",\"isClosed\":").append(isManualClosed).append(",");
        if (resetValue) {
            statsSet.totalCallStats.snapShort(strBuff, false);
        } else {
            statsSet.totalCallStats.getValue(strBuff, false);
        }
        strBuff.append(",");
        statsSet.getMethodStatsInfo(strBuff, resetValue);
        strBuff.append("}");
    }

    private static int getIndex() {
        return WebCallStatsHolder.getIndex(writableIndex.get());
    }

    private static int getIndex(int origIndex) {
        return Math.abs(origIndex % 2);
    }

    static {
        WebCallStatsHolder.switchableSets[0] = new WebCallStatsItemSet();
        WebCallStatsHolder.switchableSets[1] = new WebCallStatsItemSet();
    }

    private static class WebCallStatsItemSet {
        protected final SinceTime lstResetTime = new SinceTime("reset_time", null);
        protected final ESTHistogram totalCallStats = new ESTHistogram("web_calls", null);
        protected final ConcurrentHashMap<String, SimpleHistogram> methodStatsMap = new ConcurrentHashMap();

        public WebCallStatsItemSet() {
            this.resetSinceTime();
        }

        public void resetSinceTime() {
            this.lstResetTime.reset();
        }

        public void getMethodStatsInfo(Map<String, Long> statsMap, boolean resetValue) {
            for (SimpleHistogram itemStats : this.methodStatsMap.values()) {
                itemStats.getValue(statsMap, false);
            }
            if (resetValue) {
                this.methodStatsMap.clear();
            }
        }

        public void getMethodStatsInfo(StringBuilder strBuff, boolean resetValue) {
            int totalCnt = 0;
            strBuff.append("\"").append("methods\":{");
            for (SimpleHistogram itemStats : this.methodStatsMap.values()) {
                if (itemStats == null) continue;
                if (totalCnt++ > 0) {
                    strBuff.append(",");
                }
                itemStats.getValue(strBuff, false);
            }
            strBuff.append("}");
            if (resetValue) {
                this.methodStatsMap.clear();
            }
        }
    }
}

