/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.fileconfig.BdbMetaConfig;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.common.statusdef.ManageStatus;
import org.apache.inlong.tubemq.server.common.statusdef.TopicStatus;
import org.apache.inlong.tubemq.server.common.statusdef.TopicStsChgType;
import org.apache.inlong.tubemq.server.master.MasterConfig;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.bdbstore.MasterGroupStatus;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.MetaDataService;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.ConfigObserver;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BrokerConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupConsumeCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupResCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicDeployEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicPropGroup;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.MetaConfigMapper;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl.BdbMetaConfigMapperImpl;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.zkimpl.ZKMetaConfigMapperImpl;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunStatusInfo;
import org.apache.inlong.tubemq.server.master.web.handler.BrokerProcessResult;
import org.apache.inlong.tubemq.server.master.web.handler.GroupProcessResult;
import org.apache.inlong.tubemq.server.master.web.handler.TopicProcessResult;
import org.apache.inlong.tubemq.server.master.web.model.ClusterGroupVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetaDataService
implements MetaDataService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMetaDataService.class);
    private final TMaster tMaster;
    private final MetaConfigMapper metaConfigMapper;
    private final ScheduledExecutorService scheduledExecutorService;
    private final MasterGroupStatus masterGroupStatus = new MasterGroupStatus();
    private volatile boolean isStarted = false;
    private volatile boolean isStopped = false;
    private long serviceStartTime = System.currentTimeMillis();

    public DefaultMetaDataService(TMaster tMaster) {
        this.tMaster = tMaster;
        MasterConfig masterConfig = tMaster.getMasterConfig();
        if (masterConfig.isUseBdbStoreMetaData()) {
            this.metaConfigMapper = new BdbMetaConfigMapperImpl(masterConfig);
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "Master Status Check");
                }
            });
        } else {
            this.metaConfigMapper = new ZKMetaConfigMapperImpl(masterConfig);
            this.scheduledExecutorService = null;
        }
    }

    @Override
    public void start() throws Exception {
        if (this.isStarted) {
            return;
        }
        this.metaConfigMapper.start();
        if (this.tMaster.getMasterConfig().isUseBdbStoreMetaData()) {
            final BdbMetaConfig bdbMetaConfig = this.tMaster.getMasterConfig().getBdbMetaConfig();
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        MasterGroupStatus tmpGroupStatus = DefaultMetaDataService.this.metaConfigMapper.getMasterGroupStatus(true);
                        if (tmpGroupStatus == null) {
                            DefaultMetaDataService.this.masterGroupStatus.setMasterGroupStatus(false, false, false);
                        } else {
                            DefaultMetaDataService.this.masterGroupStatus.setMasterGroupStatus(DefaultMetaDataService.this.metaConfigMapper.isMasterNow(), tmpGroupStatus.isWritable(), tmpGroupStatus.isReadable());
                        }
                    }
                    catch (Throwable e) {
                        logger.error(new StringBuilder(512).append("BDBGroupStatus Check exception, wait ").append(bdbMetaConfig.getRepStatusCheckTimeoutMs()).append(" ms to try again.").append(e.getMessage()).toString());
                    }
                }
            }, 0L, bdbMetaConfig.getRepStatusCheckTimeoutMs(), TimeUnit.MILLISECONDS);
        }
        BrokerRunManager brokerRunManager = this.tMaster.getBrokerRunManager();
        brokerRunManager.updBrokerStaticInfo(this.metaConfigMapper.getBrokerConfInfo(null));
        this.serviceStartTime = System.currentTimeMillis();
        this.isStarted = true;
        logger.info("DefaultMetaDataService Started");
    }

    @Override
    public void stop() throws Exception {
        if (this.isStopped) {
            return;
        }
        if (this.tMaster.getMasterConfig().isUseBdbStoreMetaData()) {
            this.scheduledExecutorService.shutdownNow();
        }
        this.isStopped = true;
        logger.info("DefaultMetaDataService stopped");
    }

    @Override
    public void regMetaConfigObserver(ConfigObserver eventObserver) {
        this.metaConfigMapper.regMetaConfigObserver(eventObserver);
    }

    @Override
    public boolean isSelfMaster() {
        return this.metaConfigMapper.isMasterNow();
    }

    @Override
    public boolean isPrimaryNodeActive() {
        return this.metaConfigMapper.isPrimaryNodeActive();
    }

    @Override
    public void transferMaster() throws Exception {
        if (this.metaConfigMapper.isMasterNow() && !this.metaConfigMapper.isPrimaryNodeActive()) {
            this.metaConfigMapper.transferMaster();
        }
    }

    @Override
    public String getMasterAddress() {
        return this.metaConfigMapper.getMasterAddress();
    }

    @Override
    public ClusterGroupVO getGroupAddressStrInfo() {
        return this.metaConfigMapper.getGroupAddressStrInfo();
    }

    @Override
    public boolean isConsumeTargetAuthorized(String consumerId, String groupName, Set<String> reqTopicSet, Map<String, TreeSet<String>> reqTopicCondMap, StringBuilder strBuff, ProcessResult result) {
        if (reqTopicSet == null || reqTopicSet.isEmpty()) {
            result.setFailResult(400, "Request miss necessary subscribed topic data");
            return result.isSuccess();
        }
        if (reqTopicCondMap != null && !reqTopicCondMap.isEmpty()) {
            Set<String> condTopics = reqTopicCondMap.keySet();
            ArrayList<String> unSetTopic = new ArrayList<String>();
            for (String topic : condTopics) {
                if (reqTopicSet.contains(topic)) continue;
                unSetTopic.add(topic);
            }
            if (!unSetTopic.isEmpty()) {
                result.setFailResult(400, strBuff.append("Filter's Topic not subscribed :").append(unSetTopic).toString());
                strBuff.delete(0, strBuff.length());
                return result.isSuccess();
            }
        }
        HashSet<String> disableCsmTopicSet = new HashSet<String>();
        HashSet<String> enableFltCsmTopicSet = new HashSet<String>();
        for (String topicItem : reqTopicSet) {
            TopicCtrlEntity topicEntity;
            if (TStringUtils.isBlank((String)topicItem) || (topicEntity = this.metaConfigMapper.getTopicCtrlByTopicName(topicItem)) == null || !topicEntity.isAuthCtrlEnable()) continue;
            GroupConsumeCtrlEntity ctrlEntity = this.metaConfigMapper.getConsumeCtrlByGroupAndTopic(groupName, topicItem);
            if (ctrlEntity == null || !ctrlEntity.isEnableConsume()) {
                disableCsmTopicSet.add(topicItem);
            }
            if (ctrlEntity == null || !ctrlEntity.isEnableFilterConsume()) continue;
            enableFltCsmTopicSet.add(topicItem);
        }
        if (!disableCsmTopicSet.isEmpty()) {
            result.setFailResult(450, strBuff.append("[unAuthorized Group] ").append(consumerId).append("'s consumerGroup not authorized by administrator, unAuthorizedTopics: ").append(disableCsmTopicSet).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        return this.checkFilterRstrTopics(groupName, consumerId, enableFltCsmTopicSet, reqTopicCondMap, strBuff, result);
    }

    private boolean checkFilterRstrTopics(String groupName, String consumerId, Set<String> enableFltCsmTopicSet, Map<String, TreeSet<String>> reqTopicCondMap, StringBuilder strBuff, ProcessResult result) {
        if (enableFltCsmTopicSet == null || enableFltCsmTopicSet.isEmpty()) {
            result.setSuccResult((Object)"Ok!");
            return result.isSuccess();
        }
        for (String topicName : enableFltCsmTopicSet) {
            GroupConsumeCtrlEntity ctrlEntity = this.metaConfigMapper.getConsumeCtrlByGroupAndTopic(groupName, topicName);
            if (ctrlEntity == null || !ctrlEntity.isEnableFilterConsume()) continue;
            String allowedCondStr = ctrlEntity.getFilterCondStr();
            if (allowedCondStr.equals(",,")) {
                result.setFailResult(455, strBuff.append("[Restricted Group] ").append(consumerId).append(" : ").append(groupName).append(" not allowed to consume any data of topic ").append(topicName).toString());
                strBuff.delete(0, strBuff.length());
                return result.isSuccess();
            }
            TreeSet<String> condItemSet = reqTopicCondMap.get(topicName);
            if (condItemSet == null || condItemSet.isEmpty()) {
                result.setFailResult(455, strBuff.append("[Restricted Group] ").append(consumerId).append(" : ").append(groupName).append(" must set the filter conditions of topic ").append(topicName).toString());
                strBuff.delete(0, strBuff.length());
                return result.isSuccess();
            }
            HashMap<String, List> unAuthorizedCondMap = new HashMap<String, List>();
            for (String item : condItemSet) {
                if (!allowedCondStr.contains(strBuff.append(",").append(item).append(",").toString())) {
                    List unAuthConds = unAuthorizedCondMap.computeIfAbsent(topicName, k -> new ArrayList());
                    unAuthConds.add(item);
                }
                strBuff.delete(0, strBuff.length());
            }
            if (unAuthorizedCondMap.isEmpty()) continue;
            result.setFailResult(455, strBuff.append("[Restricted Group] ").append(consumerId).append(" : unAuthorized filter conditions ").append(unAuthorizedCondMap).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        result.setSuccResult((Object)"Ok!");
        return result.isSuccess();
    }

    @Override
    public boolean addOrUpdClusterDefSetting(BaseEntity opEntity, int brokerPort, int brokerTlsPort, int brokerWebPort, int maxMsgSizeMB, int qryPriorityId, EnableStatus flowCtrlEnable, int flowRuleCnt, String flowCtrlInfo, TopicPropGroup topicProps, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return result.isSuccess();
        }
        return this.metaConfigMapper.addOrUpdClusterDefSetting(opEntity, brokerPort, brokerTlsPort, brokerWebPort, maxMsgSizeMB, qryPriorityId, flowCtrlEnable, flowRuleCnt, flowCtrlInfo, topicProps, strBuff, result);
    }

    @Override
    public ClusterSettingEntity getClusterDefSetting(boolean isMustConf) {
        return this.metaConfigMapper.getClusterDefSetting(isMustConf);
    }

    @Override
    public BrokerProcessResult addOrUpdBrokerConfig(boolean isAddOp, BaseEntity opEntity, int brokerId, String brokerIp, int brokerPort, int brokerTlsPort, int brokerWebPort, int regionId, int groupId, ManageStatus mngStatus, TopicPropGroup topicProps, StringBuilder strBuff, ProcessResult result) {
        BrokerConfEntity entity = new BrokerConfEntity(opEntity, brokerId, brokerIp);
        entity.updModifyInfo(opEntity.getDataVerId(), brokerPort, brokerTlsPort, brokerWebPort, regionId, groupId, mngStatus, topicProps);
        return this.addOrUpdBrokerConfig(isAddOp, entity, strBuff, result);
    }

    @Override
    public BrokerProcessResult addOrUpdBrokerConfig(boolean isAddOp, BrokerConfEntity entity, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new BrokerProcessResult(entity.getBrokerId(), entity.getBrokerIp(), result);
        }
        if (!this.metaConfigMapper.addOrUpdBrokerConfig(isAddOp, entity, strBuff, result)) {
            return new BrokerProcessResult(entity.getBrokerId(), entity.getBrokerIp(), result);
        }
        BrokerConfEntity curEntity = this.metaConfigMapper.getBrokerConfByBrokerId(entity.getBrokerId());
        this.tMaster.getBrokerRunManager().updBrokerStaticInfo(curEntity);
        if (isAddOp) {
            this.metaConfigMapper.addSystemTopicDeploy(curEntity.getBrokerId(), curEntity.getBrokerPort(), curEntity.getBrokerIp(), strBuff);
        }
        this.triggerBrokerConfDataSync(curEntity.getBrokerId(), strBuff, result);
        return new BrokerProcessResult(curEntity.getBrokerId(), curEntity.getBrokerIp(), result);
    }

    @Override
    public BrokerProcessResult changeBrokerConfStatus(BaseEntity opEntity, int brokerId, ManageStatus newMngStatus, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new BrokerProcessResult(brokerId, "", result);
        }
        if (this.metaConfigMapper.changeBrokerConfStatus(opEntity, brokerId, newMngStatus, strBuff, result)) {
            this.triggerBrokerConfDataSync(brokerId, strBuff, result);
        }
        return new BrokerProcessResult(brokerId, "", result);
    }

    @Override
    public BrokerProcessResult reloadBrokerConfInfo(BaseEntity opEntity, int brokerId, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new BrokerProcessResult(brokerId, "", result);
        }
        BrokerConfEntity curEntry = this.metaConfigMapper.getBrokerConfByBrokerId(brokerId);
        if (curEntry == null) {
            result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), "The broker configure not exist!");
            return new BrokerProcessResult(brokerId, "", result);
        }
        if (!curEntry.getManageStatus().isOnlineStatus()) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("The broker manage status by brokerId=").append(brokerId).append(" is not in online status, can't reload this configure! ").toString());
            strBuff.delete(0, strBuff.length());
            return new BrokerProcessResult(brokerId, "", result);
        }
        this.triggerBrokerConfDataSync(curEntry.getBrokerId(), strBuff, result);
        return new BrokerProcessResult(brokerId, curEntry.getBrokerIp(), result);
    }

    @Override
    public BrokerProcessResult delBrokerConfInfo(String operator, boolean rsvData, int brokerId, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new BrokerProcessResult(brokerId, "", result);
        }
        BrokerConfEntity curEntry = this.metaConfigMapper.getBrokerConfByBrokerId(brokerId);
        if (curEntry == null) {
            result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), DataOpErrCode.DERR_SUCCESS.getDescription());
            return new BrokerProcessResult(brokerId, "", result);
        }
        if (curEntry.getManageStatus().isOnlineStatus()) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), "Broker manage status is online, please offline first!");
            return new BrokerProcessResult(brokerId, curEntry.getBrokerIp(), result);
        }
        BrokerRunManager brokerRunManager = this.tMaster.getBrokerRunManager();
        BrokerRunStatusInfo runStatusInfo = brokerRunManager.getBrokerRunStatusInfo(brokerId);
        if (runStatusInfo != null && curEntry.getManageStatus() == ManageStatus.STATUS_MANAGE_OFFLINE && runStatusInfo.inProcessingStatus()) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("Illegal value: the broker is processing offline event by brokerId=").append(brokerId).append(", please offline first and try later!").toString());
            strBuff.delete(0, strBuff.length());
            return new BrokerProcessResult(brokerId, curEntry.getBrokerIp(), result);
        }
        if (this.metaConfigMapper.delBrokerConfInfo(operator, brokerId, rsvData, strBuff, result)) {
            brokerRunManager.delBrokerStaticInfo(brokerId);
            if (runStatusInfo != null) {
                brokerRunManager.releaseBrokerRunInfo(brokerId, runStatusInfo.getCreateId(), false);
            }
        }
        return new BrokerProcessResult(brokerId, curEntry.getBrokerIp(), result);
    }

    @Override
    public Map<Integer, BrokerConfEntity> getBrokerConfInfo(BrokerConfEntity qryEntity) {
        return this.metaConfigMapper.getBrokerConfInfo(qryEntity);
    }

    @Override
    public Map<Integer, BrokerConfEntity> getBrokerConfInfo(Set<Integer> brokerIdSet, Set<String> brokerIpSet, BrokerConfEntity qryEntity) {
        return this.metaConfigMapper.getBrokerConfInfo(brokerIdSet, brokerIpSet, qryEntity);
    }

    private boolean triggerBrokerConfDataSync(int brokerId, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return result.isSuccess();
        }
        BrokerRunManager brokerRunManager = this.tMaster.getBrokerRunManager();
        BrokerRunStatusInfo runStatusInfo = brokerRunManager.getBrokerRunStatusInfo(brokerId);
        if (runStatusInfo == null) {
            result.setSuccResult(null);
            return result.isSuccess();
        }
        runStatusInfo.notifyDataChanged();
        logger.info(strBuff.append("[Meta data] trigger broker syncStatus info, brokerId=").append(brokerId).toString());
        strBuff.delete(0, strBuff.length());
        result.setSuccResult(null);
        return result.isSuccess();
    }

    private boolean triggerBrokerConfDataSync(Set<String> topicNameSet, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return result.isSuccess();
        }
        Set<Integer> brokerIdSet = this.metaConfigMapper.getDeployedBrokerIdByTopic(topicNameSet);
        if (brokerIdSet.isEmpty()) {
            result.setSuccResult();
            return result.isSuccess();
        }
        BrokerRunManager brokerRunManager = this.tMaster.getBrokerRunManager();
        for (Integer brokerId : brokerIdSet) {
            BrokerRunStatusInfo runStatusInfo;
            if (brokerId == null || (runStatusInfo = brokerRunManager.getBrokerRunStatusInfo(brokerId)) == null) continue;
            runStatusInfo.notifyDataChanged();
        }
        logger.info(strBuff.append("[Meta data] trigger broker syncStatus info for").append(" maxMsgSize modify, brokerId set is ").append(brokerIdSet).toString());
        strBuff.delete(0, strBuff.length());
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    public boolean delCleanedTopicDeployInfo(int brokerId, List<String> removedTopics, StringBuilder strBuff, ProcessResult result) {
        result.setSuccResult(null);
        if (removedTopics == null || removedTopics.isEmpty()) {
            return result.isSuccess();
        }
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return result.isSuccess();
        }
        Map<String, TopicDeployEntity> topicDeployMap = this.metaConfigMapper.getConfiguredTopicInfo(brokerId);
        if (topicDeployMap == null || topicDeployMap.isEmpty()) {
            return result.isSuccess();
        }
        boolean needSync2Broker = false;
        for (String topicName : removedTopics) {
            TopicDeployEntity topicEntity = topicDeployMap.get(topicName);
            if (topicEntity == null || topicEntity.getTopicStatus() != TopicStatus.STATUS_TOPIC_SOFT_REMOVE || !this.metaConfigMapper.delTopicDeployInfo("system-self", brokerId, topicName, strBuff, result)) continue;
            needSync2Broker = true;
        }
        if (needSync2Broker) {
            return this.triggerBrokerConfDataSync(brokerId, strBuff, result);
        }
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    public Map<Integer, Set<String>> getBrokerTopicConfigInfo(Set<Integer> brokerIdSet) {
        return this.metaConfigMapper.getConfiguredTopicInfo(brokerIdSet);
    }

    @Override
    public Map<String, Map<Integer, String>> getTopicBrokerConfigInfo(Set<String> topicNameSet) {
        return this.metaConfigMapper.getTopicBrokerInfo(topicNameSet);
    }

    @Override
    public Set<String> getDeployedTopicSet() {
        return this.metaConfigMapper.getDeployedTopicSet();
    }

    @Override
    public BrokerConfEntity getBrokerConfByBrokerId(int brokerId) {
        return this.metaConfigMapper.getBrokerConfByBrokerId(brokerId);
    }

    @Override
    public BrokerConfEntity getBrokerConfByBrokerIp(String brokerIp) {
        return this.metaConfigMapper.getBrokerConfByBrokerIp(brokerIp);
    }

    @Override
    public Map<String, TopicDeployEntity> getBrokerTopicConfEntitySet(int brokerId) {
        return this.metaConfigMapper.getConfiguredTopicInfo(brokerId);
    }

    @Override
    public TopicProcessResult addOrUpdTopicDeployInfo(boolean isAddOp, BaseEntity opEntity, int brokerId, String topicName, TopicStatus deployStatus, TopicPropGroup topicPropInfo, StringBuilder strBuff, ProcessResult result) {
        TopicDeployEntity entity = new TopicDeployEntity(opEntity, brokerId, topicName);
        entity.updModifyInfo(opEntity.getDataVerId(), -2, -2, null, deployStatus, topicPropInfo);
        return this.addOrUpdTopicDeployInfo(isAddOp, entity, strBuff, result);
    }

    @Override
    public TopicProcessResult addOrUpdTopicDeployInfo(boolean isAddOp, TopicDeployEntity entity, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new TopicProcessResult(entity.getBrokerId(), entity.getTopicName(), result);
        }
        BrokerConfEntity brokerConf = this.getBrokerConfByBrokerId(entity.getBrokerId());
        if (brokerConf == null) {
            result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found broker configure record by brokerId=").append(entity.getBrokerId()).append(", please create the broker's configure first!").toString());
            strBuff.delete(0, strBuff.length());
            return new TopicProcessResult(entity.getBrokerId(), entity.getTopicName(), result);
        }
        if (this.metaConfigMapper.addOrUpdTopicDeployInfo(isAddOp, entity, strBuff, result)) {
            this.triggerBrokerConfDataSync(entity.getBrokerId(), strBuff, result);
        }
        return new TopicProcessResult(entity.getBrokerId(), entity.getTopicName(), result);
    }

    @Override
    public TopicProcessResult updTopicDeployStatusInfo(BaseEntity opEntity, int brokerId, String topicName, TopicStsChgType chgType, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new TopicProcessResult(brokerId, topicName, result);
        }
        BrokerConfEntity brokerConf = this.getBrokerConfByBrokerId(brokerId);
        if (brokerConf == null) {
            result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found broker configure record by brokerId=").append(brokerId).append(", please create the broker's configure first!").toString());
            strBuff.delete(0, strBuff.length());
            return new TopicProcessResult(brokerId, topicName, result);
        }
        TopicDeployEntity curEntity = this.metaConfigMapper.getConfiguredTopicInfo(brokerId, topicName);
        if (curEntity == null) {
            result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found the topic ").append(topicName).append("'s deploy configure in broker=").append(brokerId).append(", please confirm the configure first!").toString());
            strBuff.delete(0, strBuff.length());
            return new TopicProcessResult(brokerId, topicName, result);
        }
        TopicStatus topicStatus = chgType == TopicStsChgType.STATUS_CHANGE_SOFT_DELETE ? TopicStatus.STATUS_TOPIC_SOFT_DELETE : (chgType == TopicStsChgType.STATUS_CHANGE_REMOVE ? TopicStatus.STATUS_TOPIC_SOFT_REMOVE : TopicStatus.STATUS_TOPIC_OK);
        if (this.metaConfigMapper.updTopicDeployStatusInfo(opEntity, brokerId, topicName, topicStatus, strBuff, result)) {
            this.triggerBrokerConfDataSync(brokerId, strBuff, result);
        }
        return new TopicProcessResult(brokerId, topicName, result);
    }

    @Override
    public Map<String, List<TopicDeployEntity>> getTopicDeployInfoMap(Set<String> topicNameSet, Set<Integer> brokerIdSet, TopicDeployEntity qryEntity) {
        return this.metaConfigMapper.getTopicDeployInfoMap(topicNameSet, brokerIdSet, qryEntity);
    }

    @Override
    public Map<Integer, List<TopicDeployEntity>> getTopicDeployInfoMap(Set<String> topicNameSet, Set<Integer> brokerIdSet) {
        Map<Integer, BrokerConfEntity> qryBrokerInfoMap = this.metaConfigMapper.getBrokerConfInfo(brokerIdSet, null, null);
        if (qryBrokerInfoMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.metaConfigMapper.getTopicDeployInfoMap(topicNameSet, qryBrokerInfoMap.keySet());
    }

    @Override
    public Map<String, List<TopicDeployEntity>> getTopicConfMapByTopicAndBrokerIds(Set<String> topicNameSet, Set<Integer> brokerIdSet) {
        return this.metaConfigMapper.getTopicConfInfoByTopicAndBrokerIds(topicNameSet, brokerIdSet);
    }

    @Override
    public Map<String, String> getBrokerTopicStrConfigInfo(BrokerConfEntity brokerConfEntity, StringBuilder strBuff) {
        return this.inGetTopicConfStrInfo(brokerConfEntity, false, strBuff);
    }

    @Override
    public Map<String, String> getBrokerRemovedTopicStrConfigInfo(BrokerConfEntity brokerConfEntity, StringBuilder strBuff) {
        return this.inGetTopicConfStrInfo(brokerConfEntity, true, strBuff);
    }

    private Map<String, String> inGetTopicConfStrInfo(BrokerConfEntity brokerEntity, boolean isRemoved, StringBuilder strBuff) {
        HashMap<String, String> topicConfStrMap = new HashMap<String, String>();
        Map<String, TopicDeployEntity> topicEntityMap = this.metaConfigMapper.getConfiguredTopicInfo(brokerEntity.getBrokerId());
        if (topicEntityMap.isEmpty()) {
            return topicConfStrMap;
        }
        TopicPropGroup defTopicProps = brokerEntity.getTopicProps();
        ClusterSettingEntity clusterDefConf = this.metaConfigMapper.getClusterDefSetting(false);
        int defMsgSizeInB = clusterDefConf.getMaxMsgSizeInB();
        for (TopicDeployEntity topicEntity : topicEntityMap.values()) {
            if (isRemoved && !topicEntity.isInRemoving() || !isRemoved && topicEntity.isInRemoving()) continue;
            strBuff.append(topicEntity.getTopicName());
            TopicPropGroup topicProps = topicEntity.getTopicProps();
            if (topicProps.getNumPartitions() == -2 || topicProps.getNumPartitions() == defTopicProps.getNumPartitions()) {
                strBuff.append(":").append(" ");
            } else {
                strBuff.append(":").append(topicProps.getNumPartitions());
            }
            if (topicProps.getAcceptPublish() == null || topicProps.isAcceptPublish() == defTopicProps.isAcceptPublish()) {
                strBuff.append(":").append(" ");
            } else {
                strBuff.append(":").append(topicProps.isAcceptPublish());
            }
            if (topicProps.getAcceptSubscribe() == null || topicProps.isAcceptSubscribe() == defTopicProps.isAcceptSubscribe()) {
                strBuff.append(":").append(" ");
            } else {
                strBuff.append(":").append(topicProps.isAcceptSubscribe());
            }
            if (topicProps.getUnflushThreshold() == -2 || topicProps.getUnflushThreshold() == defTopicProps.getUnflushThreshold()) {
                strBuff.append(":").append(" ");
            } else {
                strBuff.append(":").append(topicProps.getUnflushThreshold());
            }
            if (topicProps.getUnflushInterval() == -2 || topicProps.getUnflushInterval() == defTopicProps.getUnflushInterval()) {
                strBuff.append(":").append(" ");
            } else {
                strBuff.append(":").append(topicProps.getUnflushInterval());
            }
            strBuff.append(":").append(" ");
            if (TStringUtils.isEmpty((String)topicProps.getDeletePolicy()) || topicProps.getDeletePolicy().equals(defTopicProps.getDeletePolicy())) {
                strBuff.append(":").append(" ");
            } else {
                strBuff.append(":").append(topicProps.getDeletePolicy());
            }
            if (topicProps.getNumTopicStores() == -2 || topicProps.getNumTopicStores() == defTopicProps.getNumTopicStores()) {
                strBuff.append(":").append(" ");
            } else {
                strBuff.append(":").append(topicProps.getNumTopicStores());
            }
            strBuff.append(":").append(topicEntity.getTopicStatusId());
            if (topicProps.getUnflushDataHold() == -2 || topicProps.getUnflushDataHold() == defTopicProps.getUnflushDataHold()) {
                strBuff.append(":").append(" ");
            } else {
                strBuff.append(":").append(topicProps.getUnflushDataHold());
            }
            if (topicProps.getMemCacheMsgSizeInMB() == -2 || topicProps.getMemCacheMsgSizeInMB() == defTopicProps.getMemCacheMsgSizeInMB()) {
                strBuff.append(":").append(" ");
            } else {
                strBuff.append(":").append(topicProps.getMemCacheMsgSizeInMB());
            }
            if (topicProps.getMemCacheMsgCntInK() == -2 || topicProps.getMemCacheMsgCntInK() == defTopicProps.getMemCacheMsgCntInK()) {
                strBuff.append(":").append(" ");
            } else {
                strBuff.append(":").append(topicProps.getMemCacheMsgCntInK());
            }
            if (topicProps.getMemCacheFlushIntvl() == -2 || topicProps.getMemCacheFlushIntvl() == defTopicProps.getMemCacheFlushIntvl()) {
                strBuff.append(":").append(" ");
            } else {
                strBuff.append(":").append(topicProps.getMemCacheFlushIntvl());
            }
            int maxMsgSize = defMsgSizeInB;
            TopicCtrlEntity topicCtrlEntity = this.metaConfigMapper.getTopicCtrlByTopicName(topicEntity.getTopicName());
            if (topicCtrlEntity != null && topicCtrlEntity.getMaxMsgSizeInB() != -2) {
                maxMsgSize = topicCtrlEntity.getMaxMsgSizeInB();
            }
            if (maxMsgSize == defMsgSizeInB) {
                strBuff.append(":").append(" ");
            } else {
                strBuff.append(":").append(maxMsgSize);
            }
            topicConfStrMap.put(topicEntity.getTopicName(), strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
        return topicConfStrMap;
    }

    @Override
    public List<TopicProcessResult> addOrUpdTopicCtrlConf(boolean isAddOp, BaseEntity opEntity, Set<String> topicNameSet, int topicNameId, EnableStatus enableTopicAuth, int maxMsgSizeInMB, StringBuilder strBuff, ProcessResult result) {
        HashMap<String, TopicCtrlEntity> topicCtrlEntityMap = new HashMap<String, TopicCtrlEntity>();
        for (String topicName : topicNameSet) {
            TopicCtrlEntity entity = new TopicCtrlEntity(opEntity, topicName);
            entity.updModifyInfo(opEntity.getDataVerId(), topicNameId, maxMsgSizeInMB, enableTopicAuth);
            topicCtrlEntityMap.put(topicName, entity);
        }
        return this.addOrUpdTopicCtrlConf(isAddOp, topicCtrlEntityMap, strBuff, result);
    }

    @Override
    public List<TopicProcessResult> addOrUpdTopicCtrlConf(boolean isAddOp, Map<String, TopicCtrlEntity> entityMap, StringBuilder strBuff, ProcessResult result) {
        ArrayList<TopicProcessResult> retInfo = new ArrayList<TopicProcessResult>();
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            for (String topicName : entityMap.keySet()) {
                retInfo.add(new TopicProcessResult(0, topicName, result));
            }
            return retInfo;
        }
        if (isAddOp) {
            for (TopicCtrlEntity entity : entityMap.values()) {
                this.metaConfigMapper.addOrUpdTopicCtrlConf(isAddOp, entity, strBuff, result);
                retInfo.add(new TopicProcessResult(0, entity.getTopicName(), result));
            }
        } else {
            HashSet<String> changedTopicSet = new HashSet<String>();
            for (TopicCtrlEntity entity : entityMap.values()) {
                TopicCtrlEntity curEntity = this.metaConfigMapper.getTopicCtrlByTopicName(entity.getTopicName());
                if (curEntity != null && curEntity.getMaxMsgSizeInB() != entity.getMaxMsgSizeInB()) {
                    changedTopicSet.add(entity.getTopicName());
                }
                this.metaConfigMapper.addOrUpdTopicCtrlConf(isAddOp, entity, strBuff, result);
                retInfo.add(new TopicProcessResult(0, entity.getTopicName(), result));
            }
            if (!changedTopicSet.isEmpty()) {
                this.triggerBrokerConfDataSync(changedTopicSet, strBuff, result);
            }
        }
        return retInfo;
    }

    @Override
    public TopicProcessResult insertTopicCtrlConf(BaseEntity opEntity, String topicName, EnableStatus enableTopicAuth, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new TopicProcessResult(0, topicName, result);
        }
        this.metaConfigMapper.insertTopicCtrlConf(opEntity, topicName, enableTopicAuth, strBuff, result);
        return new TopicProcessResult(0, topicName, result);
    }

    @Override
    public TopicProcessResult insertTopicCtrlConf(TopicCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new TopicProcessResult(0, entity.getTopicName(), result);
        }
        this.metaConfigMapper.insertTopicCtrlConf(entity, strBuff, result);
        return new TopicProcessResult(0, entity.getTopicName(), result);
    }

    @Override
    public boolean delTopicCtrlConf(String operator, String topicName, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return result.isSuccess();
        }
        return this.metaConfigMapper.delTopicCtrlConf(operator, topicName, strBuff, result);
    }

    @Override
    public TopicCtrlEntity getTopicCtrlByTopicName(String topicName) {
        return this.metaConfigMapper.getTopicCtrlByTopicName(topicName);
    }

    @Override
    public int getTopicMaxMsgSizeInMB(String topicName) {
        ClusterSettingEntity clusterSettingEntity = this.metaConfigMapper.getClusterDefSetting(false);
        int maxMsgSizeInMB = clusterSettingEntity.getMaxMsgSizeInMB();
        TopicCtrlEntity topicCtrlEntity = this.metaConfigMapper.getTopicCtrlByTopicName(topicName);
        if (topicCtrlEntity != null && topicCtrlEntity.getMaxMsgSizeInMB() != -2) {
            maxMsgSizeInMB = topicCtrlEntity.getMaxMsgSizeInMB();
        }
        return maxMsgSizeInMB;
    }

    @Override
    public Map<String, TopicCtrlEntity> getTopicCtrlConf(Set<String> topicNameSet, TopicCtrlEntity qryEntity) {
        return this.metaConfigMapper.getTopicCtrlConf(topicNameSet, qryEntity);
    }

    @Override
    public Map<String, Integer> getMaxMsgSizeInBByTopics(int defMaxMsgSizeInB, Set<String> topicNameSet) {
        return this.metaConfigMapper.getMaxMsgSizeInBByTopics(defMaxMsgSizeInB, topicNameSet);
    }

    @Override
    public GroupProcessResult addOrUpdGroupCtrlConf(boolean isAddOp, BaseEntity opEntity, String groupName, EnableStatus resCheckEnable, int allowedBClientRate, int qryPriorityId, EnableStatus flowCtrlEnable, int flowRuleCnt, String flowCtrlInfo, StringBuilder strBuff, ProcessResult result) {
        GroupResCtrlEntity entity = new GroupResCtrlEntity(opEntity, groupName);
        entity.updModifyInfo(opEntity.getDataVerId(), resCheckEnable, allowedBClientRate, qryPriorityId, flowCtrlEnable, flowRuleCnt, flowCtrlInfo);
        return this.addOrUpdGroupCtrlConf(isAddOp, entity, strBuff, result);
    }

    @Override
    public GroupProcessResult addOrUpdGroupCtrlConf(boolean isAddOp, GroupResCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new GroupProcessResult(entity.getGroupName(), null, result);
        }
        this.metaConfigMapper.addOrUpdGroupResCtrlConf(isAddOp, entity, strBuff, result);
        return new GroupProcessResult(entity.getGroupName(), null, result);
    }

    @Override
    public GroupProcessResult insertGroupCtrlConf(BaseEntity opEntity, String groupName, int qryPriorityId, EnableStatus flowCtrlEnable, int flowRuleCnt, String flowCtrlRuleInfo, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new GroupProcessResult(groupName, null, result);
        }
        this.metaConfigMapper.insertGroupCtrlConf(opEntity, groupName, qryPriorityId, flowCtrlEnable, flowRuleCnt, flowCtrlRuleInfo, strBuff, result);
        return new GroupProcessResult(groupName, null, result);
    }

    @Override
    public GroupProcessResult insertGroupCtrlConf(BaseEntity opEntity, String groupName, EnableStatus resChkEnable, int allowedB2CRate, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new GroupProcessResult(groupName, null, result);
        }
        this.metaConfigMapper.insertGroupCtrlConf(opEntity, groupName, resChkEnable, allowedB2CRate, strBuff, result);
        return new GroupProcessResult(groupName, null, result);
    }

    @Override
    public GroupProcessResult insertGroupCtrlConf(GroupResCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new GroupProcessResult(entity.getGroupName(), null, result);
        }
        this.metaConfigMapper.insertGroupCtrlConf(entity, strBuff, result);
        return new GroupProcessResult(entity.getGroupName(), null, result);
    }

    @Override
    public GroupProcessResult delGroupResCtrlConf(String operator, String groupName, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new GroupProcessResult(groupName, null, result);
        }
        GroupResCtrlEntity curEntity = this.metaConfigMapper.getGroupCtrlConf(groupName);
        if (curEntity == null) {
            result.setSuccResult();
            return new GroupProcessResult(groupName, null, result);
        }
        if (this.metaConfigMapper.isGroupInUse(groupName)) {
            result.setFailResult(DataOpErrCode.DERR_CONDITION_LACK.getCode(), strBuff.append("Group ").append(groupName).append(" has consume control configures,").append(", please delete consume control configures first!").toString());
            strBuff.delete(0, strBuff.length());
            return new GroupProcessResult(groupName, null, result);
        }
        this.metaConfigMapper.delGroupCtrlConf(operator, groupName, strBuff, result);
        return new GroupProcessResult(groupName, null, result);
    }

    @Override
    public Map<String, GroupResCtrlEntity> getGroupCtrlConf(Set<String> groupSet, GroupResCtrlEntity qryEntity) {
        return this.metaConfigMapper.getGroupCtrlConf(groupSet, qryEntity);
    }

    @Override
    public GroupResCtrlEntity getGroupCtrlConf(String groupName) {
        return this.metaConfigMapper.getGroupCtrlConf(groupName);
    }

    @Override
    public GroupProcessResult addOrUpdConsumeCtrlInfo(boolean isAddOp, BaseEntity opEntity, String groupName, String topicName, EnableStatus enableCsm, String disableRsn, EnableStatus enableFlt, String fltCondStr, StringBuilder strBuff, ProcessResult result) {
        GroupConsumeCtrlEntity entity = new GroupConsumeCtrlEntity(opEntity, groupName, topicName);
        entity.updModifyInfo(opEntity.getDataVerId(), enableCsm, disableRsn, enableFlt, fltCondStr);
        return this.addOrUpdConsumeCtrlInfo(isAddOp, entity, strBuff, result);
    }

    @Override
    public GroupProcessResult addOrUpdConsumeCtrlInfo(boolean isAddOp, GroupConsumeCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new GroupProcessResult(entity.getGroupName(), entity.getTopicName(), result);
        }
        this.metaConfigMapper.addOrUpdConsumeCtrlInfo(isAddOp, entity, strBuff, result);
        return new GroupProcessResult(entity.getGroupName(), entity.getTopicName(), result);
    }

    @Override
    public GroupProcessResult insertConsumeCtrlInfo(BaseEntity opEntity, String groupName, String topicName, EnableStatus enableCsm, String disReason, EnableStatus enableFlt, String fltCondStr, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new GroupProcessResult(groupName, topicName, result);
        }
        this.metaConfigMapper.insertConsumeCtrlInfo(opEntity, groupName, topicName, enableCsm, disReason, enableFlt, fltCondStr, strBuff, result);
        return new GroupProcessResult(groupName, topicName, result);
    }

    @Override
    public GroupProcessResult insertConsumeCtrlInfo(GroupConsumeCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return new GroupProcessResult(entity.getGroupName(), entity.getTopicName(), result);
        }
        this.metaConfigMapper.insertConsumeCtrlInfo(entity, strBuff, result);
        return new GroupProcessResult(entity.getGroupName(), entity.getTopicName(), result);
    }

    @Override
    public boolean delConsumeCtrlConf(String operator, String groupName, String topicName, StringBuilder strBuff, ProcessResult result) {
        if (!this.metaConfigMapper.checkStoreStatus(true, result)) {
            return result.isSuccess();
        }
        GroupConsumeCtrlEntity curEntity = this.metaConfigMapper.getConsumeCtrlByGroupAndTopic(groupName, topicName);
        if (curEntity == null) {
            result.setSuccResult(null);
            return result.isSuccess();
        }
        this.metaConfigMapper.delConsumeCtrlConf(operator, groupName, topicName, strBuff, result);
        return result.isSuccess();
    }

    @Override
    public GroupConsumeCtrlEntity getConsumeCtrlByGroupAndTopic(String groupName, String topicName) {
        return this.metaConfigMapper.getConsumeCtrlByGroupAndTopic(groupName, topicName);
    }

    @Override
    public List<GroupConsumeCtrlEntity> getConsumeCtrlByTopic(String topicName) {
        return this.metaConfigMapper.getConsumeCtrlByTopic(topicName);
    }

    @Override
    public Map<String, List<GroupConsumeCtrlEntity>> getConsumeCtrlByTopic(Set<String> topicSet) {
        return this.metaConfigMapper.getConsumeCtrlByTopic(topicSet);
    }

    @Override
    public Set<String> getDisableTopicByGroupName(String groupName) {
        return this.metaConfigMapper.getDisableTopicByGroupName(groupName);
    }

    @Override
    public List<GroupConsumeCtrlEntity> getConsumeCtrlByGroupName(String groupName) {
        return this.metaConfigMapper.getConsumeCtrlByGroupName(groupName);
    }

    @Override
    public Map<String, List<GroupConsumeCtrlEntity>> getConsumeCtrlByGroupName(Set<String> groupSet) {
        return this.metaConfigMapper.getConsumeCtrlByGroupName(groupSet);
    }

    @Override
    public Map<String, List<GroupConsumeCtrlEntity>> getGroupConsumeCtrlConf(Set<String> groupSet, Set<String> topicSet, GroupConsumeCtrlEntity qryEntry) {
        return this.metaConfigMapper.getGroupConsumeCtrlConf(groupSet, topicSet, qryEntry);
    }
}

