/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity;

import java.util.Objects;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.statusdef.ManageStatus;
import org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys.BdbBrokerConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicPropGroup;

public class BrokerConfEntity
extends BaseEntity
implements Cloneable {
    private int brokerId = -2;
    private String brokerIp = "";
    private int brokerPort = -2;
    private int brokerTLSPort = -2;
    private int brokerWebPort = -2;
    private ManageStatus manageStatus = ManageStatus.STATUS_MANAGE_UNDEFINED;
    private int regionId = -2;
    private int groupId = -2;
    private TopicPropGroup topicProps = new TopicPropGroup();
    private String brokerAddress = "";
    private String brokerFullInfo = "";
    private String brokerSimpleInfo = "";
    private String brokerTLSSimpleInfo = "";
    private String brokerTLSFullInfo = "";

    public BrokerConfEntity() {
    }

    public BrokerConfEntity(BaseEntity opEntity, int brokerId, String brokerIp) {
        super(opEntity);
        this.brokerId = brokerId;
        this.brokerIp = brokerIp;
    }

    public BrokerConfEntity(BaseEntity opEntity, int brokerId, String brokerIp, ClusterSettingEntity defSetting) {
        super(opEntity);
        this.brokerWebPort = defSetting.getBrokerWebPort();
        this.topicProps.updModifyInfo(defSetting.getClsDefTopicProps());
        this.setBrokerIpAndAllPort(brokerId, brokerIp, defSetting.getBrokerPort(), defSetting.getBrokerTLSPort());
    }

    public BrokerConfEntity(BdbBrokerConfEntity bdbEntity) {
        super(bdbEntity.getDataVerId(), bdbEntity.getRecordCreateUser(), bdbEntity.getRecordCreateDate(), bdbEntity.getRecordModifyUser(), bdbEntity.getRecordModifyDate());
        this.setBrokerIpAndAllPort(bdbEntity.getBrokerId(), bdbEntity.getBrokerIp(), bdbEntity.getBrokerPort(), bdbEntity.getBrokerTLSPort());
        this.regionId = bdbEntity.getRegionId();
        this.groupId = bdbEntity.getBrokerGroupId();
        this.brokerWebPort = bdbEntity.getBrokerWebPort();
        this.topicProps = new TopicPropGroup(bdbEntity.getNumTopicStores(), bdbEntity.getDftNumPartitions(), bdbEntity.getDftUnflushThreshold(), bdbEntity.getDftUnflushInterval(), bdbEntity.getDftUnFlushDataHold(), bdbEntity.getDftMemCacheMsgSizeInMB(), bdbEntity.getDftMemCacheMsgCntInK(), bdbEntity.getDftMemCacheFlushIntvl(), bdbEntity.isAcceptPublish(), bdbEntity.isAcceptSubscribe(), bdbEntity.getDftDeletePolicy(), bdbEntity.getDataStoreType(), bdbEntity.getDataPath());
        this.manageStatus = ManageStatus.valueOf(bdbEntity.getManageStatus());
        this.setAttributes(bdbEntity.getAttributes());
    }

    public BdbBrokerConfEntity buildBdbBrokerConfEntity() {
        BdbBrokerConfEntity bdbEntity = new BdbBrokerConfEntity(this.brokerId, this.brokerIp, this.brokerPort, this.topicProps.getNumPartitions(), this.topicProps.getUnflushThreshold(), this.topicProps.getUnflushInterval(), "", this.topicProps.getDeletePolicy(), this.manageStatus.getCode(), this.topicProps.isAcceptPublish(), this.topicProps.isAcceptSubscribe(), this.getAttributes(), true, false, this.getCreateUser(), this.getCreateDate(), this.getModifyUser(), this.getModifyDate());
        bdbEntity.setDataVerId(this.getDataVerId());
        bdbEntity.setRegionId(this.regionId);
        bdbEntity.setBrokerGroupId(this.groupId);
        bdbEntity.setBrokerTLSPort(this.brokerTLSPort);
        bdbEntity.setBrokerWebPort(this.brokerWebPort);
        bdbEntity.setNumTopicStores(this.topicProps.getNumTopicStores());
        bdbEntity.setDftMemCacheMsgSizeInMB(this.topicProps.getMemCacheMsgSizeInMB());
        bdbEntity.setDftMemCacheMsgCntInK(this.topicProps.getMemCacheMsgCntInK());
        bdbEntity.setDftMemCacheFlushIntvl(this.topicProps.getMemCacheFlushIntvl());
        bdbEntity.setDftUnFlushDataHold(this.topicProps.getUnflushDataHold());
        bdbEntity.setDataStore(this.topicProps.getDataStoreType(), this.topicProps.getDataPath());
        bdbEntity.buildStrInfo();
        return bdbEntity;
    }

    public int getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(int brokerId) {
        this.brokerId = brokerId;
    }

    public ManageStatus getManageStatus() {
        return this.manageStatus;
    }

    public String getManageStatusStr() {
        return this.manageStatus.getDescription();
    }

    public void setManageStatus(ManageStatus manageStatus) {
        this.manageStatus = manageStatus;
    }

    public String getBrokerAddress() {
        return this.brokerAddress;
    }

    public String getBrokerIp() {
        return this.brokerIp;
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public void setBrokerIpAndAllPort(int brokerId, String brokerIp, int brokerPort, int brokerTLSPort) {
        this.brokerId = brokerId;
        this.brokerIp = brokerIp;
        this.brokerPort = brokerPort;
        this.brokerTLSPort = brokerTLSPort;
        this.buildStrInfo();
    }

    public int getBrokerWebPort() {
        return this.brokerWebPort;
    }

    public void setBrokerWebPort(int brokerWebPort) {
        this.brokerWebPort = brokerWebPort;
    }

    public int getBrokerTLSPort() {
        return this.brokerTLSPort;
    }

    public String getBrokerIdAndAddress() {
        return this.brokerFullInfo;
    }

    public String getSimpleBrokerInfo() {
        if (this.brokerPort == 8123) {
            return this.brokerSimpleInfo;
        }
        return this.brokerFullInfo;
    }

    public String getSimpleTLSBrokerInfo() {
        if (this.getBrokerTLSPort() == 8124) {
            return this.brokerTLSSimpleInfo;
        }
        return this.brokerTLSFullInfo;
    }

    public String getBrokerTLSFullInfo() {
        return this.brokerTLSFullInfo;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public void setRegionId(int regionId) {
        this.regionId = regionId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public TopicPropGroup getTopicProps() {
        return this.topicProps;
    }

    public void setTopicProps(TopicPropGroup topicProps) {
        this.topicProps = topicProps;
    }

    private void buildStrInfo() {
        StringBuilder sBuilder = new StringBuilder(512);
        this.brokerAddress = sBuilder.append(this.brokerIp).append(":").append(this.brokerPort).toString();
        sBuilder.delete(0, sBuilder.length());
        this.brokerSimpleInfo = sBuilder.append(this.brokerId).append(":").append(this.brokerIp).append(":").append(" ").toString();
        sBuilder.delete(0, sBuilder.length());
        this.brokerFullInfo = sBuilder.append(this.brokerId).append(":").append(this.brokerIp).append(":").append(this.brokerPort).toString();
        sBuilder.delete(0, sBuilder.length());
        this.brokerTLSSimpleInfo = sBuilder.append(this.brokerId).append(":").append(this.brokerIp).append(":").append(" ").toString();
        sBuilder.delete(0, sBuilder.length());
        this.brokerTLSFullInfo = sBuilder.append(this.brokerId).append(":").append(this.brokerIp).append(":").append(this.brokerTLSPort).toString();
    }

    public boolean updModifyInfo(long dataVerId, int brokerPort, int brokerTlsPort, int brokerWebPort, int regionId, int groupId, ManageStatus manageStatus, TopicPropGroup topicProps) {
        boolean changed = false;
        if (dataVerId != -2L && this.getDataVerId() != dataVerId) {
            changed = true;
            this.setDataVersionId(dataVerId);
        }
        if (brokerPort != -2 && this.brokerPort != brokerPort) {
            changed = true;
            this.brokerPort = brokerPort;
        }
        if (brokerTlsPort != -2 && this.brokerTLSPort != brokerTlsPort) {
            changed = true;
            this.brokerTLSPort = brokerTlsPort;
        }
        if (brokerWebPort != -2 && this.brokerWebPort != brokerWebPort) {
            changed = true;
            this.brokerWebPort = brokerWebPort;
        }
        if (regionId != -2 && this.regionId != regionId) {
            changed = true;
            this.regionId = regionId;
        }
        if (groupId != -2 && this.groupId != groupId) {
            changed = true;
            this.groupId = groupId;
        }
        if (manageStatus != null && manageStatus != ManageStatus.STATUS_MANAGE_UNDEFINED && this.manageStatus != manageStatus) {
            changed = true;
            this.manageStatus = manageStatus;
        }
        if (topicProps != null && !topicProps.isDataEquals(this.topicProps) && this.topicProps.updModifyInfo(topicProps)) {
            changed = true;
        }
        if (changed) {
            this.buildStrInfo();
            this.updSerialId();
        }
        return changed;
    }

    public boolean isMatched(BrokerConfEntity target) {
        if (target == null) {
            return true;
        }
        if (!super.isMatched(target)) {
            return false;
        }
        return !(target.getBrokerId() != -2 && target.getBrokerId() != this.brokerId || !TStringUtils.isBlank((String)target.getBrokerIp()) && !target.getBrokerIp().equals(this.brokerIp) || target.getBrokerPort() != -2 && target.getBrokerPort() != this.brokerPort || target.getBrokerTLSPort() != -2 && target.getBrokerTLSPort() != this.brokerTLSPort || target.getRegionId() != -2 && target.getRegionId() != this.regionId || target.getGroupId() != -2 && target.getGroupId() != this.groupId || target.getManageStatus() != ManageStatus.STATUS_MANAGE_UNDEFINED && target.getManageStatus() != this.manageStatus || target.getBrokerWebPort() != -2 && target.getBrokerWebPort() != this.brokerWebPort || !this.topicProps.isMatched(target.getTopicProps()));
    }

    public StringBuilder toWebJsonStr(StringBuilder sBuffer, boolean isConfUpdated, boolean isConfLoaded, boolean isLongName, boolean fullFormat) {
        if (isLongName) {
            sBuffer.append("{\"brokerId\":").append(this.brokerId).append(",\"brokerIp\":\"").append(this.brokerIp).append("\"").append(",\"brokerPort\":").append(this.brokerPort).append(",\"brokerTLSPort\":").append(this.brokerTLSPort).append(",\"brokerWebPort\":").append(this.brokerWebPort).append(",\"manageStatus\":\"").append(this.manageStatus.getDescription()).append("\"").append(",\"isConfChanged\":").append(isConfUpdated).append(",\"isConfLoaded\":").append(isConfLoaded).append(",\"regionId\":").append(this.regionId).append(",\"groupId\":").append(this.groupId);
        } else {
            sBuffer.append("{\"brkId\":").append(this.brokerId).append(",\"bIp\":\"").append(this.brokerIp).append("\"").append(",\"bPort\":").append(this.brokerPort).append(",\"bTlsPort\":").append(this.brokerTLSPort).append(",\"bWebPort\":").append(this.brokerWebPort).append(",\"mSts\":\"").append(this.manageStatus.getDescription()).append("\"").append(",\"isConfChg\":").append(isConfUpdated).append(",\"isConfLd\":").append(isConfLoaded).append(",\"rId\":").append(this.regionId).append(",\"gId\":").append(this.groupId);
        }
        this.topicProps.toWebJsonStr(sBuffer, isLongName);
        super.toWebJsonStr(sBuffer, isLongName);
        if (fullFormat) {
            sBuffer.append("}");
        }
        return sBuffer;
    }

    public void getBrokerDefaultConfInfo(ClusterSettingEntity defSetting, StringBuilder strBuff) {
        TopicPropGroup defTopicProps = defSetting.getClsDefTopicProps();
        strBuff.append(this.topicProps.getNumPartitions() == -2 ? defTopicProps.getNumPartitions() : this.topicProps.getNumPartitions()).append(":").append(this.topicProps.getAcceptPublish() == null ? defTopicProps.isAcceptPublish() : this.topicProps.isAcceptPublish()).append(":").append(this.topicProps.getAcceptSubscribe() == null ? defTopicProps.isAcceptSubscribe() : this.topicProps.isAcceptSubscribe()).append(":").append(this.topicProps.getUnflushThreshold() == -2 ? defTopicProps.getUnflushThreshold() : this.topicProps.getUnflushThreshold()).append(":").append(this.topicProps.getUnflushInterval() == -2 ? defTopicProps.getUnflushInterval() : this.topicProps.getUnflushInterval()).append(":").append(" ").append(":").append(TStringUtils.isEmpty((String)this.topicProps.getDeletePolicy()) ? defTopicProps.getDeletePolicy() : this.topicProps.getDeletePolicy()).append(":").append(this.topicProps.getNumTopicStores() == -2 ? defTopicProps.getNumTopicStores() : this.topicProps.getNumTopicStores()).append(":").append(this.topicProps.getUnflushDataHold() == -2 ? defTopicProps.getUnflushDataHold() : this.topicProps.getUnflushDataHold()).append(":").append(this.topicProps.getMemCacheMsgSizeInMB() == -2 ? defTopicProps.getMemCacheMsgSizeInMB() : this.topicProps.getMemCacheMsgSizeInMB()).append(":").append(this.topicProps.getMemCacheMsgCntInK() == -2 ? defTopicProps.getMemCacheMsgCntInK() : this.topicProps.getMemCacheMsgCntInK()).append(":").append(this.topicProps.getMemCacheFlushIntvl() == -2 ? defTopicProps.getMemCacheFlushIntvl() : this.topicProps.getMemCacheFlushIntvl());
    }

    public boolean isDataEquals(BrokerConfEntity other) {
        return super.isDataEquals(other) && this.brokerId == other.brokerId && this.brokerPort == other.brokerPort && this.brokerTLSPort == other.brokerTLSPort && this.brokerWebPort == other.brokerWebPort && this.regionId == other.regionId && this.groupId == other.groupId && Objects.equals(this.brokerIp, other.brokerIp) && this.manageStatus == other.manageStatus && Objects.equals(this.topicProps, other.topicProps) && Objects.equals(this.brokerAddress, other.brokerAddress) && Objects.equals(this.brokerFullInfo, other.brokerFullInfo) && Objects.equals(this.brokerSimpleInfo, other.brokerSimpleInfo) && Objects.equals(this.brokerTLSSimpleInfo, other.brokerTLSSimpleInfo) && Objects.equals(this.brokerTLSFullInfo, other.brokerTLSFullInfo);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrokerConfEntity)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BrokerConfEntity entity = (BrokerConfEntity)o;
        return this.isDataEquals(entity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.brokerId, this.brokerIp, this.brokerPort, this.brokerTLSPort, this.brokerWebPort, this.manageStatus, this.regionId, this.groupId, this.topicProps, this.brokerAddress, this.brokerFullInfo, this.brokerSimpleInfo, this.brokerTLSSimpleInfo, this.brokerTLSFullInfo});
    }

    @Override
    public BrokerConfEntity clone() {
        BrokerConfEntity copy = (BrokerConfEntity)super.clone();
        copy.setManageStatus(this.getManageStatus());
        if (copy.getTopicProps() != null) {
            copy.setTopicProps(this.getTopicProps().clone());
        }
        return copy;
    }
}

