/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.ConcurrentHashSet;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.common.utils.RowLock;
import org.apache.inlong.tubemq.server.master.MasterConfig;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumeGroupInfo;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerInfo;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.RebProcessInfo;
import org.apache.inlong.tubemq.server.master.stats.MasterSrvStatsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerInfoHolder {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerInfoHolder.class);
    private final MasterConfig masterConfig;
    private final RowLock groupRowLock;
    private final ConcurrentHashMap<String, ConsumeGroupInfo> groupInfoMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> consumerIndexMap = new ConcurrentHashMap();
    private final ConcurrentHashSet<String> serverBalanceGroupSet = new ConcurrentHashSet();
    private final ConcurrentHashSet<String> clientBalanceGroupSet = new ConcurrentHashSet();
    private final ConcurrentHashMap<String, ConcurrentHashSet<String>> topicGroupMap = new ConcurrentHashMap();

    public ConsumerInfoHolder(TMaster tMaster) {
        this.masterConfig = tMaster.getMasterConfig();
        this.groupRowLock = new RowLock("Group-RowLock", this.masterConfig.getRowLockWaitDurMs());
    }

    public int getDefResourceRate() {
        return this.masterConfig.getMaxGroupBrokerConsumeRate();
    }

    public boolean isConsumeGroupEmpty(String groupName) {
        if (groupName == null) {
            return true;
        }
        ConsumeGroupInfo consumeGroupInfo = this.groupInfoMap.get(groupName);
        return consumeGroupInfo == null || consumeGroupInfo.isGroupEmpty();
    }

    public List<String> getConsumerIdList(String group) {
        if (group == null) {
            return Collections.emptyList();
        }
        ConsumeGroupInfo consumeGroupInfo = this.groupInfoMap.get(group);
        if (consumeGroupInfo == null) {
            return Collections.emptyList();
        }
        return consumeGroupInfo.getConsumerIdList();
    }

    public List<String> getConsumerViewList(String group) {
        if (group == null) {
            return Collections.emptyList();
        }
        ConsumeGroupInfo consumeGroupInfo = this.groupInfoMap.get(group);
        if (consumeGroupInfo == null) {
            return Collections.emptyList();
        }
        return consumeGroupInfo.getConsumerViewInfos();
    }

    public List<Tuple2<String, Boolean>> getConsumerIdAndTlsInfos(String group) {
        if (group == null) {
            return Collections.emptyList();
        }
        ConsumeGroupInfo consumeGroupInfo = this.groupInfoMap.get(group);
        if (consumeGroupInfo == null) {
            return Collections.emptyList();
        }
        return consumeGroupInfo.getConsumerIdAndTlsInfos();
    }

    public ConsumeGroupInfo getConsumeGroupInfo(String group) {
        if (group == null) {
            return null;
        }
        return this.groupInfoMap.get(group);
    }

    public Long addCurCheckCycle(String group) {
        if (group == null) {
            return null;
        }
        ConsumeGroupInfo consumeGroupInfo = this.groupInfoMap.get(group);
        if (consumeGroupInfo != null) {
            return consumeGroupInfo.addCurCheckCycle();
        }
        return null;
    }

    public Set<String> getGroupTopicSet(String group) {
        if (group == null) {
            return Collections.emptySet();
        }
        ConsumeGroupInfo consumeGroupInfo = this.groupInfoMap.get(group);
        if (consumeGroupInfo != null) {
            return consumeGroupInfo.getTopicSet();
        }
        return Collections.emptySet();
    }

    public int getConsumerCnt(String group) {
        ConsumeGroupInfo consumeGroupInfo;
        int count = 0;
        if (group != null && (consumeGroupInfo = this.groupInfoMap.get(group)) != null) {
            count = consumeGroupInfo.getGroupCnt();
        }
        return count;
    }

    public RebProcessInfo getNeedRebNodeList(String group) {
        RebProcessInfo rebProcessInfo = new RebProcessInfo();
        if (group == null) {
            return rebProcessInfo;
        }
        ConsumeGroupInfo consumeGroupInfo = this.groupInfoMap.get(group);
        if (consumeGroupInfo != null) {
            rebProcessInfo = consumeGroupInfo.getNeedBalanceNodes();
        }
        return rebProcessInfo;
    }

    public void setRebNodeProcessed(String group, List<String> processList) {
        if (group == null) {
            return;
        }
        ConsumeGroupInfo consumeGroupInfo = this.groupInfoMap.get(group);
        if (consumeGroupInfo != null) {
            consumeGroupInfo.setBalanceNodeProcessed(processList);
        }
    }

    public void addRebConsumerInfo(String group, Set<String> consumerIdSet, int waitDuration) {
        ConsumeGroupInfo consumeGroupInfo = this.groupInfoMap.get(group);
        if (consumeGroupInfo != null) {
            for (String consumerId : consumerIdSet) {
                String oldGroup = this.consumerIndexMap.get(consumerId);
                if (!group.equals(oldGroup)) continue;
                consumeGroupInfo.addNodeRelInfo(consumerId, waitDuration);
            }
        }
    }

    public boolean isNotAllocated(String group) {
        if (group == null) {
            return false;
        }
        ConsumeGroupInfo consumeGroupInfo = this.groupInfoMap.get(group);
        if (consumeGroupInfo != null) {
            return consumeGroupInfo.isNotAllocate();
        }
        return false;
    }

    public String getGroupName(String consumerId) {
        return this.consumerIndexMap.get(consumerId);
    }

    public List<String> getAllGroupName() {
        if (this.groupInfoMap.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.groupInfoMap.keySet());
    }

    public ConcurrentHashMap<String, ConcurrentHashSet<String>> getRegTopicGroupMap() {
        return this.topicGroupMap;
    }

    public List<String> getAllServerBalanceGroups() {
        if (this.serverBalanceGroupSet.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<String>((Collection<String>)this.serverBalanceGroupSet);
    }

    public List<String> getAllClientBalanceGroups() {
        if (this.clientBalanceGroupSet.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<String>((Collection<String>)this.clientBalanceGroupSet);
    }

    public ConsumerInfo getConsumerInfo(String consumerId) {
        ConsumeGroupInfo consumeGroupInfo;
        ConsumerInfo consumerInfo = null;
        String groupName = this.consumerIndexMap.get(consumerId);
        if (groupName != null && (consumeGroupInfo = this.groupInfoMap.get(groupName)) != null) {
            consumerInfo = consumeGroupInfo.getConsumerInfo(consumerId);
        }
        return consumerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConsumer(ConsumerInfo consumer, boolean isNotAllocated, StringBuilder strBuff, ProcessResult result) {
        String group = consumer.getGroupName();
        Integer lid = null;
        try {
            ConsumeGroupInfo tmpGroupInfo;
            lid = this.groupRowLock.getLock(null, StringUtils.getBytesUtf8((String)group), true);
            ConsumeGroupInfo consumeGroupInfo = this.groupInfoMap.get(group);
            if (consumeGroupInfo == null && (consumeGroupInfo = this.groupInfoMap.putIfAbsent(group, tmpGroupInfo = new ConsumeGroupInfo(consumer))) == null) {
                consumeGroupInfo = tmpGroupInfo;
                if (tmpGroupInfo.isClientBalance()) {
                    this.clientBalanceGroupSet.add((Object)group);
                } else {
                    this.serverBalanceGroupSet.add((Object)group);
                }
                for (String topicName : consumeGroupInfo.getTopicSet()) {
                    ConcurrentHashSet tmpGroupSet;
                    ConcurrentHashSet groupSet = this.topicGroupMap.get(topicName);
                    if (groupSet == null && (groupSet = this.topicGroupMap.putIfAbsent(topicName, (ConcurrentHashSet<String>)(tmpGroupSet = new ConcurrentHashSet()))) == null) {
                        groupSet = tmpGroupSet;
                    }
                    groupSet.add((Object)group);
                }
                MasterSrvStatsHolder.incConsumerCnt(true, consumeGroupInfo.isClientBalance());
            }
            if (consumeGroupInfo.addConsumer(consumer, strBuff, result)) {
                if (((Boolean)result.getRetData()).booleanValue()) {
                    MasterSrvStatsHolder.incConsumerCnt(false, consumeGroupInfo.isClientBalance());
                }
                if (!isNotAllocated) {
                    consumeGroupInfo.settAllocated();
                }
                this.consumerIndexMap.put(consumer.getConsumerId(), group);
                result.setSuccResult((Object)consumeGroupInfo);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to lock.", (Throwable)e);
        }
        finally {
            if (lid != null) {
                this.groupRowLock.releaseRowLock(lid);
            }
        }
        return result.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerInfo removeConsumer(String group, String consumerId, boolean isTimeout) {
        if (group == null || consumerId == null) {
            return null;
        }
        boolean isCltBal = false;
        ConsumerInfo consumer = null;
        Integer lid = null;
        try {
            lid = this.groupRowLock.getLock(null, StringUtils.getBytesUtf8((String)group), true);
            ConsumeGroupInfo consumeGroupInfo = this.groupInfoMap.get(group);
            if (consumeGroupInfo != null) {
                consumer = consumeGroupInfo.removeConsumer(consumerId);
                if (consumeGroupInfo.isGroupEmpty()) {
                    boolean rmvGroup;
                    boolean bl = rmvGroup = this.groupInfoMap.remove(group) != null;
                    if (consumeGroupInfo.isClientBalance()) {
                        isCltBal = true;
                        this.clientBalanceGroupSet.remove((Object)group);
                    } else {
                        this.serverBalanceGroupSet.remove((Object)group);
                    }
                    for (String topicName : consumeGroupInfo.getTopicSet()) {
                        ConcurrentHashSet<String> groupSet = this.topicGroupMap.get(topicName);
                        if (groupSet == null) continue;
                        groupSet.remove((Object)group);
                    }
                    if (rmvGroup) {
                        if (consumer == null) {
                            MasterSrvStatsHolder.decConsumeGroupCnt(isTimeout, isCltBal);
                        } else {
                            MasterSrvStatsHolder.decConsumerCnt(isTimeout, true, isCltBal);
                        }
                    }
                } else if (consumer != null) {
                    MasterSrvStatsHolder.decConsumerCnt(isTimeout, false, false);
                }
            }
            this.consumerIndexMap.remove(consumerId);
        }
        catch (IOException e) {
            logger.warn("Failed to lock.", (Throwable)e);
        }
        finally {
            if (lid != null) {
                this.groupRowLock.releaseRowLock(lid);
            }
        }
        return consumer;
    }
}

