/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.utils;

import org.apache.inlong.tubemq.server.Stoppable;
import org.apache.inlong.tubemq.server.common.utils.HasThread;
import org.apache.inlong.tubemq.server.common.utils.Sleeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Chore
extends HasThread {
    protected final Stoppable stopper;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Sleeper sleeper;

    public Chore(String name, int p, Stoppable stopper) {
        super(name);
        this.sleeper = new Sleeper(p, stopper);
        this.stopper = stopper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean initialChoreComplete = false;
            while (!this.stopper.isStopped()) {
                long startTime = System.currentTimeMillis();
                try {
                    if (!initialChoreComplete) {
                        initialChoreComplete = this.initialChore();
                    } else {
                        this.chore();
                    }
                }
                catch (Exception e) {
                    this.logger.error("Caught exception", (Throwable)e);
                    if (this.stopper.isStopped()) continue;
                }
                this.sleeper.sleep(startTime);
            }
        }
        catch (Throwable t) {
            this.logger.error(this.getName() + "error", t);
        }
        finally {
            this.logger.info(this.getName() + " exiting");
            this.cleanup();
        }
    }

    public void triggerNow() {
        this.sleeper.skipSleepCycle();
    }

    public void choreForTesting() {
        this.chore();
    }

    protected boolean initialChore() {
        return true;
    }

    protected abstract void chore();

    protected void sleep() {
        this.sleeper.sleep();
    }

    protected void cleanup() {
    }
}

