/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.metamanage.MetaDataService;

public class MasterStatusCheckFilter
implements Filter {
    private TMaster master;
    private MetaDataService defMetaDataService;

    public MasterStatusCheckFilter(TMaster master) {
        this.master = master;
        this.defMetaDataService = this.master.getMetaDataService();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (!this.defMetaDataService.isSelfMaster()) {
            String masterAdd = this.defMetaDataService.getMasterAddress();
            if (masterAdd == null) {
                throw new IOException("Not found the master node address!");
            }
            StringBuilder sBuilder = new StringBuilder(512).append("http://").append(masterAdd).append(":").append(this.master.getMasterConfig().getWebPort()).append(req.getRequestURI());
            if (TStringUtils.isNotBlank((String)req.getQueryString())) {
                sBuilder.append("?").append(req.getQueryString());
            }
            resp.sendRedirect(sBuilder.toString());
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

