/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.tools;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.fielddef.CliArgDef;

public class CliUtils {
    public static boolean getConfigFilePath(String[] args, ProcessResult result) {
        Options options = new Options();
        Option fileOption = new Option(CliArgDef.FILEPATH.opt, CliArgDef.FILEPATH.longOpt, CliArgDef.FILEPATH.hasArg, CliArgDef.FILEPATH.optDesc);
        if (CliArgDef.FILEPATH.hasArg) {
            fileOption.setArgName(CliArgDef.FILEPATH.argDesc);
        }
        options.addOption(fileOption);
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cli = parser.parse(options, args);
            if (cli == null) {
                result.setFailResult("Parse args failure");
                return result.isSuccess();
            }
            if (!cli.hasOption(CliArgDef.FILEPATH.longOpt)) {
                result.setFailResult(new StringBuilder(512).append("Please input the configuration file path by ").append("-").append(CliArgDef.FILEPATH.opt).append(" or ").append("-").append(CliArgDef.FILEPATH.longOpt).append(" option").toString());
                return result.isSuccess();
            }
            String configFilePath = cli.getOptionValue(CliArgDef.FILEPATH.longOpt);
            if (TStringUtils.isBlank((String)configFilePath)) {
                result.setFailResult(new StringBuilder(512).append(CliArgDef.FILEPATH.longOpt).append(" is required!").toString());
                return result.isSuccess();
            }
            result.setSuccResult((Object)configFilePath);
        }
        catch (Throwable e) {
            result.setFailResult(new StringBuilder(512).append("Parse configuration file path failure: ").append(e.toString()).toString());
        }
        return result.isSuccess();
    }
}

