/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support;

import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.AttributeBindings;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.MethodArgumentsExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.MethodCache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.MethodExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.ParameterAttributeNamesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public final class MethodSpanAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final MethodExtractor<REQUEST> methodExtractor;
    private final MethodArgumentsExtractor<REQUEST> methodArgumentsExtractor;
    private final Cache<Method, AttributeBindings> cache;
    private final ParameterAttributeNamesExtractor parameterAttributeNamesExtractor;

    public static <REQUEST, RESPONSE> MethodSpanAttributesExtractor<REQUEST, RESPONSE> create(MethodExtractor<REQUEST> methodExtractor, ParameterAttributeNamesExtractor parameterAttributeNamesExtractor, MethodArgumentsExtractor<REQUEST> methodArgumentsExtractor) {
        return new MethodSpanAttributesExtractor<REQUEST, RESPONSE>(methodExtractor, parameterAttributeNamesExtractor, methodArgumentsExtractor, new MethodCache<AttributeBindings>());
    }

    MethodSpanAttributesExtractor(MethodExtractor<REQUEST> methodExtractor, ParameterAttributeNamesExtractor parameterAttributeNamesExtractor, MethodArgumentsExtractor<REQUEST> methodArgumentsExtractor, Cache<Method, AttributeBindings> cache) {
        this.methodExtractor = methodExtractor;
        this.methodArgumentsExtractor = methodArgumentsExtractor;
        this.parameterAttributeNamesExtractor = parameterAttributeNamesExtractor;
        this.cache = cache;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        Method method = this.methodExtractor.extract(request);
        AttributeBindings bindings = this.cache.computeIfAbsent(method, m4 -> AttributeBindings.bind(m4, this.parameterAttributeNamesExtractor));
        if (!bindings.isEmpty()) {
            Object[] args = this.methodArgumentsExtractor.extract(request);
            bindings.apply(attributes, args);
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

