/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.send;

import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.audit.entity.AuditComponent;
import org.apache.inlong.audit.entity.AuditProxy;
import org.apache.inlong.audit.entity.CommonResponse;
import org.apache.inlong.audit.utils.HttpUtils;
import org.apache.inlong.audit.utils.NamedThreadFactory;
import org.apache.inlong.audit.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyManager.class);
    private static final ProxyManager instance = new ProxyManager();
    private final List<String> currentIpPorts = new CopyOnWriteArrayList<String>();
    private final ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("inlong-audit-proxy-manager"));
    private static final String GET_AUDIT_PROXY_API_PATH = "/inlong/manager/openapi/audit/getAuditProxy";
    private int timeoutMs = 10000;
    private int updateInterval = 60000;
    private String auditProxyApiUrl;
    private AuditComponent component;
    private String secretId;
    private String secretKey;
    private volatile boolean timerStarted = false;
    private static final int MAX_RETRY_TIMES = 1440;
    private static final int RETRY_INTERVAL_MS = 10000;

    private ProxyManager() {
    }

    public static ProxyManager getInstance() {
        return instance;
    }

    public synchronized void setAuditProxy(HashSet<String> ipPortList) {
        if (!ipPortList.equals(new HashSet<String>(this.currentIpPorts))) {
            this.currentIpPorts.clear();
            this.currentIpPorts.addAll(ipPortList);
        }
    }

    public synchronized void setManagerConfig(AuditComponent component, String managerHost, String secretId, String secretKey) {
        if (!managerHost.startsWith("http://") && !managerHost.startsWith("https://")) {
            managerHost = "http://" + managerHost;
        }
        this.auditProxyApiUrl = String.format("%s%s", managerHost, GET_AUDIT_PROXY_API_PATH);
        LOGGER.info("Audit Proxy API URL: {}", (Object)this.auditProxyApiUrl);
        this.component = component;
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.retryAsync();
    }

    private void retryAsync() {
        CompletableFuture.runAsync(() -> {
            long retryIntervalMs = 10000L;
            for (int retryTime = 1; retryTime < 1440; ++retryTime) {
                try {
                    if (this.updateAuditProxy()) {
                        LOGGER.info("Audit proxy updated successfully");
                        break;
                    }
                    LOGGER.warn("Failed to update audit proxy. Retrying in {} times...", (Object)retryTime);
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to update audit proxy. Retrying in {} times...", (Object)retryTime, (Object)exception);
                    continue;
                }
                finally {
                    ThreadUtils.sleep(Math.min(retryIntervalMs, (long)this.updateInterval));
                    retryIntervalMs *= 2L;
                }
            }
        });
    }

    private boolean updateAuditProxy() {
        String response = HttpUtils.httpGet(this.component.getComponent(), this.auditProxyApiUrl, this.secretId, this.secretKey, this.timeoutMs);
        if (response == null) {
            LOGGER.error("Response is null: {} {} {} ", this.component.getComponent(), this.auditProxyApiUrl, this.secretId, this.secretKey);
            return false;
        }
        CommonResponse commonResponse = CommonResponse.fromJson(response, AuditProxy.class);
        if (commonResponse == null || commonResponse.getData().isEmpty()) {
            LOGGER.error("No data in the response: {} {} {} {}", this.component.getComponent(), this.auditProxyApiUrl, this.secretId, this.secretKey);
            return false;
        }
        HashSet<String> proxyList = new HashSet<String>();
        for (AuditProxy auditProxy : commonResponse.getData()) {
            proxyList.add(auditProxy.toString());
        }
        this.setAuditProxy(proxyList);
        LOGGER.info("Get audit proxy from manager: {}", (Object)proxyList);
        return true;
    }

    private synchronized void startTimer() {
        if (this.timerStarted) {
            return;
        }
        this.timer.scheduleWithFixedDelay(this::updateAuditProxy, this.updateInterval, this.updateInterval, TimeUnit.MILLISECONDS);
        this.timerStarted = true;
    }

    public void setManagerTimeout(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public void setAutoUpdateAuditProxy() {
        this.startTimer();
        LOGGER.info("Auto update Audit Proxy info from manager");
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    public InetSocketAddress getInetSocketAddress() {
        if (this.currentIpPorts.isEmpty()) {
            return null;
        }
        Random rand = new Random();
        String randomElement = this.currentIpPorts.get(rand.nextInt(this.currentIpPorts.size()));
        String[] ipPort = randomElement.split(":");
        if (ipPort.length != 2) {
            LOGGER.error("Invalid IP:Port format: {}", (Object)randomElement);
            return null;
        }
        return new InetSocketAddress(ipPort[0], Integer.parseInt(ipPort[1]));
    }

    public void shutdown() {
        this.timer.shutdown();
    }
}

