/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.pojo.sort;

import java.io.Serializable;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.common.pojo.sort.dataflow.DataFlowConfig;
import org.apache.inlong.common.pojo.sort.mq.MqClusterConfig;
import org.apache.inlong.common.util.SortConfigUtil;

public class ClusterTagConfig
implements Serializable {
    private String clusterTag;
    private List<MqClusterConfig> mqClusterConfigs;
    private List<DataFlowConfig> dataFlowConfigs;

    public static ClusterTagConfig checkDelete(ClusterTagConfig last, ClusterTagConfig current) {
        if (CollectionUtils.isEmpty(current.getMqClusterConfigs())) {
            return last;
        }
        return ClusterTagConfig.check(last, current, MqClusterConfig::batchCheckLast, DataFlowConfig::batchCheckDelete);
    }

    public static ClusterTagConfig checkNew(ClusterTagConfig last, ClusterTagConfig current) {
        return ClusterTagConfig.check(last, current, MqClusterConfig::batchCheckLatest, DataFlowConfig::batchCheckNew);
    }

    public static ClusterTagConfig checkUpdate(ClusterTagConfig last, ClusterTagConfig current) {
        List<MqClusterConfig> updateCluster = MqClusterConfig.batchCheckUpdate(last.getMqClusterConfigs(), current.getMqClusterConfigs());
        List<MqClusterConfig> latestCluster = MqClusterConfig.batchCheckLatest(last.getMqClusterConfigs(), current.getMqClusterConfigs());
        List<MqClusterConfig> deleteCluster = MqClusterConfig.batchCheckDelete(last.getMqClusterConfigs(), current.getMqClusterConfigs());
        List<MqClusterConfig> newCluster = MqClusterConfig.batchCheckNew(last.getMqClusterConfigs(), current.getMqClusterConfigs());
        List<DataFlowConfig> updateDataflows = DataFlowConfig.batchCheckUpdate(last.getDataFlowConfigs(), current.getDataFlowConfigs());
        if (CollectionUtils.isNotEmpty(updateCluster) || CollectionUtils.isNotEmpty(deleteCluster) || CollectionUtils.isNotEmpty(newCluster)) {
            List<DataFlowConfig> noUpdateDataflows = DataFlowConfig.batchCheckNoUpdate(last.getDataFlowConfigs(), current.getDataFlowConfigs());
            noUpdateDataflows.addAll(updateDataflows);
            return ClusterTagConfig.builder().clusterTag(last.getClusterTag()).mqClusterConfigs(latestCluster).dataFlowConfigs(noUpdateDataflows).build();
        }
        if (CollectionUtils.isEmpty(updateDataflows)) {
            return null;
        }
        return ClusterTagConfig.builder().clusterTag(last.getClusterTag()).mqClusterConfigs(latestCluster).dataFlowConfigs(updateDataflows).build();
    }

    public static ClusterTagConfig checkLatest(ClusterTagConfig last, ClusterTagConfig current) {
        if (CollectionUtils.isEmpty(current.getMqClusterConfigs())) {
            return null;
        }
        return ClusterTagConfig.check(last, current, MqClusterConfig::batchCheckLatest, DataFlowConfig::batchCheckLatest);
    }

    public static List<ClusterTagConfig> batchCheckDelete(List<ClusterTagConfig> last, List<ClusterTagConfig> current) {
        return SortConfigUtil.batchCheckDeleteRecursive(last, current, ClusterTagConfig::getClusterTag, ClusterTagConfig::checkDelete);
    }

    public static List<ClusterTagConfig> batchCheckNew(List<ClusterTagConfig> last, List<ClusterTagConfig> current) {
        return SortConfigUtil.batchCheckNewRecursive(last, current, ClusterTagConfig::getClusterTag, ClusterTagConfig::checkNew);
    }

    public static List<ClusterTagConfig> batchCheckUpdate(List<ClusterTagConfig> last, List<ClusterTagConfig> current) {
        return SortConfigUtil.batchCheckUpdateRecursive(last, current, ClusterTagConfig::getClusterTag, ClusterTagConfig::checkUpdate);
    }

    public static List<ClusterTagConfig> batchCheckLatest(List<ClusterTagConfig> last, List<ClusterTagConfig> current) {
        return SortConfigUtil.batchCheckLatestRecursive(last, current, ClusterTagConfig::getClusterTag, ClusterTagConfig::checkLatest);
    }

    public static ClusterTagConfig check(ClusterTagConfig last, ClusterTagConfig current, BiFunction<List<MqClusterConfig>, List<MqClusterConfig>, List<MqClusterConfig>> mqCheckFunction, BiFunction<List<DataFlowConfig>, List<DataFlowConfig>, List<DataFlowConfig>> flowCheckFunction) {
        List<MqClusterConfig> checkMqCluster = mqCheckFunction.apply(last.getMqClusterConfigs(), current.getMqClusterConfigs());
        List<DataFlowConfig> checkDataflows = flowCheckFunction.apply(last.getDataFlowConfigs(), current.getDataFlowConfigs());
        if (CollectionUtils.isEmpty(checkDataflows)) {
            return null;
        }
        return ClusterTagConfig.builder().clusterTag(last.getClusterTag()).mqClusterConfigs(checkMqCluster).dataFlowConfigs(checkDataflows).build();
    }

    public static ClusterTagConfigBuilder builder() {
        return new ClusterTagConfigBuilder();
    }

    public String getClusterTag() {
        return this.clusterTag;
    }

    public List<MqClusterConfig> getMqClusterConfigs() {
        return this.mqClusterConfigs;
    }

    public List<DataFlowConfig> getDataFlowConfigs() {
        return this.dataFlowConfigs;
    }

    public void setClusterTag(String clusterTag) {
        this.clusterTag = clusterTag;
    }

    public void setMqClusterConfigs(List<MqClusterConfig> mqClusterConfigs) {
        this.mqClusterConfigs = mqClusterConfigs;
    }

    public void setDataFlowConfigs(List<DataFlowConfig> dataFlowConfigs) {
        this.dataFlowConfigs = dataFlowConfigs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterTagConfig)) {
            return false;
        }
        ClusterTagConfig other = (ClusterTagConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clusterTag = this.getClusterTag();
        String other$clusterTag = other.getClusterTag();
        if (this$clusterTag == null ? other$clusterTag != null : !this$clusterTag.equals(other$clusterTag)) {
            return false;
        }
        List<MqClusterConfig> this$mqClusterConfigs = this.getMqClusterConfigs();
        List<MqClusterConfig> other$mqClusterConfigs = other.getMqClusterConfigs();
        if (this$mqClusterConfigs == null ? other$mqClusterConfigs != null : !((Object)this$mqClusterConfigs).equals(other$mqClusterConfigs)) {
            return false;
        }
        List<DataFlowConfig> this$dataFlowConfigs = this.getDataFlowConfigs();
        List<DataFlowConfig> other$dataFlowConfigs = other.getDataFlowConfigs();
        return !(this$dataFlowConfigs == null ? other$dataFlowConfigs != null : !((Object)this$dataFlowConfigs).equals(other$dataFlowConfigs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterTagConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clusterTag = this.getClusterTag();
        result = result * 59 + ($clusterTag == null ? 43 : $clusterTag.hashCode());
        List<MqClusterConfig> $mqClusterConfigs = this.getMqClusterConfigs();
        result = result * 59 + ($mqClusterConfigs == null ? 43 : ((Object)$mqClusterConfigs).hashCode());
        List<DataFlowConfig> $dataFlowConfigs = this.getDataFlowConfigs();
        result = result * 59 + ($dataFlowConfigs == null ? 43 : ((Object)$dataFlowConfigs).hashCode());
        return result;
    }

    public String toString() {
        return "ClusterTagConfig(clusterTag=" + this.getClusterTag() + ", mqClusterConfigs=" + this.getMqClusterConfigs() + ", dataFlowConfigs=" + this.getDataFlowConfigs() + ")";
    }

    public ClusterTagConfig(String clusterTag, List<MqClusterConfig> mqClusterConfigs, List<DataFlowConfig> dataFlowConfigs) {
        this.clusterTag = clusterTag;
        this.mqClusterConfigs = mqClusterConfigs;
        this.dataFlowConfigs = dataFlowConfigs;
    }

    public ClusterTagConfig() {
    }

    public static class ClusterTagConfigBuilder {
        private String clusterTag;
        private List<MqClusterConfig> mqClusterConfigs;
        private List<DataFlowConfig> dataFlowConfigs;

        ClusterTagConfigBuilder() {
        }

        public ClusterTagConfigBuilder clusterTag(String clusterTag) {
            this.clusterTag = clusterTag;
            return this;
        }

        public ClusterTagConfigBuilder mqClusterConfigs(List<MqClusterConfig> mqClusterConfigs) {
            this.mqClusterConfigs = mqClusterConfigs;
            return this;
        }

        public ClusterTagConfigBuilder dataFlowConfigs(List<DataFlowConfig> dataFlowConfigs) {
            this.dataFlowConfigs = dataFlowConfigs;
            return this;
        }

        public ClusterTagConfig build() {
            return new ClusterTagConfig(this.clusterTag, this.mqClusterConfigs, this.dataFlowConfigs);
        }

        public String toString() {
            return "ClusterTagConfig.ClusterTagConfigBuilder(clusterTag=" + this.clusterTag + ", mqClusterConfigs=" + this.mqClusterConfigs + ", dataFlowConfigs=" + this.dataFlowConfigs + ")";
        }
    }
}

