/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.kv;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.base.TableFormatForRowDataUtils;
import org.apache.inlong.sort.formats.base.TableFormatOptions;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.base.TextFormatOptions;
import org.apache.inlong.sort.formats.kv.KvCommons;
import org.apache.inlong.sort.formats.kv.KvRowDataDeserializationSchema;
import org.apache.inlong.sort.formats.kv.KvRowDataSerializationSchema;

public class KvFormatFactory
implements SerializationFormatFactory,
DeserializationFormatFactory {
    public static final String IDENTIFIER = "inlong-kv";
    public static final String KV_PREFIX = "inlong-kv.";

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        KvCommons.validateFormatOptions(formatOptions);
        return new EncodingFormat<SerializationSchema<RowData>>(){

            public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType dataType) {
                RowFormatInfo projectedRowFormatInfo = TableFormatForRowDataUtils.projectRowFormatInfo(TableFormatUtils.deserializeRowFormatInfo((String)formatOptions.get(TableFormatOptions.ROW_FORMAT_INFO)), dataType);
                KvRowDataSerializationSchema.Builder schemaBuilder = new KvRowDataSerializationSchema.Builder(projectedRowFormatInfo);
                KvFormatFactory.configureSerializationSchema(formatOptions, schemaBuilder);
                return schemaBuilder.build();
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        KvCommons.validateFormatOptions(formatOptions);
        return new DecodingFormat<DeserializationSchema<RowData>>(){

            public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType dataType) {
                KvRowDataDeserializationSchema.Builder schemaBuilder = new KvRowDataDeserializationSchema.Builder(TableFormatUtils.deriveRowFormatInfo(dataType), (TypeInformation<RowData>)context.createTypeInformation(dataType));
                KvFormatFactory.configureDeserializationSchema(formatOptions, schemaBuilder);
                return schemaBuilder.build();
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(TextFormatOptions.KV_ENTRY_DELIMITER);
        options.add(TextFormatOptions.KV_DELIMITER);
        options.add(TextFormatOptions.CHARSET);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(TableFormatOptions.ROW_FORMAT_INFO);
        options.add(TextFormatOptions.ESCAPE_CHARACTER);
        options.add(TextFormatOptions.QUOTE_CHARACTER);
        options.add(TextFormatOptions.NULL_LITERAL);
        options.add(TableFormatOptions.IGNORE_ERRORS);
        return options;
    }

    private static void configureSerializationSchema(ReadableConfig formatOptions, KvRowDataSerializationSchema.Builder schemaBuilder) {
        formatOptions.getOptional(TextFormatOptions.CHARSET).ifPresent(schemaBuilder::setCharset);
        formatOptions.getOptional(TextFormatOptions.KV_ENTRY_DELIMITER).map(delimiter -> Character.valueOf(StringEscapeUtils.unescapeJava(delimiter).charAt(0))).ifPresent(schemaBuilder::setEntryDelimiter);
        formatOptions.getOptional(TextFormatOptions.KV_DELIMITER).map(delimiter -> Character.valueOf(StringEscapeUtils.unescapeJava(delimiter).charAt(0))).ifPresent(schemaBuilder::setKvDelimiter);
        formatOptions.getOptional(TextFormatOptions.ESCAPE_CHARACTER).map(escape -> Character.valueOf(escape.charAt(0))).ifPresent(schemaBuilder::setEscapeCharacter);
        formatOptions.getOptional(TextFormatOptions.QUOTE_CHARACTER).map(quote -> Character.valueOf(quote.charAt(0))).ifPresent(schemaBuilder::setQuoteCharacter);
        formatOptions.getOptional(TextFormatOptions.NULL_LITERAL).ifPresent(schemaBuilder::setNullLiteral);
        formatOptions.getOptional(TableFormatOptions.IGNORE_ERRORS).ifPresent(schemaBuilder::setIgnoreErrors);
    }

    private static void configureDeserializationSchema(ReadableConfig formatOptions, KvRowDataDeserializationSchema.Builder schemaBuilder) {
        formatOptions.getOptional(TextFormatOptions.CHARSET).ifPresent(schemaBuilder::setCharset);
        formatOptions.getOptional(TextFormatOptions.KV_ENTRY_DELIMITER).map(delimiter -> Character.valueOf(StringEscapeUtils.unescapeJava(delimiter).charAt(0))).ifPresent(schemaBuilder::setEntryDelimiter);
        formatOptions.getOptional(TextFormatOptions.KV_DELIMITER).map(delimiter -> Character.valueOf(StringEscapeUtils.unescapeJava(delimiter).charAt(0))).ifPresent(schemaBuilder::setKvDelimiter);
        formatOptions.getOptional(TextFormatOptions.ESCAPE_CHARACTER).map(escape -> Character.valueOf(escape.charAt(0))).ifPresent(schemaBuilder::setEscapeCharacter);
        formatOptions.getOptional(TextFormatOptions.QUOTE_CHARACTER).map(quote -> Character.valueOf(quote.charAt(0))).ifPresent(schemaBuilder::setQuoteCharacter);
        formatOptions.getOptional(TextFormatOptions.NULL_LITERAL).ifPresent(schemaBuilder::setNullLiteral);
        formatOptions.getOptional(TableFormatOptions.IGNORE_ERRORS).ifPresent(schemaBuilder::setIgnoreErrors);
    }
}

