/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringUtils {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_KEY = 2;
    private static final int STATE_VALUE = 4;
    private static final int STATE_ESCAPING = 8;
    private static final int STATE_QUOTING = 16;

    public static Map<String, String> splitKv(@Nonnull String text, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar) {
        List<Map<String, String>> lines = StringUtils.splitKv(text, entryDelimiter, kvDelimiter, escapeChar, quoteChar, null, true);
        if (lines.size() == 0) {
            return new HashMap<String, String>();
        }
        return lines.get(0);
    }

    public static List<Map<String, String>> splitKv(@Nonnull String text, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable Character lineDelimiter, @Nullable boolean isDeleteEscapeChar) {
        String value;
        HashMap<String, String> fields = new HashMap<String, String>();
        ArrayList<Map<String, String>> lines = new ArrayList<Map<String, String>>();
        if (text == null) {
            return lines;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String key = "";
        String lastKey = null;
        String lastValue = null;
        int state = 2;
        int kvState = 2;
        char nextCh = '\u0000';
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            nextCh = i + 1 < text.length() ? text.charAt(i + 1) : (char)'\u0000';
            if (ch == kvDelimiter.charValue()) {
                switch (state) {
                    case 2: {
                        key = stringBuilder.toString();
                        stringBuilder.setLength(0);
                        state = 4;
                        break;
                    }
                    case 4: {
                        stringBuilder.append(ch);
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = kvState;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                    }
                }
                continue;
            }
            if (ch == entryDelimiter.charValue()) {
                switch (state) {
                    case 2: {
                        stringBuilder.append(ch);
                        break;
                    }
                    case 4: {
                        if (nextCh == entryDelimiter.charValue()) {
                            stringBuilder.append(ch);
                            break;
                        }
                        value = stringBuilder.toString();
                        fields.put(key, value);
                        lastKey = key;
                        lastValue = value;
                        stringBuilder.setLength(0);
                        state = 2;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = kvState;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                    }
                }
                continue;
            }
            if (escapeChar != null && ch == escapeChar.charValue()) {
                switch (state) {
                    case 2: 
                    case 4: {
                        kvState = state;
                        state = 8;
                        if (isDeleteEscapeChar) break;
                        stringBuilder.append(ch);
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = kvState;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                    }
                }
                continue;
            }
            if (quoteChar != null && ch == quoteChar.charValue()) {
                switch (state) {
                    case 2: 
                    case 4: {
                        kvState = state;
                        state = 16;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = kvState;
                        break;
                    }
                    case 16: {
                        state = kvState;
                    }
                }
                continue;
            }
            if (lineDelimiter != null && ch == lineDelimiter.charValue()) {
                switch (state) {
                    case 2: {
                        String remainingKey = stringBuilder.toString();
                        key = lastKey;
                        stringBuilder.setLength(0);
                        stringBuilder.append(lastValue).append(entryDelimiter).append(remainingKey);
                        value = stringBuilder.toString();
                        fields.put(key, value);
                        HashMap<String, String> copyFields = new HashMap();
                        copyFields.putAll(fields);
                        lines.add(copyFields);
                        stringBuilder.setLength(0);
                        fields.clear();
                        lastKey = null;
                        lastValue = null;
                        break;
                    }
                    case 4: {
                        lastKey = null;
                        lastValue = null;
                        value = stringBuilder.toString();
                        fields.put(key, value);
                        HashMap<String, String> copyFields = new HashMap<String, String>();
                        copyFields.putAll(fields);
                        lines.add(copyFields);
                        stringBuilder.setLength(0);
                        fields.clear();
                        state = 2;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = 0;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                    }
                }
                continue;
            }
            stringBuilder.append(ch);
            switch (state) {
                case 8: {
                    state = kvState;
                }
            }
        }
        switch (state) {
            case 2: {
                if (lastKey != null && lastValue != null && text != null) {
                    String remainingKey = stringBuilder.toString();
                    key = lastKey;
                    stringBuilder.setLength(0);
                    stringBuilder.append(lastValue).append(entryDelimiter).append(remainingKey);
                    value = stringBuilder.toString();
                    fields.put(key, value);
                }
                lines.add(fields);
                return lines;
            }
            case 4: {
                value = stringBuilder.toString();
                fields.put(key, value);
                lines.add(fields);
                return lines;
            }
            case 8: 
            case 16: {
                switch (kvState) {
                    case 4: {
                        value = stringBuilder.toString();
                        fields.put(key, value);
                        break;
                    }
                    case 2: {
                        if (lastKey == null) break;
                        value = stringBuilder.toString();
                        String oldValue = (String)fields.get(key);
                        fields.put(key, oldValue + entryDelimiter + value);
                    }
                }
                lines.add(fields);
                return lines;
            }
        }
        throw new IllegalStateException();
    }

    public static String concatKv(@Nonnull String[] fieldKeys, @Nonnull String[] fieldValues, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar) {
        if (fieldKeys.length < fieldValues.length) {
            throw new IllegalArgumentException("The keys' number " + fieldKeys.length + " is less than values' number " + fieldValues.length);
        }
        List<Character> delimiters = Arrays.asList(entryDelimiter, kvDelimiter);
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; index < fieldKeys.length; ++index) {
            StringUtils.encodeText(stringBuilder, fieldKeys[index], delimiters, escapeChar, quoteChar);
            stringBuilder.append(kvDelimiter);
            StringUtils.encodeText(stringBuilder, fieldValues[index], delimiters, escapeChar, quoteChar);
            if (index >= fieldKeys.length - 1) continue;
            stringBuilder.append(entryDelimiter);
        }
        return stringBuilder.toString();
    }

    private static void encodeText(StringBuilder stringBuilder, String text, Collection<Character> delimiters, Character escapeChar, Character quoteChar) {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (delimiters.contains(Character.valueOf(ch))) {
                if (escapeChar != null) {
                    stringBuilder.append(escapeChar);
                    stringBuilder.append(ch);
                    continue;
                }
                if (quoteChar != null) {
                    stringBuilder.append(quoteChar);
                    stringBuilder.append(ch);
                    stringBuilder.append(quoteChar);
                    continue;
                }
                throw new IllegalArgumentException("There is a delimiter in the text, but neither escape nor quote character is specified.");
            }
            if (escapeChar != null && ch == escapeChar.charValue()) {
                stringBuilder.append(escapeChar);
                stringBuilder.append(ch);
                continue;
            }
            if (quoteChar != null && ch == quoteChar.charValue()) {
                if (escapeChar != null) {
                    stringBuilder.append(escapeChar);
                    stringBuilder.append(ch);
                    continue;
                }
                throw new IllegalArgumentException("There is a quote character in the text, but escape character is not specified.");
            }
            stringBuilder.append(ch);
        }
    }

    public static String[] splitCsv(@Nonnull String text, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar) {
        String[][] splitResult = StringUtils.splitCsv(text, delimiter, escapeChar, quoteChar, null);
        if (splitResult.length == 0) {
            return new String[0];
        }
        return splitResult[0];
    }

    public static String[][] splitCsv(@Nonnull String text, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable Character lineDelimiter) {
        return StringUtils.splitCsv(text, delimiter, escapeChar, quoteChar, lineDelimiter, false, true);
    }

    public static String[][] splitCsv(@Nonnull String text, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable Character lineDelimiter, boolean deleteHeadDelimiter, boolean isDeleteEscapeChar) {
        return StringUtils.splitCsv(text, delimiter, escapeChar, quoteChar, lineDelimiter, deleteHeadDelimiter, isDeleteEscapeChar, null);
    }

    public static String[][] splitCsv(@Nonnull String text, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable Character lineDelimiter, boolean deleteHeadDelimiter, boolean isDeleteEscapeChar, @Nullable Integer maxFieldSize) {
        if (maxFieldSize != null && maxFieldSize <= 0) {
            return new String[0][];
        }
        ArrayList<String[]> lines = new ArrayList<String[]>();
        List<String> fields = new ArrayList<String>();
        int splittedSize = 0;
        int lastFieldStartIndex = 0;
        StringBuilder stringBuilder = new StringBuilder();
        int state = 0;
        for (int i = 0; i < text.length(); ++i) {
            String field;
            char ch = text.charAt(i);
            if (ch == delimiter.charValue()) {
                switch (state) {
                    case 0: {
                        if (deleteHeadDelimiter && fields.isEmpty() && stringBuilder.length() == 0) break;
                        field = stringBuilder.toString();
                        fields.add(field);
                        stringBuilder.setLength(0);
                        if (maxFieldSize == null || ++splittedSize != maxFieldSize - 1 || i + 1 >= text.length()) break;
                        lastFieldStartIndex = i + 1;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = 0;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                    }
                }
                continue;
            }
            if (escapeChar != null && ch == escapeChar.charValue()) {
                switch (state) {
                    case 0: {
                        state = 8;
                        if (isDeleteEscapeChar) break;
                        stringBuilder.append(ch);
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = 0;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                    }
                }
                continue;
            }
            if (quoteChar != null && ch == quoteChar.charValue()) {
                switch (state) {
                    case 0: {
                        state = 16;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = 0;
                        break;
                    }
                    case 16: {
                        state = 0;
                    }
                }
                continue;
            }
            if (lineDelimiter != null && ch == lineDelimiter.charValue()) {
                switch (state) {
                    case 0: {
                        field = stringBuilder.toString();
                        fields.add(field);
                        if (maxFieldSize != null && fields.size() > maxFieldSize) {
                            fields = StringUtils.replaceLastField(fields, maxFieldSize, text, lastFieldStartIndex, i);
                        }
                        lastFieldStartIndex = i + 1;
                        lines.add(fields.toArray(new String[0]));
                        stringBuilder.setLength(0);
                        fields.clear();
                        splittedSize = 0;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = 0;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                    }
                }
                continue;
            }
            if (state == 8) {
                state = 0;
            }
            stringBuilder.append(ch);
        }
        switch (state) {
            case 0: 
            case 8: 
            case 16: {
                String field = stringBuilder.toString();
                fields.add(field);
                if (maxFieldSize != null && fields.size() > maxFieldSize) {
                    fields = StringUtils.replaceLastField(fields, maxFieldSize, text, lastFieldStartIndex, text.length());
                }
                lines.add(fields.toArray(new String[0]));
                String[][] result = new String[lines.size()][];
                for (int i = 0; i < lines.size(); ++i) {
                    result[i] = (String[])lines.get(i);
                }
                return result;
            }
        }
        throw new IllegalStateException(String.format("Text=[%s].", text));
    }

    private static List<String> replaceLastField(List<String> fields, int maxFieldSize, String text, int lastFieldStartIndex, int lastFieldEndIndex) {
        List<String> newField = fields.subList(0, maxFieldSize - 1);
        String last = text.substring(lastFieldStartIndex, lastFieldEndIndex);
        newField.add(last);
        return newField;
    }

    public static String concatCsv(@Nonnull String[] fields, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; index < fields.length; ++index) {
            String field = fields[index];
            for (int i = 0; i < field.length(); ++i) {
                char ch = field.charAt(i);
                if (ch == delimiter.charValue() || escapeChar != null && ch == escapeChar.charValue() || quoteChar != null && ch == quoteChar.charValue()) {
                    if (escapeChar != null) {
                        stringBuilder.append(escapeChar);
                        stringBuilder.append(ch);
                        continue;
                    }
                    if (quoteChar != null && ch != quoteChar.charValue()) {
                        stringBuilder.append(quoteChar);
                        stringBuilder.append(ch);
                        stringBuilder.append(quoteChar);
                        continue;
                    }
                    throw new IllegalArgumentException("There exist special characters in the text but neither escape character nor quote character is configured.");
                }
                stringBuilder.append(ch);
            }
            if (index >= fields.length - 1) continue;
            stringBuilder.append(delimiter);
        }
        return stringBuilder.toString();
    }
}

