/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.OperationTarget;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.tool.excel.ExcelTool;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.common.BatchResult;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.sink.AddFieldRequest;
import org.apache.inlong.manager.pojo.sink.ParseFieldRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamBriefInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamPageRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamRequest;
import org.apache.inlong.manager.pojo.stream.QueryMessageRequest;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.apache.inlong.manager.service.stream.InlongStreamProcessService;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"Inlong-Stream-API"})
public class InlongStreamController {
    private static final Logger log = LoggerFactory.getLogger(InlongStreamController.class);
    @Autowired
    private InlongStreamService streamService;
    @Autowired
    private InlongStreamProcessService streamProcessOperation;

    @RequestMapping(value={"/stream/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.STREAM)
    @ApiOperation(value="Save inlong stream")
    public Response<Integer> save(@RequestBody InlongStreamRequest request) {
        int result = this.streamService.save(request, LoginUserUtils.getLoginUser().getName());
        return Response.success((Object)result);
    }

    @RequestMapping(value={"/stream/batchSave"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.STREAM)
    @ApiOperation(value="Batch save inlong stream")
    public Response<List<BatchResult>> batchSave(@RequestBody List<InlongStreamRequest> requestList) {
        List result = this.streamService.batchSave(requestList, LoginUserUtils.getLoginUser().getName());
        return Response.success((Object)result);
    }

    @RequestMapping(value={"/stream/exist/{groupId}/{streamId}"}, method={RequestMethod.GET})
    @ApiOperation(value="Is the inlong stream exists")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="streamId", dataTypeClass=String.class, required=true)})
    public Response<Boolean> exist(@PathVariable String groupId, @PathVariable String streamId) {
        return Response.success((Object)this.streamService.exist(groupId, streamId));
    }

    @RequestMapping(value={"/stream/get"}, method={RequestMethod.GET})
    @ApiOperation(value="Get inlong stream")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="streamId", dataTypeClass=String.class, required=true)})
    public Response<InlongStreamInfo> get(@RequestParam String groupId, @RequestParam String streamId) {
        return Response.success((Object)this.streamService.get(groupId, streamId));
    }

    @RequestMapping(value={"/stream/getBrief"}, method={RequestMethod.GET})
    @ApiOperation(value="Get inlong stream brief")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="streamId", dataTypeClass=String.class, required=true)})
    public Response<InlongStreamBriefInfo> getBrief(@RequestParam String groupId, @RequestParam String streamId) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.streamService.getBrief(groupId, streamId, operator));
    }

    @RequestMapping(value={"/stream/list"}, method={RequestMethod.POST})
    @ApiOperation(value="List inlong stream briefs by paginating")
    public Response<PageResult<InlongStreamBriefInfo>> listByCondition(@RequestBody InlongStreamPageRequest request) {
        request.setCurrentUser(LoginUserUtils.getLoginUser().getName());
        request.setIsAdminRole(Boolean.valueOf(LoginUserUtils.getLoginUser().getRoles().contains("TENANT_ADMIN")));
        return Response.success((Object)this.streamService.listBrief(request));
    }

    @RequestMapping(value={"/stream/listAll"}, method={RequestMethod.POST})
    @ApiOperation(value="List inlong streams with sources and sinks by paginating")
    public Response<PageResult<InlongStreamInfo>> listAllWithGroupId(@RequestBody InlongStreamPageRequest request) {
        request.setCurrentUser(LoginUserUtils.getLoginUser().getName());
        request.setIsAdminRole(Boolean.valueOf(LoginUserUtils.getLoginUser().getRoles().contains("TENANT_ADMIN")));
        return Response.success((Object)this.streamService.listAll(request));
    }

    @RequestMapping(value={"/stream/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.STREAM)
    @ApiOperation(value="Update inlong stream")
    public Response<Boolean> update(@Validated(value={UpdateValidation.class}) @RequestBody InlongStreamRequest request) {
        String username = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.streamService.update(request, username));
    }

    @RequestMapping(value={"/stream/startProcess/{groupId}/{streamId}"}, method={RequestMethod.POST})
    @ApiOperation(value="Start inlong stream process")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="streamId", dataTypeClass=String.class, required=true)})
    public Response<Boolean> startProcess(@PathVariable String groupId, @PathVariable String streamId, @RequestParam(required=false, defaultValue="false") boolean sync) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.streamProcessOperation.startProcess(groupId, streamId, operator, sync));
    }

    @RequestMapping(value={"/stream/suspendProcess/{groupId}/{streamId}"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.SUSPEND, operationTarget=OperationTarget.STREAM)
    @ApiOperation(value="Suspend inlong stream process")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="streamId", dataTypeClass=String.class, required=true)})
    public Response<Boolean> suspendProcess(@PathVariable String groupId, @PathVariable String streamId, @RequestParam(required=false, defaultValue="false") boolean sync) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.streamProcessOperation.suspendProcess(groupId, streamId, operator, sync));
    }

    @RequestMapping(value={"/stream/restartProcess/{groupId}/{streamId}"}, method={RequestMethod.POST})
    @ApiOperation(value="Restart inlong stream process")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="streamId", dataTypeClass=String.class, required=true)})
    public Response<Boolean> restartProcess(@PathVariable String groupId, @PathVariable String streamId, @RequestParam(required=false, defaultValue="false") boolean sync) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.streamProcessOperation.restartProcess(groupId, streamId, operator, sync));
    }

    @RequestMapping(value={"/stream/deleteProcess/{groupId}/{streamId}"}, method={RequestMethod.POST})
    @ApiOperation(value="Delete inlong stream process")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="streamId", dataTypeClass=String.class, required=true)})
    public Response<Boolean> deleteProcess(@PathVariable String groupId, @PathVariable String streamId, @RequestParam(required=false, defaultValue="false") boolean sync) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.streamProcessOperation.deleteProcess(groupId, streamId, operator, sync));
    }

    @Deprecated
    @RequestMapping(value={"/stream/delete"}, method={RequestMethod.DELETE})
    @OperationLog(operation=OperationType.DELETE, operationTarget=OperationTarget.STREAM)
    @ApiOperation(value="Delete inlong stream")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="streamId", dataTypeClass=String.class, required=true)})
    public Response<Boolean> delete(@RequestParam String groupId, @RequestParam String streamId) {
        String username = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.streamService.delete(groupId, streamId, username));
    }

    @RequestMapping(value={"/stream/addFields"}, method={RequestMethod.POST})
    @ApiOperation(value="Add inlong stream fields")
    public Response<Boolean> addFields(@RequestBody AddFieldRequest addFieldsRequest) {
        return Response.success((Object)this.streamService.addFields(addFieldsRequest));
    }

    @RequestMapping(value={"/stream/parseFields"}, method={RequestMethod.POST})
    @ApiOperation(value="Parse inlong stream fields from statement")
    public Response<List<StreamField>> parseFields(@RequestBody ParseFieldRequest parseFieldRequest) {
        return Response.success((Object)this.streamService.parseFields(parseFieldRequest));
    }

    @RequestMapping(value={"/stream/parseFieldsByExcel"}, method={RequestMethod.POST})
    @ApiOperation(value="Parse inlong stream fields by update excel file", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="file object", required=true, dataType="__FILE", dataTypeClass=MultipartFile.class, paramType="query")})
    public Response<List<StreamField>> parseFieldsByExcel(@RequestParam(value="file") MultipartFile file) {
        return Response.success((Object)this.streamService.parseFields(file));
    }

    @RequestMapping(value={"/stream/fieldsImportTemplate"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    @ApiOperation(value="Download fields import template", produces="application/octet-stream")
    public void downloadFieldsImportTemplate(HttpServletResponse response) {
        String date = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
        String fileName = String.format("InLong-stream-fields-template-%s.xlsx", date);
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        response.setHeader("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            ExcelTool.write(StreamField.class, (OutputStream)outputStream);
        }
        catch (IOException e) {
            log.error("Can not properly download Excel file", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, String.format("can not properly download template file: %s", e.getMessage()));
        }
    }

    @RequestMapping(value={"/stream/listMessages"}, method={RequestMethod.GET})
    @ApiOperation(value="Get inlong stream message")
    public Response<List<BriefMQMessage>> listMessages(QueryMessageRequest request) {
        String username = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.streamService.listMessages(request, username));
    }
}

