/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.entry;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.inlong.tubemq.manager.enums.TaskStatusEnum;
import org.apache.inlong.tubemq.manager.utils.ValidateUtils;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="createTopicTask", uniqueConstraints={@UniqueConstraint(columnNames={"id"})})
@EntityListeners(value={AuditingEntityListener.class})
public class TopicTaskEntry {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private Long clusterId;
    @CreatedDate
    private Date createDate;
    private Integer status = TaskStatusEnum.ADDING.getCode();
    private String token;
    private String topicName;
    @LastModifiedDate
    private Date modifyDate;
    private String modifyUser;
    private Integer configRetryTimes = 0;
    private Integer reloadRetryTimes = 0;

    public boolean legal() {
        return !ValidateUtils.isNull(this.clusterId);
    }

    public Long getId() {
        return this.id;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getToken() {
        return this.token;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Date getModifyDate() {
        return this.modifyDate;
    }

    public String getModifyUser() {
        return this.modifyUser;
    }

    public Integer getConfigRetryTimes() {
        return this.configRetryTimes;
    }

    public Integer getReloadRetryTimes() {
        return this.reloadRetryTimes;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public void setConfigRetryTimes(Integer configRetryTimes) {
        this.configRetryTimes = configRetryTimes;
    }

    public void setReloadRetryTimes(Integer reloadRetryTimes) {
        this.reloadRetryTimes = reloadRetryTimes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicTaskEntry)) {
            return false;
        }
        TopicTaskEntry other = (TopicTaskEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$clusterId = this.getClusterId();
        Long other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !((Object)this$clusterId).equals(other$clusterId)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$configRetryTimes = this.getConfigRetryTimes();
        Integer other$configRetryTimes = other.getConfigRetryTimes();
        if (this$configRetryTimes == null ? other$configRetryTimes != null : !((Object)this$configRetryTimes).equals(other$configRetryTimes)) {
            return false;
        }
        Integer this$reloadRetryTimes = this.getReloadRetryTimes();
        Integer other$reloadRetryTimes = other.getReloadRetryTimes();
        if (this$reloadRetryTimes == null ? other$reloadRetryTimes != null : !((Object)this$reloadRetryTimes).equals(other$reloadRetryTimes)) {
            return false;
        }
        Date this$createDate = this.getCreateDate();
        Date other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$topicName = this.getTopicName();
        String other$topicName = other.getTopicName();
        if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
            return false;
        }
        Date this$modifyDate = this.getModifyDate();
        Date other$modifyDate = other.getModifyDate();
        if (this$modifyDate == null ? other$modifyDate != null : !((Object)this$modifyDate).equals(other$modifyDate)) {
            return false;
        }
        String this$modifyUser = this.getModifyUser();
        String other$modifyUser = other.getModifyUser();
        return !(this$modifyUser == null ? other$modifyUser != null : !this$modifyUser.equals(other$modifyUser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TopicTaskEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : ((Object)$clusterId).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $configRetryTimes = this.getConfigRetryTimes();
        result = result * 59 + ($configRetryTimes == null ? 43 : ((Object)$configRetryTimes).hashCode());
        Integer $reloadRetryTimes = this.getReloadRetryTimes();
        result = result * 59 + ($reloadRetryTimes == null ? 43 : ((Object)$reloadRetryTimes).hashCode());
        Date $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
        Date $modifyDate = this.getModifyDate();
        result = result * 59 + ($modifyDate == null ? 43 : ((Object)$modifyDate).hashCode());
        String $modifyUser = this.getModifyUser();
        result = result * 59 + ($modifyUser == null ? 43 : $modifyUser.hashCode());
        return result;
    }

    public String toString() {
        return "TopicTaskEntry(id=" + this.getId() + ", clusterId=" + this.getClusterId() + ", createDate=" + this.getCreateDate() + ", status=" + this.getStatus() + ", token=" + this.getToken() + ", topicName=" + this.getTopicName() + ", modifyDate=" + this.getModifyDate() + ", modifyUser=" + this.getModifyUser() + ", configRetryTimes=" + this.getConfigRetryTimes() + ", reloadRetryTimes=" + this.getReloadRetryTimes() + ")";
    }
}

