/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.airflow;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.inlong.manager.pojo.schedule.airflow.Error;
import org.apache.inlong.manager.schedule.airflow.api.AirflowApi;
import org.apache.inlong.manager.schedule.airflow.api.AirflowResponse;
import org.apache.inlong.manager.schedule.airflow.config.AirflowConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirflowServerClient {
    private static final Logger logger = LoggerFactory.getLogger(AirflowServerClient.class);
    private final OkHttpClient httpClient;
    private final AirflowConfig config;
    private final ObjectMapper objectMapper;

    public AirflowServerClient(OkHttpClient httpClient, AirflowConfig config) {
        this.httpClient = httpClient;
        this.config = config;
        this.objectMapper = new ObjectMapper();
    }

    public <T> AirflowResponse<T> sendRequest(AirflowApi<T> apiEndpoint) throws IOException {
        Request request = apiEndpoint.buildRequest(this.config.getBaseUrl());
        try (Response response = this.httpClient.newCall(request).execute();){
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                AirflowResponse<Object> airflowResponse = new AirflowResponse<Object>(true, this.objectMapper.readValue(responseBody, apiEndpoint.getResponseType()));
                return airflowResponse;
            }
            logger.error("Airflow Web API Request failed, status code: {} , detail: {}", (Object)response.code(), (Object)((Error)this.objectMapper.readValue(responseBody, Error.class)).getDetail());
            AirflowResponse<Object> airflowResponse = new AirflowResponse<Object>(false, null);
            return airflowResponse;
        }
    }
}

