/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.quartz;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Set;
import org.apache.inlong.manager.pojo.schedule.ScheduleInfo;
import org.apache.inlong.manager.schedule.ScheduleEngine;
import org.apache.inlong.manager.schedule.exception.QuartzScheduleException;
import org.apache.inlong.manager.schedule.quartz.QuartzOfflineSyncJob;
import org.apache.inlong.manager.schedule.quartz.QuartzSchedulerListener;
import org.apache.inlong.manager.schedule.util.ScheduleUtils;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class QuartzScheduleEngine
implements ScheduleEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzScheduleEngine.class);
    @Value(value="${server.host:127.0.0.1}")
    private String host;
    @Value(value="${server.port:8083}")
    private int port;
    @Value(value="${default.admin.user:admin}")
    private String username;
    @Value(value="${default.admin.password:inlong}")
    private String password;
    private final Scheduler scheduler;
    private final Set<String> scheduledJobSet = new HashSet<String>();

    public QuartzScheduleEngine() {
        try {
            this.scheduler = new StdSchedulerFactory().getScheduler();
            LOGGER.info("Quartz scheduler engine initialized");
        }
        catch (SchedulerException e) {
            throw new QuartzScheduleException("Failed to init quartz scheduler ", e);
        }
        this.start();
    }

    @Override
    public void start() {
        try {
            this.scheduler.getListenerManager().addSchedulerListener((SchedulerListener)new QuartzSchedulerListener(this));
            this.scheduler.start();
            LOGGER.info("Quartz scheduler engine started, inlong manager host {}, port {}, secretId {}", new Object[]{this.host, this.port, this.username});
        }
        catch (SchedulerException e) {
            throw new QuartzScheduleException("Failed to start quartz scheduler ", e);
        }
    }

    public boolean triggerFinalized(Trigger trigger) {
        String jobName = trigger.getJobKey().getName();
        LOGGER.info("Quartz trigger finalized for job {}", (Object)jobName);
        return this.scheduledJobSet.remove(jobName);
    }

    @Override
    public boolean handleRegister(ScheduleInfo scheduleInfo) {
        return this.handleRegister(scheduleInfo, QuartzOfflineSyncJob.class);
    }

    @VisibleForTesting
    public boolean handleRegister(ScheduleInfo scheduleInfo, Class<? extends Job> clz) {
        if (this.scheduledJobSet.contains(scheduleInfo.getInlongGroupId())) {
            throw new QuartzScheduleException("Group " + scheduleInfo.getInlongGroupId() + " is already registered");
        }
        JobDetail jobDetail = ScheduleUtils.genQuartzJobDetail(scheduleInfo, clz, this.host, this.port, this.username, this.password);
        Trigger trigger = ScheduleUtils.genQuartzTrigger(jobDetail, scheduleInfo);
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
            this.scheduledJobSet.add(scheduleInfo.getInlongGroupId());
            LOGGER.info("Registered new quartz schedule info for {}", (Object)scheduleInfo.getInlongGroupId());
        }
        catch (SchedulerException e) {
            throw new QuartzScheduleException(e.getMessage());
        }
        return false;
    }

    @Override
    public boolean handleUnregister(String groupId) {
        if (this.scheduledJobSet.contains(groupId)) {
            try {
                this.scheduler.deleteJob(new JobKey(groupId));
            }
            catch (SchedulerException e) {
                throw new QuartzScheduleException(e.getMessage());
            }
        }
        this.scheduledJobSet.remove(groupId);
        LOGGER.info("Un-registered quartz schedule info for {}", (Object)groupId);
        return true;
    }

    @Override
    public boolean handleUpdate(ScheduleInfo scheduleInfo) {
        return this.handleUpdate(scheduleInfo, QuartzOfflineSyncJob.class);
    }

    @VisibleForTesting
    public boolean handleUpdate(ScheduleInfo scheduleInfo, Class<? extends Job> clz) {
        this.handleUnregister(scheduleInfo.getInlongGroupId());
        this.handleRegister(scheduleInfo, clz);
        LOGGER.info("Updated quartz schedule info for {}", (Object)scheduleInfo.getInlongGroupId());
        return false;
    }

    @Override
    public void stop() {
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown();
                LOGGER.info("Quartz scheduler engine stopped");
            }
            catch (SchedulerException e) {
                throw new QuartzScheduleException("Failed to stop quartz scheduler ", e);
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Set<String> getScheduledJobSet() {
        return this.scheduledJobSet;
    }
}

