/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.CollectVisitor;

public class CountTimeAggregationAmountVisitor
extends CollectVisitor {
    public static final String COUNT_TIME_ONLY_SUPPORT_ONE_WILDCARD = "The parameter of count_time aggregation can only be '*'.";

    @Override
    public List<Expression> visitFunctionExpression(FunctionExpression functionExpression, Void context) {
        if ("count_time".equalsIgnoreCase(functionExpression.getFunctionName())) {
            if (!"*".equals(functionExpression.getExpressions().get(0).toString())) {
                throw new SemanticException(COUNT_TIME_ONLY_SUPPORT_ONE_WILDCARD);
            }
            return Collections.singletonList(functionExpression);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Expression> visitLeafOperand(LeafOperand leafOperand, Void context) {
        return Collections.emptyList();
    }
}

