/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemRelatedFileMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemRelatedFileMetrics.class);
    private static final MetricConfig CONFIG = MetricConfigDescriptor.getInstance().getMetricConfig();
    private final Runtime runtime = Runtime.getRuntime();
    private String[] getOpenFileNumberCommand;
    private String fileHandlerCntPathInLinux = String.format(this.fileHandlerCntPathInLinux, CONFIG.getPid());

    public void bindTo(AbstractMetricService metricService) {
        if (!(CONFIG.getSystemType() != SystemType.LINUX && CONFIG.getSystemType() != SystemType.MAC || CONFIG.getPid().isEmpty())) {
            this.getOpenFileNumberCommand = new String[]{"/bin/sh", "-c", String.format("lsof -p %s | wc -l", CONFIG.getPid())};
            metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, SystemRelatedFileMetrics::getOpenFileHandlersNumber, new String[]{Tag.NAME.toString(), "open_file_handlers"});
        }
    }

    private long getOpenFileHandlersNumber() {
        long fdCount;
        block10: {
            fdCount = 0L;
            try {
                if (CONFIG.getSystemType() == SystemType.LINUX) {
                    File fdDir = new File(this.fileHandlerCntPathInLinux);
                    if (fdDir.exists()) {
                        File[] fds = fdDir.listFiles();
                        fdCount = fds == null ? 0L : (long)fds.length;
                    }
                    break block10;
                }
                if (CONFIG.getSystemType() != SystemType.MAC || CONFIG.getPid().isEmpty()) break block10;
                Process process = this.runtime.exec(this.getOpenFileNumberCommand);
                StringBuilder result = new StringBuilder();
                try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while ((line = input.readLine()) != null) {
                        result.append(line);
                    }
                }
                fdCount = Long.parseLong(result.toString().trim());
            }
            catch (IOException e) {
                LOGGER.warn("Failed to get open file number, because ", (Throwable)e);
            }
        }
        return fdCount;
    }

    public void unbindFrom(AbstractMetricService metricService) {
        if (!(CONFIG.getSystemType() != SystemType.LINUX && CONFIG.getSystemType() != SystemType.MAC || CONFIG.getPid().isEmpty())) {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "open_file_handlers"});
        }
    }
}

