/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.ir;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.planner.IrExpressionInterpreter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.IrTypeAnalyzer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.NoOpSymbolResolver;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.DeterminismEvaluator;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.tsfile.read.common.type.Type;

public final class IrUtils {
    private IrUtils() {
    }

    public static List<Expression> extractConjuncts(Expression expression) {
        return IrUtils.extractPredicates(LogicalExpression.Operator.AND, expression);
    }

    public static List<Expression> extractDisjuncts(Expression expression) {
        return IrUtils.extractPredicates(LogicalExpression.Operator.OR, expression);
    }

    public static List<Expression> extractPredicates(LogicalExpression expression) {
        return IrUtils.extractPredicates(expression.getOperator(), expression);
    }

    public static List<Expression> extractOrPredicatesWithInExpanded(Expression expression, AtomicBoolean mayContainDuplicateDevice) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        IrUtils.extractOrPredicatesWithInExpanded(expression, (ImmutableList.Builder<Expression>)resultBuilder, mayContainDuplicateDevice);
        return resultBuilder.build();
    }

    private static void extractOrPredicatesWithInExpanded(Expression expression, ImmutableList.Builder<Expression> resultBuilder, AtomicBoolean mayContainDuplicateDevice) {
        if (expression instanceof LogicalExpression) {
            if (((LogicalExpression)expression).getOperator() == LogicalExpression.Operator.OR) {
                mayContainDuplicateDevice.set(true);
                for (Expression term : ((LogicalExpression)expression).getTerms()) {
                    IrUtils.extractOrPredicatesWithInExpanded(term, resultBuilder, mayContainDuplicateDevice);
                }
            }
        } else if (expression instanceof InPredicate) {
            ((InListExpression)((InPredicate)expression).getValueList()).getValues().stream().map(value -> new ComparisonExpression(ComparisonExpression.Operator.EQUAL, ((InPredicate)expression).getValue(), (Expression)value)).forEach(arg_0 -> resultBuilder.add(arg_0));
        } else {
            resultBuilder.add((Object)expression);
        }
    }

    public static List<Expression> extractPredicates(LogicalExpression.Operator operator, Expression expression) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        IrUtils.extractPredicates(operator, expression, (ImmutableList.Builder<Expression>)resultBuilder);
        return resultBuilder.build();
    }

    private static void extractPredicates(LogicalExpression.Operator operator, Expression expression, ImmutableList.Builder<Expression> resultBuilder) {
        if (expression instanceof LogicalExpression && ((LogicalExpression)expression).getOperator() == operator) {
            for (Expression term : ((LogicalExpression)expression).getTerms()) {
                IrUtils.extractPredicates(operator, term, resultBuilder);
            }
        } else {
            resultBuilder.add((Object)expression);
        }
    }

    public static Expression and(Expression ... expressions) {
        return IrUtils.and(Arrays.asList(expressions));
    }

    public static Expression and(Collection<Expression> expressions) {
        return IrUtils.logicalExpression(LogicalExpression.Operator.AND, expressions);
    }

    public static Expression or(Expression ... expressions) {
        return IrUtils.or(Arrays.asList(expressions));
    }

    public static Expression or(Collection<Expression> expressions) {
        return IrUtils.logicalExpression(LogicalExpression.Operator.OR, expressions);
    }

    public static Expression logicalExpression(LogicalExpression.Operator operator, Collection<Expression> expressions) {
        Objects.requireNonNull(operator, "operator is null");
        Objects.requireNonNull(expressions, "expressions is null");
        if (expressions.isEmpty()) {
            switch (operator) {
                case AND: {
                    return BooleanLiteral.TRUE_LITERAL;
                }
                case OR: {
                    return BooleanLiteral.FALSE_LITERAL;
                }
            }
            throw new IllegalArgumentException("Unsupported LogicalExpression operator");
        }
        if (expressions.size() == 1) {
            return (Expression)Iterables.getOnlyElement(expressions);
        }
        return new LogicalExpression(operator, (List<Expression>)ImmutableList.copyOf(expressions));
    }

    public static Expression combinePredicates(LogicalExpression.Operator operator, Collection<Expression> expressions) {
        if (operator == LogicalExpression.Operator.AND) {
            return IrUtils.combineConjuncts(expressions);
        }
        return IrUtils.combineDisjuncts(expressions);
    }

    public static Expression combineConjuncts(Expression ... expressions) {
        return IrUtils.combineConjuncts(Arrays.asList(expressions));
    }

    public static Expression filterDeterministicConjuncts(Expression expression) {
        return IrUtils.filterConjuncts(expression, DeterminismEvaluator::isDeterministic);
    }

    public static Expression combineConjuncts(Collection<Expression> expressions) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> conjuncts = expressions.stream().flatMap(e -> IrUtils.extractConjuncts(e).stream()).filter(e -> !e.equals(BooleanLiteral.TRUE_LITERAL)).collect(Collectors.toList());
        conjuncts = IrUtils.removeDuplicates(conjuncts);
        if (conjuncts.contains(BooleanLiteral.FALSE_LITERAL)) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        return IrUtils.and(conjuncts);
    }

    public static Expression combineConjunctsWithDuplicates(Collection<Expression> expressions) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> conjuncts = expressions.stream().flatMap(e -> IrUtils.extractConjuncts(e).stream()).filter(e -> !e.equals(BooleanLiteral.TRUE_LITERAL)).collect(Collectors.toList());
        if (conjuncts.contains(BooleanLiteral.FALSE_LITERAL)) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        return IrUtils.and(conjuncts);
    }

    public static Expression combineDisjuncts(Expression ... expressions) {
        return IrUtils.combineDisjuncts(Arrays.asList(expressions));
    }

    public static Expression combineDisjuncts(Collection<Expression> expressions) {
        return IrUtils.combineDisjunctsWithDefault(expressions, BooleanLiteral.FALSE_LITERAL);
    }

    public static Expression combineDisjunctsWithDefault(Collection<Expression> expressions, Expression emptyDefault) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> disjuncts = expressions.stream().flatMap(e -> IrUtils.extractDisjuncts(e).stream()).filter(e -> !e.equals(BooleanLiteral.FALSE_LITERAL)).collect(Collectors.toList());
        disjuncts = IrUtils.removeDuplicates(disjuncts);
        if (disjuncts.contains(BooleanLiteral.TRUE_LITERAL)) {
            return BooleanLiteral.TRUE_LITERAL;
        }
        return disjuncts.isEmpty() ? emptyDefault : IrUtils.or(disjuncts);
    }

    public static Expression filterConjuncts(Expression expression, Predicate<Expression> predicate) {
        List<Expression> conjuncts = IrUtils.extractConjuncts(expression).stream().filter(predicate).collect(Collectors.toList());
        return IrUtils.combineConjuncts(conjuncts);
    }

    public static boolean isEffectivelyLiteral(Expression expression, PlannerContext plannerContext, SessionInfo session) {
        String functionName;
        if (expression instanceof Literal) {
            return true;
        }
        if (expression instanceof Cast) {
            return ((Cast)expression).getExpression() instanceof Literal && IrUtils.constantExpressionEvaluatesSuccessfully(plannerContext, session, expression);
        }
        return expression instanceof FunctionCall && ((functionName = ((FunctionCall)expression).getName().getSuffix()).equals("pi") || functionName.equals("e"));
    }

    private static boolean constantExpressionEvaluatesSuccessfully(PlannerContext plannerContext, SessionInfo session, Expression constantExpression) {
        Map<NodeRef<Expression>, Type> types = new IrTypeAnalyzer(plannerContext).getTypes(session, TypeProvider.empty(), constantExpression);
        IrExpressionInterpreter interpreter = new IrExpressionInterpreter(constantExpression, plannerContext, session, types);
        Object literalValue = interpreter.optimize(NoOpSymbolResolver.INSTANCE);
        return !(literalValue instanceof Expression);
    }

    private static List<Expression> removeDuplicates(List<Expression> expressions) {
        HashSet<Expression> seen = new HashSet<Expression>();
        ImmutableList.Builder result = ImmutableList.builder();
        for (Expression expression : expressions) {
            if (!DeterminismEvaluator.isDeterministic(expression)) {
                result.add((Object)expression);
                continue;
            }
            if (seen.contains(expression)) continue;
            result.add((Object)expression);
            seen.add(expression);
        }
        return result.build();
    }
}

