/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.search.MailboxQuery;

public class MultimailboxesSearchQuery {
    private final SearchQuery searchQuery;
    private final ImmutableSet<MailboxId> inMailboxes;
    private final ImmutableSet<MailboxId> notInMailboxes;
    private final Namespace namespace;

    public static Builder from(SearchQuery searchQuery) {
        return new Builder(searchQuery);
    }

    @VisibleForTesting
    MultimailboxesSearchQuery(SearchQuery searchQuery, ImmutableSet<MailboxId> inMailboxes, ImmutableSet<MailboxId> notInMailboxes, Namespace namespace) {
        this.searchQuery = searchQuery;
        this.inMailboxes = inMailboxes;
        this.notInMailboxes = notInMailboxes;
        this.namespace = namespace;
    }

    public ImmutableSet<MailboxId> getInMailboxes() {
        return this.inMailboxes;
    }

    public ImmutableSet<MailboxId> getNotInMailboxes() {
        return this.notInMailboxes;
    }

    public SearchQuery getSearchQuery() {
        return this.searchQuery;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public MultimailboxesSearchQuery addCriterion(SearchQuery.Criterion criterion) {
        return new MultimailboxesSearchQuery(SearchQuery.builder().andCriteria(this.searchQuery.getCriteria()).andCriteria(criterion).sorts(this.searchQuery.getSorts()).build(), this.inMailboxes, this.notInMailboxes, this.namespace);
    }

    public static class Builder {
        private final SearchQuery searchQuery;
        private ImmutableSet.Builder<MailboxId> mailboxIds;
        private ImmutableSet.Builder<MailboxId> notInMailboxIds;
        private Optional<Namespace> namespace;

        private Builder(SearchQuery searchQuery) {
            Preconditions.checkNotNull(searchQuery);
            this.searchQuery = searchQuery;
            this.mailboxIds = ImmutableSet.builder();
            this.notInMailboxIds = ImmutableSet.builder();
            this.namespace = Optional.empty();
        }

        public Builder inMailboxes(Collection<MailboxId> mailboxIds) {
            this.mailboxIds.addAll(mailboxIds);
            return this;
        }

        public Builder inMailboxes(MailboxId ... mailboxIds) {
            return this.inMailboxes(Arrays.asList(mailboxIds));
        }

        public Builder notInMailboxes(Collection<MailboxId> mailboxIds) {
            this.notInMailboxIds.addAll(mailboxIds);
            return this;
        }

        public Builder inNamespace(Namespace namespace) {
            this.namespace = Optional.of(namespace);
            return this;
        }

        public Builder notInMailboxes(MailboxId ... mailboxIds) {
            return this.notInMailboxes(Arrays.asList(mailboxIds));
        }

        public MultimailboxesSearchQuery build() {
            return new MultimailboxesSearchQuery(this.searchQuery, (ImmutableSet<MailboxId>)this.mailboxIds.build(), (ImmutableSet<MailboxId>)this.notInMailboxIds.build(), this.namespace.orElse(new AccessibleNamespace()));
        }
    }

    public static interface Namespace {
        public boolean keepAccessible(Mailbox var1);

        public boolean accessDelegatedMailboxes();

        public MailboxQuery associatedMailboxSearchQuery();
    }

    public static class AccessibleNamespace
    implements Namespace {
        @Override
        public boolean keepAccessible(Mailbox mailbox) {
            return true;
        }

        @Override
        public MailboxQuery associatedMailboxSearchQuery() {
            return MailboxQuery.builder().matchesAllMailboxNames().build();
        }

        public int hashCode() {
            return Objects.hashCode(AccessibleNamespace.class);
        }

        public boolean equals(Object obj) {
            return obj instanceof AccessibleNamespace;
        }

        @Override
        public boolean accessDelegatedMailboxes() {
            return true;
        }
    }

    public static class PersonalNamespace
    implements Namespace {
        private final MailboxSession session;

        public PersonalNamespace(MailboxSession session) {
            this.session = session;
        }

        @Override
        public boolean keepAccessible(Mailbox mailbox) {
            return mailbox.generateAssociatedPath().belongsTo(this.session);
        }

        @Override
        public MailboxQuery associatedMailboxSearchQuery() {
            return MailboxQuery.privateMailboxesBuilder(this.session).matchesAllMailboxNames().build();
        }

        @Override
        public boolean accessDelegatedMailboxes() {
            return false;
        }
    }
}

