/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import jakarta.inject.Inject;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HeloHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeloCmdHandler
extends AbstractHookableCmdHandler<HeloHook> {
    private static final String COMMAND_NAME = "HELO";
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"HELO");
    private static final Response DOMAIN_REQUIRED = new SMTPResponse("501", DSNStatus.getStatus(5, "5.4") + " Domain address required: HELO").immutable();
    public static final Logger LOGGER = LoggerFactory.getLogger(HeloCmdHandler.class);

    @Inject
    public HeloCmdHandler(MetricFactory metricFactory) {
        super(metricFactory);
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected Response doCoreCmd(SMTPSession session, String command, String parameters) {
        if (!this.isValid(parameters)) {
            LOGGER.error("Invalid EHLO argument received: {}. Must be a domain name or an IP address.", (Object)parameters);
            return new SMTPResponse("501", DSNStatus.getStatus(5, "5.2") + " Invalid domain name or ip supplied as HELO argument");
        }
        session.setAttachment(SMTPSession.CURRENT_HELO_MODE, COMMAND_NAME, ProtocolSession.State.Connection);
        StringBuilder response = new StringBuilder();
        response.append(session.getConfiguration().getHelloName()).append(" Hello ").append(parameters).append(" [").append(session.getRemoteAddress().getAddress().getHostAddress()).append("])");
        LOGGER.debug("HELO {} {}", (Object)StringUtils.abbreviate((String)command, (int)80), (Object)StringUtils.abbreviate((String)parameters, (int)80));
        return new SMTPResponse("250", response);
    }

    private boolean isValid(String argument) {
        String hostname = this.unquote(argument);
        return InetAddresses.isUriInetAddress((String)hostname) || InetAddresses.isUriInetAddress((String)("[" + hostname + "]")) || InternetDomainName.isValid((String)hostname);
    }

    private String unquote(String argument) {
        if (argument.startsWith("[") && argument.endsWith("]")) {
            return argument.substring(1, argument.length() - 1);
        }
        return argument;
    }

    @Override
    protected Response doFilterChecks(SMTPSession session, String command, String parameters) {
        session.resetState();
        if (parameters == null) {
            return DOMAIN_REQUIRED;
        }
        session.setAttachment(SMTPSession.CURRENT_HELO_NAME, parameters, ProtocolSession.State.Connection);
        return null;
    }

    @Override
    protected Class<HeloHook> getHookInterface() {
        return HeloHook.class;
    }

    @Override
    protected HookResult callHook(HeloHook rawHook, SMTPSession session, String parameters) {
        return rawHook.doHelo(session, parameters);
    }
}

