/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.task.TaskManager;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.service.DeleteUserDataService;
import org.apache.james.webadmin.service.DeleteUserDataTask;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

public class DeleteUserDataRoutes
implements Routes {
    private static final String USER_PATH_PARAM = ":username";
    private static final String ROOT_PATH = "/users/:username";
    private static final TaskRegistrationKey DELETE_USER_DATA = TaskRegistrationKey.of((String)"deleteData");
    private final UsersRepository usersRepository;
    private final DeleteUserDataService service;
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;

    @Inject
    DeleteUserDataRoutes(UsersRepository usersRepository, DeleteUserDataService service, TaskManager taskManager, JsonTransformer jsonTransformer) {
        this.usersRepository = usersRepository;
        this.service = service;
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return ROOT_PATH;
    }

    public void define(Service service) {
        service.post(ROOT_PATH, this.deleteUserData(), (ResponseTransformer)this.jsonTransformer);
    }

    public Route deleteUserData() {
        return TaskFromRequestRegistry.builder().parameterName("action").register(DELETE_USER_DATA, request -> {
            Username username = Username.of((String)request.params(USER_PATH_PARAM));
            Preconditions.checkArgument((request.queryParams("force") != null || this.usersRepository.contains(username) ? 1 : 0) != 0, (Object)"'username' parameter should be an existing user");
            Optional<DeleteUserDataTaskStep.StepName> fromStep = Optional.ofNullable(request.queryParams("fromStep")).map(DeleteUserDataTaskStep.StepName::new);
            return new DeleteUserDataTask(this.service, username, fromStep);
        }).buildAsRoute(this.taskManager);
    }
}

