/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.atlas.iterator.FilterUnique;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.util.iterator.SingletonIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class Iterators {
    public static <X> Stream<X> asStream(ExtendedIterator<? extends X> iterator) {
        if (iterator instanceof NullIterator) {
            return Stream.empty();
        }
        if (iterator instanceof SingletonIterator) {
            return Stream.of(iterator.next());
        }
        return Iterators.asStream(iterator);
    }

    public static <X> Stream<X> asStream(Iterator<? extends X> iterator) {
        return Iterators.asStream(iterator, 256);
    }

    public static <X> Stream<X> asStream(Iterator<? extends X> iterator, int characteristics) {
        return Iterators.asStream(iterator, -1L, characteristics);
    }

    public static <X> Stream<X> asStream(Iterator<? extends X> iterator, long size, int characteristics) {
        Stream res = StreamSupport.stream(Iterators.asSpliterator(iterator, size, characteristics), false);
        return iterator instanceof ClosableIterator ? (Stream)res.onClose(() -> ((ClosableIterator)((ClosableIterator)iterator)).close()) : res;
    }

    public static <X> Spliterator<X> asSpliterator(Iterator<? extends X> iterator, long size, int characteristics) {
        if (size < 0L) {
            return Spliterators.spliteratorUnknownSize(iterator, characteristics);
        }
        return Spliterators.spliterator(iterator, size, characteristics);
    }

    public static <X> Stream<X> fromSet(Supplier<Set<X>> getAsSet) {
        int chs = 1281;
        return Iterators.asStream(Iterators.create(() -> ((Set)getAsSet.get()).iterator()), chs);
    }

    public static <T, F> ExtendedIterator<T> flatMap(ExtendedIterator<F> base, Function<? super F, ? extends Iterator<? extends T>> mapper) {
        return WrappedIterator.createIteratorIterator((Iterator)base.mapWith(mapper));
    }

    public static <X> ExtendedIterator<X> concat(ExtendedIterator<? extends X> a, ExtendedIterator<? extends X> b) {
        return a.andThen(b);
    }

    @SafeVarargs
    public static <X> ExtendedIterator<X> concat(ExtendedIterator<? extends X> ... iterators) {
        NullIterator res = NullIterator.instance();
        for (ExtendedIterator<? extends X> i : iterators) {
            res = res.andThen(i);
        }
        return res;
    }

    public static <X> ExtendedIterator<X> filter(ExtendedIterator<X> iterator, Predicate<? super X> predicate) {
        return iterator.filterKeep(predicate);
    }

    public static <X> ExtendedIterator<X> peek(ExtendedIterator<X> base, Consumer<? super X> action) {
        return base.mapWith(x -> {
            action.accept((Object)x);
            return x;
        });
    }

    public static <X> ExtendedIterator<X> distinct(ExtendedIterator<X> base) {
        return base.filterKeep((Predicate)new FilterUnique());
    }

    public static <X> boolean anyMatch(Iterator<X> iterator, Predicate<? super X> predicate) {
        if (iterator instanceof NullIterator) {
            return false;
        }
        try {
            while (iterator.hasNext()) {
                if (!predicate.test(iterator.next())) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            Iterators.close(iterator);
        }
        return false;
    }

    public static <X> boolean allMatch(Iterator<X> iterator, Predicate<? super X> predicate) {
        if (iterator instanceof NullIterator) {
            return true;
        }
        try {
            while (iterator.hasNext()) {
                if (predicate.test(iterator.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            Iterators.close(iterator);
        }
        return true;
    }

    public static <X> boolean noneMatch(Iterator<X> iterator, Predicate<? super X> predicate) {
        return Iterators.allMatch(iterator, predicate.negate());
    }

    public static <X> Optional<X> findFirst(Iterator<X> iterator) {
        if (iterator instanceof NullIterator) {
            return Optional.empty();
        }
        try {
            Optional optional = iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
            return optional;
        }
        finally {
            Iterators.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(Iterator<?> iterator) {
        try {
            long res = 0L;
            while (iterator.hasNext()) {
                iterator.next();
                ++res;
            }
            long l = res;
            return l;
        }
        finally {
            Iterators.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasAtLeast(Iterator<?> iterator, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        try {
            long res = 0L;
            while (iterator.hasNext()) {
                iterator.next();
                if (++res != (long)n) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Iterators.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasExactly(Iterator<?> iterator, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        try {
            long res = 0L;
            while (iterator.hasNext()) {
                iterator.next();
                if (++res <= (long)n) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = res == (long)n;
            return bl;
        }
        finally {
            Iterators.close(iterator);
        }
    }

    public static <X> void forEach(Iterator<X> iterator, Consumer<X> action) {
        try {
            while (iterator.hasNext()) {
                action.accept(iterator.next());
            }
        }
        finally {
            Iterators.close(iterator);
        }
    }

    public static <X, C extends Collection<X>> C addAll(Iterator<? extends X> source, C target) {
        if (source instanceof NullIterator) {
            return target;
        }
        try {
            source.forEachRemaining(target::add);
            C c = target;
            return c;
        }
        finally {
            Iterators.close(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X> Set<X> takeAsSet(Iterator<? extends X> source, int number) {
        if (number < 0) {
            throw new IllegalArgumentException();
        }
        if (number == 0) {
            return Set.of();
        }
        HashSet<X> res = new HashSet<X>();
        try {
            boolean i = false;
            while (source.hasNext() && res.size() < number) {
                res.add(source.next());
            }
            HashSet<X> hashSet = res;
            return hashSet;
        }
        finally {
            Iterators.close(source);
        }
    }

    public static <X, K, V, M extends Map<K, V>> M toMap(Iterator<X> iterator, Function<? super X, ? extends K> keyMapper, Function<? super X, ? extends V> valueMapper, BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        Map res = (Map)mapSupplier.get();
        while (iterator.hasNext()) {
            X x = iterator.next();
            K k = keyMapper.apply(x);
            V v = valueMapper.apply(x);
            res.merge(k, v, mergeFunction);
        }
        return (M)res;
    }

    public static void close(Iterator<?> iterator) {
        if (iterator instanceof ClosableIterator) {
            ((ClosableIterator)iterator).close();
        }
    }

    @SafeVarargs
    public static <X> ExtendedIterator<X> of(X ... members) {
        return Iterators.create(Arrays.asList(members));
    }

    public static <X> ExtendedIterator<X> of() {
        return NullIterator.instance();
    }

    public static <X> ExtendedIterator<X> of(X item) {
        return new SingletonIterator(item);
    }

    public static <X> ExtendedIterator<X> create(Collection<? extends X> members) {
        return members.isEmpty() ? NullIterator.instance() : Iterators.create(members.iterator());
    }

    public static <X> ExtendedIterator<X> create(Iterator<? extends X> iterator) {
        return WrappedIterator.create(iterator);
    }

    public static <X> ExtendedIterator<X> create(final Supplier<Iterator<? extends X>> provider) {
        Objects.requireNonNull(provider);
        return new NiceIterator<X>(){
            private Iterator<? extends X> base;

            Iterator<? extends X> base() {
                return this.base == null ? (this.base = Objects.requireNonNull((Iterator)provider.get())) : this.base;
            }

            public boolean hasNext() {
                return this.base().hasNext();
            }

            public X next() {
                return this.base().next();
            }

            public void remove() {
                this.base().remove();
            }

            public void close() {
                if (this.base != null) {
                    1.close(this.base);
                }
            }
        };
    }
}

