/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library.leviathan;

import java.math.BigInteger;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionBase1;

public class cube
extends FunctionBase1 {
    @Override
    public NodeValue exec(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("cube", v)) {
            case OP_INTEGER: {
                BigInteger i = v.getInteger();
                return NodeValue.makeInteger(i.pow(3));
            }
            case OP_DECIMAL: {
                double dec = v.getDecimal().doubleValue();
                return NodeValue.makeDecimal(Math.pow(dec, 3.0));
            }
            case OP_FLOAT: 
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.pow(v.getDouble(), 3.0));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + String.valueOf(v));
    }
}

