/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw;

import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetWriter;
import org.apache.jena.riot.rowset.RowSetWriterFactory;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;

public class RowSetWriterCSV
implements RowSetWriter {
    public static RowSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_CSV)) {
            throw new ResultSetException("RowSetWriter for CSV asked for a " + String.valueOf(lang));
        }
        return new RowSetWriterCSV();
    };
    static final String NL = "\r\n";
    static final String headerBytes = "_askResult\r\n";
    static final String yesString = "true";
    static final String noString = "false";

    private RowSetWriterCSV() {
    }

    @Override
    public void write(OutputStream out, RowSet resultSet, Context context2) {
        RowSetWriterCSV.output(IO.wrapUTF8(out), resultSet, context2);
    }

    @Override
    public void write(Writer out, RowSet resultSet, Context context2) {
        RowSetWriterCSV.output(IO.wrap(out), resultSet, context2);
    }

    @Override
    public void write(OutputStream out, boolean result, Context context2) {
        RowSetWriterCSV.output(IO.wrapUTF8(out), result);
    }

    private static void output(AWriter out, boolean booleanResult) {
        try {
            out.write(headerBytes);
            if (booleanResult) {
                out.write(yesString);
            } else {
                out.write(noString);
            }
            out.write(NL);
        }
        finally {
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void output(AWriter out, RowSet rowSet, Context context2) {
        try {
            boolean outputGraphBNodeLabels = context2 != null && context2.isTrue(ARQ.outputGraphBNodeLabels);
            NodeToLabel bnodes = outputGraphBNodeLabels ? SyntaxLabels.createNodeToLabelAsGiven() : SyntaxLabels.createNodeToLabel();
            String sep = null;
            List<Var> vars = rowSet.getResultVars();
            for (Var var : vars) {
                String string = var.getVarName();
                if (sep != null) {
                    out.write(sep);
                } else {
                    sep = ",";
                }
                out.write(RowSetWriterCSV.csvSafe(string));
            }
            out.write(NL);
            while (rowSet.hasNext()) {
                sep = null;
                Binding b = rowSet.next();
                for (Var var : vars) {
                    if (sep != null) {
                        out.write(sep);
                    }
                    sep = ",";
                    Node n = b.get(var);
                    if (n == null) continue;
                    RowSetWriterCSV.output(out, n, bnodes);
                }
                out.write(NL);
            }
        }
        finally {
            out.flush();
        }
    }

    private static void output(AWriter w, Node n, NodeToLabel bnodes) {
        String str2 = "?";
        if (n.isLiteral()) {
            str2 = n.getLiteralLexicalForm();
        } else if (n.isURI()) {
            str2 = n.getURI();
        } else if (n.isBlank()) {
            str2 = (String)bnodes.get(null, n);
            str2 = str2.substring(2);
        }
        str2 = RowSetWriterCSV.csvSafe(str2);
        w.write(str2);
        w.flush();
    }

    protected static String csvSafe(String str2) {
        if (((String)str2).contains("\"") || ((String)str2).contains(",") || ((String)str2).contains("\r") || ((String)str2).contains("\n")) {
            str2 = "\"" + ((String)str2).replaceAll("\"", "\"\"") + "\"";
        } else if (((String)str2).isEmpty()) {
            str2 = "\"\"";
        }
        return str2;
    }
}

