/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.Boundable;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.STRtree;

public class STRtreeSerializer
extends Serializer<STRtree> {
    @Override
    public STRtree read(Kryo kryo, Input input, Class<STRtree> type) {
        boolean notEmpty;
        int nodeCapacity = input.readInt();
        boolean bl = notEmpty = (input.readByte() & 1) == 1;
        if (notEmpty) {
            boolean built;
            boolean bl2 = built = (input.readByte() & 1) == 1;
            if (built) {
                STRtree index = new STRtree(nodeCapacity, this.readSTRtreeNode(kryo, input));
                return index;
            }
            ArrayList<ItemBoundable> itemBoundables = new ArrayList<ItemBoundable>();
            int itemSize = input.readInt();
            for (int i = 0; i < itemSize; ++i) {
                itemBoundables.add(this.readItemBoundable(kryo, input));
            }
            STRtree index = new STRtree(nodeCapacity, itemBoundables);
            return index;
        }
        return new STRtree(nodeCapacity);
    }

    @Override
    public void write(Kryo kryo, Output output, STRtree tree) {
        output.writeInt(tree.getNodeCapacity());
        if (tree.isEmpty()) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            boolean isBuilt = tree.getItemBoundables() == null;
            output.writeByte(isBuilt ? 1 : 0);
            if (!isBuilt) {
                ArrayList itemBoundables = tree.getItemBoundables();
                output.writeInt(itemBoundables.size());
                for (Object obj : itemBoundables) {
                    if (!(obj instanceof ItemBoundable)) {
                        throw new UnsupportedOperationException(" itemBoundables should only contain ItemBoundable objects ");
                    }
                    ItemBoundable itemBoundable = (ItemBoundable)obj;
                    this.writeItemBoundable(kryo, output, itemBoundable);
                }
            } else {
                this.writeSTRTreeNode(kryo, output, tree.getRoot());
            }
        }
    }

    private void writeSTRTreeNode(Kryo kryo, Output output, AbstractNode node) {
        output.writeInt(node.getLevel());
        List children = node.getChildBoundables();
        int childrenSize = children.size();
        output.writeInt(childrenSize);
        if (childrenSize > 0) {
            if (children.get(0) instanceof AbstractNode) {
                output.writeByte(0);
                for (Object obj : children) {
                    AbstractNode child = (AbstractNode)obj;
                    this.writeSTRTreeNode(kryo, output, child);
                }
            } else if (children.get(0) instanceof ItemBoundable) {
                output.writeByte(1);
                for (Object obj : children) {
                    this.writeItemBoundable(kryo, output, (ItemBoundable)obj);
                }
            } else {
                throw new UnsupportedOperationException("wrong node type of STRtree");
            }
        }
    }

    private STRtree.STRtreeNode readSTRtreeNode(Kryo kryo, Input input) {
        int level = input.readInt();
        STRtree.STRtreeNode node = new STRtree.STRtreeNode(level);
        int childrenSize = input.readInt();
        boolean isLeaf = (input.readByte() & 1) == 1;
        ArrayList<Boundable> children = new ArrayList<Boundable>();
        if (isLeaf) {
            for (int i = 0; i < childrenSize; ++i) {
                children.add(this.readItemBoundable(kryo, input));
            }
        } else {
            for (int i = 0; i < childrenSize; ++i) {
                children.add(this.readSTRtreeNode(kryo, input));
            }
        }
        node.setChildBoundables(children);
        return node;
    }

    private void writeItemBoundable(Kryo kryo, Output output, ItemBoundable itemBoundable) {
        kryo.writeObject(output, itemBoundable.getBounds());
        kryo.writeClassAndObject(output, itemBoundable.getItem());
    }

    private ItemBoundable readItemBoundable(Kryo kryo, Input input) {
        Envelope envelope = kryo.readObject(input, Envelope.class);
        Object item = kryo.readClassAndObject(input);
        return new ItemBoundable(envelope, item);
    }
}

