/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.bean.openapi3.Discriminator;
import org.apache.juneau.bean.openapi3.ExternalDocumentation;
import org.apache.juneau.bean.openapi3.Items;
import org.apache.juneau.bean.openapi3.OpenApi;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.bean.openapi3.Xml;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class SchemaInfo
extends OpenApiElement {
    private String format;
    private String title;
    private String description;
    private String pattern;
    private String ref;
    private String type;
    private Number multipleOf;
    private Number maximum;
    private Number minimum;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxItems;
    private Integer minItems;
    private Integer maxProperties;
    private Integer minProperties;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private Boolean uniqueItems;
    private Boolean nullable;
    private Boolean writeOnly;
    private Boolean readOnly;
    private Boolean deprecated;
    private Object default_;
    private Object example;
    private Items items;
    private Xml xml;
    private ExternalDocumentation externalDocs;
    private List<Object> allOf = CollectionUtils.list(new Object[0]);
    private List<Object> oneOf = CollectionUtils.list(new Object[0]);
    private List<Object> anyOf = CollectionUtils.list(new Object[0]);
    private List<Object> enum_ = CollectionUtils.list(new Object[0]);
    private List<String> required = CollectionUtils.list(new String[0]);
    private Discriminator discriminator;
    private Map<String, SchemaInfo> properties;
    private SchemaInfo additionalProperties;
    private SchemaInfo not;

    public SchemaInfo() {
    }

    public SchemaInfo(SchemaInfo copyFrom) {
        super(copyFrom);
        this.format = copyFrom.format;
        this.title = copyFrom.title;
        this.description = copyFrom.description;
        this.ref = copyFrom.ref;
        this.nullable = copyFrom.nullable;
        this.writeOnly = copyFrom.writeOnly;
        this.deprecated = copyFrom.deprecated;
        this.pattern = copyFrom.pattern;
        this.type = copyFrom.type;
        this.discriminator = copyFrom.discriminator;
        this.multipleOf = copyFrom.multipleOf;
        this.maximum = copyFrom.maximum;
        this.minimum = copyFrom.minimum;
        this.maxLength = copyFrom.maxLength;
        this.minLength = copyFrom.minLength;
        this.maxItems = copyFrom.maxItems;
        this.minItems = copyFrom.minItems;
        this.maxProperties = copyFrom.maxProperties;
        this.minProperties = copyFrom.minProperties;
        this.exclusiveMaximum = copyFrom.exclusiveMaximum;
        this.exclusiveMinimum = copyFrom.exclusiveMinimum;
        this.uniqueItems = copyFrom.uniqueItems;
        this.readOnly = copyFrom.readOnly;
        this.default_ = copyFrom.default_;
        this.example = copyFrom.example;
        this.items = copyFrom.items == null ? null : copyFrom.items.copy();
        this.xml = copyFrom.xml == null ? null : copyFrom.xml.copy();
        ExternalDocumentation externalDocumentation = this.externalDocs = copyFrom.externalDocs == null ? null : copyFrom.externalDocs.copy();
        if (Utils.nn(copyFrom.enum_)) {
            this.enum_.addAll(copyFrom.enum_);
        }
        if (Utils.nn(copyFrom.allOf)) {
            this.allOf.addAll(copyFrom.allOf);
        }
        if (Utils.nn(copyFrom.required)) {
            this.required.addAll(copyFrom.required);
        }
        if (Utils.nn(copyFrom.anyOf)) {
            this.anyOf.addAll(copyFrom.anyOf);
        }
        if (Utils.nn(copyFrom.oneOf)) {
            this.oneOf.addAll(copyFrom.oneOf);
        }
        this.properties = CollectionUtils.copyOf(copyFrom.properties, SchemaInfo::copy);
        this.additionalProperties = copyFrom.additionalProperties == null ? null : copyFrom.additionalProperties.copy();
        this.not = copyFrom.not == null ? null : copyFrom.not.copy();
    }

    public SchemaInfo addAllOf(Object ... values) {
        if (Utils.nn(values)) {
            for (Object v : values) {
                if (!Utils.nn(v)) continue;
                this.allOf.add(v);
            }
        }
        return this;
    }

    public SchemaInfo addAnyOf(Object ... values) {
        if (Utils.nn(values)) {
            for (Object v : values) {
                if (!Utils.nn(v)) continue;
                this.anyOf.add(v);
            }
        }
        return this;
    }

    public SchemaInfo addEnum(Object ... values) {
        if (Utils.nn(values)) {
            for (Object v : values) {
                if (!Utils.nn(v)) continue;
                this.enum_.add(v);
            }
        }
        return this;
    }

    public SchemaInfo addOneOf(Object ... values) {
        if (Utils.nn(values)) {
            for (Object v : values) {
                if (!Utils.nn(v)) continue;
                this.oneOf.add(v);
            }
        }
        return this;
    }

    public SchemaInfo addRequired(String ... values) {
        if (Utils.nn(values)) {
            for (String v : values) {
                if (!Utils.nn(v)) continue;
                this.required.add(v);
            }
        }
        return this;
    }

    public SchemaInfo copy() {
        return new SchemaInfo(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "format" -> ConverterUtils.toType(this.getFormat(), type);
            case "title" -> ConverterUtils.toType(this.getTitle(), type);
            case "description" -> ConverterUtils.toType(this.getDescription(), type);
            case "default" -> ConverterUtils.toType(this.getDefault(), type);
            case "multipleOf" -> ConverterUtils.toType(this.getMultipleOf(), type);
            case "maximum" -> ConverterUtils.toType(this.getMaximum(), type);
            case "exclusiveMaximum" -> ConverterUtils.toType(this.getExclusiveMaximum(), type);
            case "minimum" -> ConverterUtils.toType(this.getMinimum(), type);
            case "exclusiveMinimum" -> ConverterUtils.toType(this.getExclusiveMinimum(), type);
            case "maxLength" -> ConverterUtils.toType(this.getMaxLength(), type);
            case "minLength" -> ConverterUtils.toType(this.getMinLength(), type);
            case "pattern" -> ConverterUtils.toType(this.getPattern(), type);
            case "maxItems" -> ConverterUtils.toType(this.getMaxItems(), type);
            case "minItems" -> ConverterUtils.toType(this.getMinItems(), type);
            case "uniqueItems" -> ConverterUtils.toType(this.getUniqueItems(), type);
            case "maxProperties" -> ConverterUtils.toType(this.getMaxProperties(), type);
            case "minProperties" -> ConverterUtils.toType(this.getMinProperties(), type);
            case "required" -> ConverterUtils.toType(this.getRequired(), type);
            case "enum" -> ConverterUtils.toType(this.getEnum(), type);
            case "type" -> ConverterUtils.toType(this.getType(), type);
            case "items" -> ConverterUtils.toType(this.getItems(), type);
            case "allOf" -> ConverterUtils.toType(this.getAllOf(), type);
            case "oneOf" -> ConverterUtils.toType(this.getOneOf(), type);
            case "anyOf" -> ConverterUtils.toType(this.getAnyOf(), type);
            case "properties" -> ConverterUtils.toType(this.getProperties(), type);
            case "additionalProperties" -> ConverterUtils.toType(this.getAdditionalProperties(), type);
            case "not" -> ConverterUtils.toType(this.getNot(), type);
            case "nullable" -> ConverterUtils.toType(this.getNullable(), type);
            case "deprecated" -> ConverterUtils.toType(this.getDeprecated(), type);
            case "discriminator" -> ConverterUtils.toType(this.getDiscriminator(), type);
            case "readOnly" -> ConverterUtils.toType(this.getReadOnly(), type);
            case "writeOnly" -> ConverterUtils.toType(this.getWriteOnly(), type);
            case "xml" -> ConverterUtils.toType(this.getXml(), type);
            case "externalDocs" -> ConverterUtils.toType(this.getExternalDocs(), type);
            case "example" -> ConverterUtils.toType(this.getExample(), type);
            case "$ref" -> ConverterUtils.toType(this.getRef(), type);
            default -> super.get(property, type);
        };
    }

    public SchemaInfo getAdditionalProperties() {
        return this.additionalProperties;
    }

    public List<Object> getAllOf() {
        return Utils.nullIfEmpty(this.allOf);
    }

    public List<Object> getAnyOf() {
        return Utils.nullIfEmpty(this.anyOf);
    }

    public Object getDefault() {
        return this.default_;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public Discriminator getDiscriminator() {
        return this.discriminator;
    }

    public List<Object> getEnum() {
        return Utils.nullIfEmpty(this.enum_);
    }

    public Object getExample() {
        return this.example;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public String getFormat() {
        return this.format;
    }

    public Items getItems() {
        return this.items;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public SchemaInfo getNot() {
        return this.not;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public List<Object> getOneOf() {
        return Utils.nullIfEmpty(this.oneOf);
    }

    public String getPattern() {
        return this.pattern;
    }

    public Map<String, SchemaInfo> getProperties() {
        return this.properties;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Beanp(value="$ref")
    public String getRef() {
        return this.ref;
    }

    public List<String> getRequired() {
        return Utils.nullIfEmpty(this.required);
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public Boolean getWriteOnly() {
        return this.writeOnly;
    }

    public Xml getXml() {
        return this.xml;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.ref), "$ref").addIf(Utils.nn(this.additionalProperties), "additionalProperties").addIf(Utils.ne(this.allOf), "allOf").addIf(Utils.ne(this.anyOf), "anyOf").addIf(Utils.nn(this.default_), "default").addIf(Utils.nn(this.deprecated), "deprecated").addIf(Utils.nn(this.description), "description").addIf(Utils.nn(this.discriminator), "discriminator").addIf(Utils.ne(this.enum_), "enum").addIf(Utils.nn(this.example), "example").addIf(Utils.nn(this.exclusiveMaximum), "exclusiveMaximum").addIf(Utils.nn(this.exclusiveMinimum), "exclusiveMinimum").addIf(Utils.nn(this.externalDocs), "externalDocs").addIf(Utils.nn(this.format), "format").addIf(Utils.nn(this.items), "items").addIf(Utils.nn(this.maxItems), "maxItems").addIf(Utils.nn(this.maxLength), "maxLength").addIf(Utils.nn(this.maxProperties), "maxProperties").addIf(Utils.nn(this.maximum), "maximum").addIf(Utils.nn(this.minItems), "minItems").addIf(Utils.nn(this.minLength), "minLength").addIf(Utils.nn(this.minProperties), "minProperties").addIf(Utils.nn(this.minimum), "minimum").addIf(Utils.nn(this.multipleOf), "multipleOf").addIf(Utils.nn(this.not), "not").addIf(Utils.nn(this.nullable), "nullable").addIf(Utils.ne(this.oneOf), "oneOf").addIf(Utils.nn(this.pattern), "pattern").addIf(Utils.nn(this.properties), "properties").addIf(Utils.nn(this.readOnly), "readOnly").addIf(Utils.ne(this.required), "required").addIf(Utils.nn(this.title), "title").addIf(Utils.nn(this.type), "type").addIf(Utils.nn(this.uniqueItems), "uniqueItems").addIf(Utils.nn(this.writeOnly), "writeOnly").addIf(Utils.nn(this.xml), "xml").build();
        return new MultiSet<String>(s, super.keySet());
    }

    public SchemaInfo resolveRefs(OpenApi openApi, Deque<String> refStack, int maxDepth) {
        if (Utils.nn(this.ref)) {
            if (refStack.contains(this.ref) || refStack.size() >= maxDepth) {
                return this;
            }
            refStack.addLast(this.ref);
            SchemaInfo r = openApi.findRef(this.ref, SchemaInfo.class);
            r = r.resolveRefs(openApi, refStack, maxDepth);
            refStack.removeLast();
            return r;
        }
        if (Utils.nn(this.items)) {
            this.items = this.items.resolveRefs(openApi, refStack, maxDepth);
        }
        if (Utils.nn(this.properties)) {
            for (Map.Entry<String, SchemaInfo> e : this.properties.entrySet()) {
                e.setValue(e.getValue().resolveRefs(openApi, refStack, maxDepth));
            }
        }
        if (Utils.nn(this.additionalProperties)) {
            this.additionalProperties = this.additionalProperties.resolveRefs(openApi, refStack, maxDepth);
        }
        this.example = null;
        return this;
    }

    @Override
    public SchemaInfo set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "$ref" -> this.setRef(value);
            case "additionalProperties" -> this.setAdditionalProperties(ConverterUtils.toType(value, SchemaInfo.class));
            case "allOf" -> this.setAllOf(CollectionUtils.listb(Object.class).addAny(value).sparse().build());
            case "anyOf" -> this.setAnyOf(CollectionUtils.listb(Object.class).addAny(value).sparse().build());
            case "default" -> this.setDefault(value);
            case "deprecated" -> this.setDeprecated(ConverterUtils.toBoolean(value));
            case "description" -> this.setDescription(Utils.s(value));
            case "discriminator" -> this.setDiscriminator(ConverterUtils.toType(value, Discriminator.class));
            case "enum" -> this.setEnum(CollectionUtils.listb(Object.class).addAny(value).sparse().build());
            case "example" -> this.setExample(value);
            case "exclusiveMaximum" -> this.setExclusiveMaximum(ConverterUtils.toBoolean(value));
            case "exclusiveMinimum" -> this.setExclusiveMinimum(ConverterUtils.toBoolean(value));
            case "externalDocs" -> this.setExternalDocs(ConverterUtils.toType(value, ExternalDocumentation.class));
            case "format" -> this.setFormat(Utils.s(value));
            case "items" -> this.setItems(ConverterUtils.toType(value, Items.class));
            case "maxItems" -> this.setMaxItems(ConverterUtils.toInteger(value));
            case "maxLength" -> this.setMaxLength(ConverterUtils.toInteger(value));
            case "maxProperties" -> this.setMaxProperties(ConverterUtils.toInteger(value));
            case "maximum" -> this.setMaximum(ConverterUtils.toNumber(value));
            case "minItems" -> this.setMinItems(ConverterUtils.toInteger(value));
            case "minLength" -> this.setMinLength(ConverterUtils.toInteger(value));
            case "minProperties" -> this.setMinProperties(ConverterUtils.toInteger(value));
            case "minimum" -> this.setMinimum(ConverterUtils.toNumber(value));
            case "multipleOf" -> this.setMultipleOf(ConverterUtils.toNumber(value));
            case "not" -> this.setNot(ConverterUtils.toType(value, SchemaInfo.class));
            case "nullable" -> this.setNullable(ConverterUtils.toBoolean(value));
            case "oneOf" -> this.setOneOf(CollectionUtils.listb(Object.class).addAny(value).sparse().build());
            case "pattern" -> this.setPattern(Utils.s(value));
            case "properties" -> this.setProperties(ConverterUtils.toMapBuilder(value, String.class, SchemaInfo.class).sparse().build());
            case "readOnly" -> this.setReadOnly(ConverterUtils.toBoolean(value));
            case "required" -> this.setRequired(CollectionUtils.listb(String.class).addAny(value).sparse().build());
            case "title" -> this.setTitle(Utils.s(value));
            case "type" -> this.setType(Utils.s(value));
            case "uniqueItems" -> this.setUniqueItems(ConverterUtils.toBoolean(value));
            case "writeOnly" -> this.setWriteOnly(ConverterUtils.toBoolean(value));
            case "xml" -> this.setXml(ConverterUtils.toType(value, Xml.class));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public SchemaInfo setAdditionalProperties(SchemaInfo value) {
        this.additionalProperties = value;
        return this;
    }

    public SchemaInfo setAllOf(Collection<Object> value) {
        this.allOf.clear();
        if (Utils.nn(value)) {
            this.allOf.addAll(value);
        }
        return this;
    }

    public SchemaInfo setAnyOf(Collection<Object> value) {
        this.anyOf.clear();
        if (Utils.nn(value)) {
            this.anyOf.addAll(value);
        }
        return this;
    }

    public SchemaInfo setDefault(Object value) {
        this.default_ = value;
        return this;
    }

    public SchemaInfo setDeprecated(Boolean value) {
        this.deprecated = value;
        return this;
    }

    public SchemaInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public SchemaInfo setDiscriminator(Discriminator value) {
        this.discriminator = value;
        return this;
    }

    public SchemaInfo setEnum(Collection<Object> value) {
        this.enum_.clear();
        if (Utils.nn(value)) {
            this.enum_.addAll(value);
        }
        return this;
    }

    public SchemaInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    public SchemaInfo setExclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = value;
        return this;
    }

    public SchemaInfo setExclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = value;
        return this;
    }

    public SchemaInfo setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public SchemaInfo setFormat(String value) {
        this.format = value;
        return this;
    }

    public SchemaInfo setItems(Items value) {
        this.items = value;
        return this;
    }

    public SchemaInfo setMaximum(Number value) {
        this.maximum = value;
        return this;
    }

    public SchemaInfo setMaxItems(Integer value) {
        this.maxItems = value;
        return this;
    }

    public SchemaInfo setMaxLength(Integer value) {
        this.maxLength = value;
        return this;
    }

    public SchemaInfo setMaxProperties(Integer value) {
        this.maxProperties = value;
        return this;
    }

    public SchemaInfo setMinimum(Number value) {
        this.minimum = value;
        return this;
    }

    public SchemaInfo setMinItems(Integer value) {
        this.minItems = value;
        return this;
    }

    public SchemaInfo setMinLength(Integer value) {
        this.minLength = value;
        return this;
    }

    public SchemaInfo setMinProperties(Integer value) {
        this.minProperties = value;
        return this;
    }

    public SchemaInfo setMultipleOf(Number value) {
        this.multipleOf = value;
        return this;
    }

    public SchemaInfo setNot(SchemaInfo value) {
        this.not = value;
        return this;
    }

    public SchemaInfo setNullable(Boolean value) {
        this.nullable = value;
        return this;
    }

    public SchemaInfo setOneOf(Collection<Object> value) {
        this.oneOf.clear();
        if (Utils.nn(value)) {
            this.oneOf.addAll(value);
        }
        return this;
    }

    public SchemaInfo setPattern(String value) {
        this.pattern = value;
        return this;
    }

    public SchemaInfo setProperties(Map<String, SchemaInfo> value) {
        this.properties = CollectionUtils.copyOf(value);
        return this;
    }

    public SchemaInfo setReadOnly(Boolean value) {
        this.readOnly = value;
        return this;
    }

    @Beanp(value="$ref")
    public SchemaInfo setRef(Object value) {
        this.ref = Utils.s(value);
        return this;
    }

    public SchemaInfo setRequired(Collection<String> value) {
        this.required.clear();
        if (Utils.nn(value)) {
            this.required.addAll(value);
        }
        return this;
    }

    public SchemaInfo setTitle(String value) {
        this.title = value;
        return this;
    }

    public SchemaInfo setType(String value) {
        this.type = value;
        return this;
    }

    public SchemaInfo setUniqueItems(Boolean value) {
        this.uniqueItems = value;
        return this;
    }

    public SchemaInfo setWriteOnly(Boolean value) {
        this.writeOnly = value;
        return this;
    }

    public SchemaInfo setXml(Xml value) {
        this.xml = value;
        return this;
    }

    @Override
    public SchemaInfo strict() {
        super.strict();
        return this;
    }

    @Override
    public SchemaInfo strict(Object value) {
        super.strict(value);
        return this;
    }
}

