/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import java.util.Map;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.SimpleMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;

public class UrlPathMatch {
    private final int matchedParts;
    private final String path;
    private final Map<String, String> vars;

    protected UrlPathMatch(String path, int matchedParts, String[] keys, String[] values) {
        this.path = path;
        this.matchedParts = matchedParts;
        this.vars = keys == null ? CollectionUtils.mape() : new SimpleMap<String, String>(keys, values);
    }

    public String getPrefix() {
        int c = 0;
        for (int j = 0; j < this.matchedParts; ++j) {
            if ((c = this.path.indexOf(47, c + 1)) != -1) continue;
            c = this.path.length();
        }
        return Utils.nullIfEmpty(this.path.substring(0, c));
    }

    public String getRemainder() {
        String suffix = this.getSuffix();
        if (Utils.ne(suffix) && suffix.charAt(0) == '/') {
            suffix = suffix.substring(1);
        }
        return suffix;
    }

    public String getSuffix() {
        String s = this.path;
        for (int j = 0; j < this.matchedParts; ++j) {
            int k = s.indexOf(47, 1);
            if (k == -1) {
                return null;
            }
            s = s.substring(k);
        }
        return s;
    }

    public Map<String, String> getVars() {
        return this.vars;
    }

    public boolean hasEmptyVars() {
        for (String v : this.vars.values()) {
            if (!StringUtils.isEmpty(v)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVars() {
        return !this.vars.isEmpty();
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a("r", this.getRemainder()).a("v", this.getVars());
    }

    public String toString() {
        return Utils.r(this.properties());
    }
}

