/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.stream.Collectors;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class ReversedList<E>
extends AbstractList<E>
implements RandomAccess {
    private final List<E> list;

    public ReversedList(List<E> list) {
        this.list = AssertionUtils.assertArgNotNull("list", list);
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("ReversedList is read-only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ReversedList is read-only");
    }

    @Override
    public E get(int index) {
        return this.list.get(this.list.size() - 1 - index);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final ListIterator<E> it;
            {
                this.it = ReversedList.this.list.listIterator(ReversedList.this.list.size());
            }

            @Override
            public boolean hasNext() {
                return this.it.hasPrevious();
            }

            @Override
            public E next() {
                return this.it.previous();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("ReversedList is read-only");
            }
        };
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        return new ListIterator<E>(){
            private final ListIterator<E> it;
            {
                this.it = ReversedList.this.list.listIterator(ReversedList.this.list.size() - index);
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException("ReversedList is read-only");
            }

            @Override
            public boolean hasNext() {
                return this.it.hasPrevious();
            }

            @Override
            public boolean hasPrevious() {
                return this.it.hasNext();
            }

            @Override
            public E next() {
                return this.it.previous();
            }

            @Override
            public int nextIndex() {
                return ReversedList.this.list.size() - this.it.previousIndex() - 1;
            }

            @Override
            public E previous() {
                return this.it.next();
            }

            @Override
            public int previousIndex() {
                return ReversedList.this.list.size() - this.it.nextIndex() - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("ReversedList is read-only");
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException("ReversedList is read-only");
            }
        };
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("ReversedList is read-only");
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("ReversedList is read-only");
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + ", size: " + this.size());
        }
        int translatedFrom = this.list.size() - toIndex;
        int translatedTo = this.list.size() - fromIndex;
        return new ReversedList<E>(this.list.subList(translatedFrom, translatedTo));
    }

    @Override
    public String toString() {
        return this.stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof List)) {
            return false;
        }
        return Utils.eq(this, (List)o, (x, y) -> {
            ListIterator e1 = x.listIterator();
            ListIterator e2 = y.listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                Object o2;
                Object o1 = e1.next();
                if (Utils.eq(o1, o2 = e2.next())) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        });
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }
}

