/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.internals.KafkaFutureImpl;

public class DeleteShareGroupOffsetsResult {
    private final KafkaFuture<Map<String, ApiException>> future;
    private final Set<String> topics;

    DeleteShareGroupOffsetsResult(KafkaFuture<Map<String, ApiException>> future, Set<String> topics) {
        this.future = future;
        this.topics = topics;
    }

    public KafkaFuture<Void> all() {
        KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.future.whenComplete((topicResults, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else {
                for (String topic : this.topics) {
                    if (!this.maybeCompleteExceptionally((Map<String, ApiException>)topicResults, topic, result)) continue;
                    return;
                }
                result.complete(null);
            }
        });
        return result;
    }

    public KafkaFuture<Void> topicResult(String topic) {
        if (!this.topics.contains(topic)) {
            throw new IllegalArgumentException("Topic " + topic + " was not included in the original request");
        }
        KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.future.whenComplete((topicResults, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else if (!this.maybeCompleteExceptionally((Map<String, ApiException>)topicResults, topic, result)) {
                result.complete(null);
            }
        });
        return result;
    }

    private boolean maybeCompleteExceptionally(Map<String, ApiException> topicLevelErrors, String topic, KafkaFutureImpl<Void> result) {
        Throwable exception = !topicLevelErrors.containsKey(topic) ? new IllegalArgumentException("Offset deletion result for topic \"" + topic + "\" was not included in the response") : (Throwable)topicLevelErrors.get(topic);
        if (exception != null) {
            result.completeExceptionally(exception);
            return true;
        }
        return false;
    }
}

