/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.util.RegexMatcher;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaShareConsumer;
import org.apache.kafka.clients.consumer.ShareConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.ToolsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShareConsumerPerformance {
    private static final Logger LOG = LoggerFactory.getLogger(ShareConsumerPerformance.class);

    public static void main(String[] args) {
        ShareConsumerPerformance.run(args, KafkaShareConsumer::new);
    }

    static void run(String[] args, Function<Properties, ShareConsumer<byte[], byte[]>> shareConsumerCreator) {
        try {
            LOG.info("Starting share consumer/consumers...");
            ShareConsumerPerfOptions options = new ShareConsumerPerfOptions(args);
            AtomicLong totalRecordsRead = new AtomicLong(0L);
            AtomicLong totalBytesRead = new AtomicLong(0L);
            if (!options.hideHeader()) {
                ShareConsumerPerformance.printHeader();
            }
            ArrayList<ShareConsumer<byte[], byte[]>> shareConsumers = new ArrayList<ShareConsumer<byte[], byte[]>>();
            ArrayList<String> clientIds = new ArrayList<String>();
            for (int i = 0; i < options.threads(); ++i) {
                if (options.threads() == 1) {
                    clientIds.add(options.props().getProperty("client.id"));
                    shareConsumers.add(shareConsumerCreator.apply(options.props()));
                    break;
                }
                Properties shareConsumerProps = options.props();
                String shareConsumerClientId = options.props().getProperty("client.id") + "-" + (i + 1);
                shareConsumerProps.put("client.id", shareConsumerClientId);
                clientIds.add(shareConsumerClientId);
                shareConsumers.add(shareConsumerCreator.apply(shareConsumerProps));
            }
            long startMs = System.currentTimeMillis();
            ShareConsumerPerformance.consume(shareConsumers, options, totalRecordsRead, totalBytesRead, startMs, clientIds);
            long endMs = System.currentTimeMillis();
            ArrayList shareConsumersMetrics = new ArrayList();
            if (options.printMetrics()) {
                shareConsumers.forEach(shareConsumer -> shareConsumersMetrics.add(shareConsumer.metrics()));
            }
            shareConsumers.forEach(shareConsumer -> {
                Map ignored = shareConsumer.commitSync();
            });
            double elapsedSec = (double)(endMs - startMs) / 1000.0;
            long fetchTimeInMs = endMs - startMs;
            ShareConsumerPerformance.printStatsForShareGroup(totalBytesRead.get(), totalRecordsRead.get(), elapsedSec, fetchTimeInMs, startMs, endMs, options.dateFormat());
            shareConsumersMetrics.forEach(ToolsUtils::printMetrics);
            shareConsumers.forEach(shareConsumer -> shareConsumer.close(Duration.ofMillis(500L)));
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            Exit.exit((int)1);
        }
    }

    protected static void printHeader() {
        String newFieldsInHeader = ", fetch.time.ms";
        System.out.printf("start.time, end.time, data.consumed.in.MB, MB.sec, nMsg.sec, data.consumed.in.nMsg%s%n", newFieldsInHeader);
    }

    private static void consume(List<ShareConsumer<byte[], byte[]>> shareConsumers, ShareConsumerPerfOptions options, AtomicLong totalRecordsRead, AtomicLong totalBytesRead, long startMs, List<String> clientIds) throws ExecutionException, InterruptedException {
        long numRecords = options.numRecords();
        long recordFetchTimeoutMs = options.recordFetchTimeoutMs();
        shareConsumers.forEach(shareConsumer -> shareConsumer.subscribe(options.topic()));
        AtomicLong recordsRead = new AtomicLong(0L);
        AtomicLong bytesRead = new AtomicLong(0L);
        ArrayList<ShareConsumerConsumption> shareConsumersConsumptionDetails = new ArrayList<ShareConsumerConsumption>();
        ExecutorService executorService = Executors.newFixedThreadPool(shareConsumers.size());
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < shareConsumers.size()) {
            int n = i++;
            ShareConsumerConsumption shareConsumerConsumption = new ShareConsumerConsumption(0L, 0L);
            futures.add(executorService.submit(() -> {
                try {
                    ShareConsumerPerformance.consumeRecordsForSingleShareConsumer((ShareConsumer<byte[], byte[]>)((ShareConsumer)shareConsumers.get(index)), recordsRead, bytesRead, options, shareConsumerConsumption, index + 1);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }));
            shareConsumersConsumptionDetails.add(shareConsumerConsumption);
        }
        LOG.debug("Shutting down of thread pool is started");
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(recordFetchTimeoutMs + 100L, TimeUnit.MILLISECONDS)) {
                LOG.debug("Shutting down of thread pool could not be completed. It will retry cancelling the tasks using shutdownNow.");
                executorService.shutdownNow();
                if (!executorService.awaitTermination(recordFetchTimeoutMs + 100L, TimeUnit.MILLISECONDS)) {
                    LOG.debug("Shutting down of thread pool could not be completed even after retrying cancellation of the tasks using shutdownNow.");
                }
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Encountered InterruptedException while shutting down thread pool. It will retry cancelling the tasks using shutdownNow.");
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
        for (Future future : futures) {
            future.get();
        }
        if (options.showShareConsumerStats()) {
            long endMs = System.currentTimeMillis();
            for (int index = 0; index < shareConsumersConsumptionDetails.size(); ++index) {
                double elapsedSec = (double)(endMs - startMs) / 1000.0;
                long fetchTimeInMs = endMs - startMs;
                long recordsReadByConsumer = ((ShareConsumerConsumption)shareConsumersConsumptionDetails.get(index)).recordsConsumed();
                long bytesReadByConsumer = ((ShareConsumerConsumption)shareConsumersConsumptionDetails.get(index)).bytesConsumed();
                ShareConsumerPerformance.printStatsForShareConsumer(clientIds.get(index), bytesReadByConsumer, recordsReadByConsumer, elapsedSec, fetchTimeInMs, startMs, endMs, options.dateFormat(), index + 1);
            }
        }
        if (recordsRead.get() < numRecords) {
            System.out.printf("WARNING: Exiting before consuming the expected number of records: timeout (%d ms) exceeded. You can use the --timeout option to increase the timeout.%n", recordFetchTimeoutMs);
        }
        totalRecordsRead.set(recordsRead.get());
        totalBytesRead.set(bytesRead.get());
    }

    private static void consumeRecordsForSingleShareConsumer(ShareConsumer<byte[], byte[]> shareConsumer, AtomicLong totalRecordsRead, AtomicLong totalBytesRead, ShareConsumerPerfOptions options, ShareConsumerConsumption shareConsumerConsumption, int index) throws InterruptedException {
        long currentTimeMs;
        SimpleDateFormat dateFormat = options.dateFormat();
        long lastConsumedTimeMs = currentTimeMs = System.currentTimeMillis();
        long lastReportTimeMs = currentTimeMs;
        long lastBytesRead = 0L;
        long lastRecordsRead = 0L;
        long recordsReadByConsumer = 0L;
        long bytesReadByConsumer = 0L;
        while (totalRecordsRead.get() < options.numRecords() && currentTimeMs - lastConsumedTimeMs <= options.recordFetchTimeoutMs()) {
            ConsumerRecords records = shareConsumer.poll(Duration.ofMillis(100L));
            currentTimeMs = System.currentTimeMillis();
            if (!records.isEmpty()) {
                lastConsumedTimeMs = currentTimeMs;
            }
            for (ConsumerRecord record : records) {
                ++recordsReadByConsumer;
                totalRecordsRead.addAndGet(1L);
                if (record.key() != null) {
                    bytesReadByConsumer += (long)((byte[])record.key()).length;
                    totalBytesRead.addAndGet(((byte[])record.key()).length);
                }
                if (record.value() != null) {
                    bytesReadByConsumer += (long)((byte[])record.value()).length;
                    totalBytesRead.addAndGet(((byte[])record.value()).length);
                }
                if (currentTimeMs - lastReportTimeMs >= options.reportingIntervalMs()) {
                    if (options.showDetailedStats()) {
                        ShareConsumerPerformance.printShareConsumerProgress(bytesReadByConsumer, lastBytesRead, recordsReadByConsumer, lastRecordsRead, lastReportTimeMs, currentTimeMs, dateFormat, index);
                    }
                    lastReportTimeMs = currentTimeMs;
                    lastRecordsRead = recordsReadByConsumer;
                    lastBytesRead = bytesReadByConsumer;
                }
                shareConsumerConsumption.updateRecordsConsumed(recordsReadByConsumer);
                shareConsumerConsumption.updateBytesConsumed(bytesReadByConsumer);
            }
        }
    }

    protected static void printShareConsumerProgress(long bytesRead, long lastBytesRead, long recordsRead, long lastRecordsRead, long startMs, long endMs, SimpleDateFormat dateFormat, int index) {
        double elapsedMs = endMs - startMs;
        double totalMbRead = (double)bytesRead * 1.0 / 1048576.0;
        double intervalMbRead = (double)(bytesRead - lastBytesRead) * 1.0 / 1048576.0;
        double intervalMbPerSec = 1000.0 * intervalMbRead / elapsedMs;
        double intervalRecordsPerSec = (double)(recordsRead - lastRecordsRead) / elapsedMs * 1000.0;
        long fetchTimeMs = endMs - startMs;
        System.out.printf("%s, %s, %.4f, %.4f, %.4f, %d, %d for share consumer %d", dateFormat.format(startMs), dateFormat.format(endMs), totalMbRead, intervalMbPerSec, intervalRecordsPerSec, recordsRead, fetchTimeMs, index);
        System.out.println();
    }

    private static void printStatsForShareConsumer(String clientId, long bytesRead, long recordsRead, double elapsedSec, long fetchTimeInMs, long startMs, long endMs, SimpleDateFormat dateFormat, int index) {
        double totalMbRead = (double)bytesRead * 1.0 / 1048576.0;
        System.out.printf("Share consumer %s having client id %s consumption metrics- %s, %s, %.4f, %.4f, %.4f, %d, %d%n", index, clientId, dateFormat.format(startMs), dateFormat.format(endMs), totalMbRead, totalMbRead / elapsedSec, (double)recordsRead / elapsedSec, recordsRead, fetchTimeInMs);
    }

    private static void printStatsForShareGroup(long bytesRead, long recordsRead, double elapsedSec, long fetchTimeInMs, long startMs, long endMs, SimpleDateFormat dateFormat) {
        double totalMbRead = (double)bytesRead * 1.0 / 1048576.0;
        System.out.printf("%s, %s, %.4f, %.4f, %.4f, %d, %d%n", dateFormat.format(startMs), dateFormat.format(endMs), totalMbRead, totalMbRead / elapsedSec, (double)recordsRead / elapsedSec, recordsRead, fetchTimeInMs);
    }

    protected static class ShareConsumerPerfOptions
    extends CommandDefaultOptions {
        private final OptionSpec<String> bootstrapServerOpt;
        private final OptionSpec<String> topicOpt;
        private final OptionSpec<String> groupIdOpt;
        private final OptionSpec<Integer> fetchSizeOpt;
        private final OptionSpec<String> commandPropertiesOpt;
        private final OptionSpec<Integer> socketBufferSizeOpt;
        @Deprecated(since="4.2", forRemoval=true)
        private final OptionSpec<String> consumerConfigOpt;
        private final OptionSpec<String> commandConfigOpt;
        private final OptionSpec<Void> printMetricsOpt;
        private final OptionSpec<Void> showDetailedStatsOpt;
        private final OptionSpec<Long> recordFetchTimeoutOpt;
        @Deprecated(since="4.2", forRemoval=true)
        private final OptionSpec<Long> numMessagesOpt;
        private final OptionSpec<Long> numRecordsOpt;
        private final OptionSpec<Long> reportingIntervalOpt;
        private final OptionSpec<String> dateFormatOpt;
        private final OptionSpec<Void> hideHeaderOpt;
        private final OptionSpec<Integer> numThreadsOpt;
        private final OptionSpec<Void> showShareConsumerStatsOpt;

        public ShareConsumerPerfOptions(String[] args) {
            super(args);
            this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", "REQUIRED. The server(s) to connect to.").withRequiredArg().describedAs("server to connect to").ofType(String.class);
            this.topicOpt = this.parser.accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
            this.groupIdOpt = this.parser.accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)"perf-share-consumer", (Object[])new String[0]).ofType(String.class);
            this.fetchSizeOpt = this.parser.accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)0x100000, (Object[])new Integer[0]);
            this.commandPropertiesOpt = this.parser.accepts("command-property", "Kafka share consumer related configuration properties like client.id. These configs take precedence over those passed via --command-config or --consumer.config.").withRequiredArg().describedAs("prop1=val1").ofType(String.class);
            this.socketBufferSizeOpt = this.parser.accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)0x200000, (Object[])new Integer[0]);
            this.consumerConfigOpt = this.parser.accepts("consumer.config", "(DEPRECATED) Share consumer config properties file. This option will be removed in a future version. Use --command-config instead.").withRequiredArg().describedAs("config file").ofType(String.class);
            this.commandConfigOpt = this.parser.accepts("command-config", "Config properties file.").withRequiredArg().describedAs("config file").ofType(String.class);
            this.printMetricsOpt = this.parser.accepts("print-metrics", "Print out the metrics.");
            this.showDetailedStatsOpt = this.parser.accepts("show-detailed-stats", "If set, stats are reported for each reporting interval as configured by reporting-interval.");
            this.recordFetchTimeoutOpt = this.parser.accepts("timeout", "The maximum allowed time in milliseconds between returned records.").withOptionalArg().describedAs("milliseconds").ofType(Long.class).defaultsTo((Object)10000L, (Object[])new Long[0]);
            this.numMessagesOpt = this.parser.accepts("messages", "(DEPRECATED) The number of records to consume. This option will be removed in a future version. Use --num-records instead.").withRequiredArg().describedAs("count").ofType(Long.class);
            this.numRecordsOpt = this.parser.accepts("num-records", "REQUIRED: The number of records to consume.").withRequiredArg().describedAs("count").ofType(Long.class);
            this.reportingIntervalOpt = this.parser.accepts("reporting-interval", "Interval in milliseconds at which to print progress info.").withRequiredArg().withValuesConvertedBy(RegexMatcher.regex((String)"^\\d+$")).describedAs("interval_ms").ofType(Long.class).defaultsTo((Object)5000L, (Object[])new Long[0]);
            this.dateFormatOpt = this.parser.accepts("date-format", "The date format to use for formatting the time field. See java.text.SimpleDateFormat for options.").withRequiredArg().describedAs("date format").ofType(String.class).defaultsTo((Object)"yyyy-MM-dd HH:mm:ss:SSS", (Object[])new String[0]);
            this.hideHeaderOpt = this.parser.accepts("hide-header", "If set, skips printing the header for the stats.");
            this.numThreadsOpt = this.parser.accepts("threads", "The number of share consumers to use for sharing the load.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]);
            this.showShareConsumerStatsOpt = this.parser.accepts("show-consumer-stats", "If set, stats are reported for each share consumer depending on the no. of threads.");
            try {
                this.options = this.parser.parse(args);
            }
            catch (OptionException e) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)e.getMessage());
                return;
            }
            if (this.options != null) {
                CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool is used to verify the share consumer performance.");
                CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.topicOpt, this.bootstrapServerOpt});
                CommandLineUtils.checkOneOfArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.numMessagesOpt, this.numRecordsOpt});
                CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.consumerConfigOpt, (OptionSpec[])new OptionSpec[]{this.commandConfigOpt});
                if (this.options.has(this.numMessagesOpt)) {
                    System.out.println("Warning: --messages is deprecated. Use --num-records instead.");
                }
                if (this.options.has(this.consumerConfigOpt)) {
                    System.out.println("Warning: --consumer.config is deprecated. Use --command-config instead.");
                }
            }
        }

        public boolean printMetrics() {
            return this.options.has(this.printMetricsOpt);
        }

        public String brokerHostsAndPorts() {
            return (String)this.options.valueOf(this.bootstrapServerOpt);
        }

        private Properties readProps(List<String> commandProperties, String commandConfigFile) throws IOException {
            Properties props = commandConfigFile != null ? Utils.loadProps((String)commandConfigFile) : new Properties();
            props.putAll((Map<?, ?>)CommandLineUtils.parseKeyValueArgs(commandProperties));
            return props;
        }

        public Properties props() throws IOException {
            List commandProperties = this.options.valuesOf(this.commandPropertiesOpt);
            String commandConfigFile = this.options.has(this.consumerConfigOpt) ? (String)this.options.valueOf(this.consumerConfigOpt) : (String)this.options.valueOf(this.commandConfigOpt);
            Properties props = this.readProps(commandProperties, commandConfigFile);
            props.put("bootstrap.servers", this.brokerHostsAndPorts());
            props.put("group.id", this.options.valueOf(this.groupIdOpt));
            props.put("receive.buffer.bytes", ((Integer)this.options.valueOf(this.socketBufferSizeOpt)).toString());
            props.put("fetch.max.bytes", ((Integer)this.options.valueOf(this.fetchSizeOpt)).toString());
            props.put("key.deserializer", ByteArrayDeserializer.class);
            props.put("value.deserializer", ByteArrayDeserializer.class);
            props.put("check.crcs", "false");
            if (props.getProperty("client.id") == null) {
                props.put("client.id", "perf-share-consumer-client");
            }
            return props;
        }

        public Set<String> topic() {
            return Set.of((String)this.options.valueOf(this.topicOpt));
        }

        public long numRecords() {
            return this.options.has(this.numMessagesOpt) ? ((Long)this.options.valueOf(this.numMessagesOpt)).longValue() : ((Long)this.options.valueOf(this.numRecordsOpt)).longValue();
        }

        public int threads() {
            return (Integer)this.options.valueOf(this.numThreadsOpt);
        }

        public boolean showShareConsumerStats() {
            return this.options.has(this.showShareConsumerStatsOpt);
        }

        public long reportingIntervalMs() {
            long value = (Long)this.options.valueOf(this.reportingIntervalOpt);
            if (value <= 0L) {
                throw new IllegalArgumentException("Reporting interval must be greater than 0.");
            }
            return value;
        }

        public boolean showDetailedStats() {
            return this.options.has(this.showDetailedStatsOpt);
        }

        public SimpleDateFormat dateFormat() {
            return new SimpleDateFormat((String)this.options.valueOf(this.dateFormatOpt));
        }

        public boolean hideHeader() {
            return this.options.has(this.hideHeaderOpt);
        }

        public long recordFetchTimeoutMs() {
            return (Long)this.options.valueOf(this.recordFetchTimeoutOpt);
        }
    }

    private static class ShareConsumerConsumption {
        private long recordsConsumed;
        private long bytesConsumed;

        public ShareConsumerConsumption(long recordsConsumed, long bytesConsumed) {
            this.recordsConsumed = recordsConsumed;
            this.bytesConsumed = bytesConsumed;
        }

        public long recordsConsumed() {
            return this.recordsConsumed;
        }

        public long bytesConsumed() {
            return this.bytesConsumed;
        }

        public void updateRecordsConsumed(long recordsConsumed) {
            this.recordsConsumed = recordsConsumed;
        }

        public void updateBytesConsumed(long bytesConsumed) {
            this.bytesConsumed = bytesConsumed;
        }
    }
}

