/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jms;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.jms.ConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import org.ops4j.pax.transx.connection.ExceptionSorter;
import org.ops4j.pax.transx.connection.NoExceptionsAreFatalSorter;
import org.ops4j.pax.transx.connector.ConnectionManagerBuilder;
import org.ops4j.pax.transx.jms.impl.ManagedConnectionFactoryImpl;
import org.ops4j.pax.transx.tm.TransactionManager;

public class ManagedConnectionFactoryBuilder {
    private ConnectionManagerBuilder builder = ConnectionManagerBuilder.builder();
    private ConnectionFactory connectionFactory;
    private XAConnectionFactory xaConnectionFactory;
    private ExceptionSorter exceptionSorter;
    private String userName;
    private String password;
    private String clientID;
    private ManagedConnectionFactory managedConnectionFactory;

    private ManagedConnectionFactoryBuilder() {
    }

    public static ManagedConnectionFactoryBuilder builder() {
        return new ManagedConnectionFactoryBuilder();
    }

    public ManagedConnectionFactoryBuilder name(String name) {
        this.builder.name(name);
        return this;
    }

    public ManagedConnectionFactoryBuilder connectionFactory(ConnectionFactory connectionFactory, XAConnectionFactory xaConnectionFactory) {
        this.connectionFactory = connectionFactory;
        this.xaConnectionFactory = xaConnectionFactory;
        return this;
    }

    public ManagedConnectionFactoryBuilder userName(String userName) {
        this.userName = userName;
        return this;
    }

    public ManagedConnectionFactoryBuilder password(String password) {
        this.password = password;
        return this;
    }

    public ManagedConnectionFactoryBuilder clientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public ManagedConnectionFactoryBuilder exceptionSorter(ExceptionSorter exceptionSorter) {
        this.exceptionSorter = exceptionSorter;
        return this;
    }

    public ManagedConnectionFactoryBuilder transaction(TransactionSupport.TransactionSupportLevel tx) {
        this.builder.transaction(tx);
        return this;
    }

    public ManagedConnectionFactoryBuilder transactionManager(TransactionManager transactionManager) {
        this.builder.transactionManager(transactionManager);
        return this;
    }

    public ManagedConnectionFactoryBuilder minIdle(int minSize) {
        this.builder.minIdle(minSize);
        return this;
    }

    public ManagedConnectionFactoryBuilder maxPoolSize(int maxPoolSize) {
        this.builder.maxPoolSize(maxPoolSize);
        return this;
    }

    public ManagedConnectionFactoryBuilder aliveBypassWindow(long aliveBypassWindowMs) {
        this.builder.aliveBypassWindow(aliveBypassWindowMs);
        return this;
    }

    public ManagedConnectionFactoryBuilder aliveBypassWindow(long aliveBypassWindow, TimeUnit unit) {
        this.builder.aliveBypassWindow(unit.toMillis(aliveBypassWindow));
        return this;
    }

    public ManagedConnectionFactoryBuilder houseKeepingPeriod(long houseKeepingPeriodMs) {
        this.builder.houseKeepingPeriod(houseKeepingPeriodMs);
        return this;
    }

    public ManagedConnectionFactoryBuilder houseKeepingPeriod(long houseKeepingPeriod, TimeUnit unit) {
        this.builder.houseKeepingPeriod(unit.toMillis(houseKeepingPeriod));
        return this;
    }

    public ManagedConnectionFactoryBuilder connectionTimeout(long connectionTimeoutMs) {
        this.builder.connectionTimeout(connectionTimeoutMs);
        return this;
    }

    public ManagedConnectionFactoryBuilder connectionTimeout(long connectionTimeout, TimeUnit unit) {
        this.builder.connectionTimeout(unit.toMillis(connectionTimeout));
        return this;
    }

    public ManagedConnectionFactoryBuilder idleTimeout(long idleTimeoutMs) {
        this.builder.idleTimeout(idleTimeoutMs);
        return this;
    }

    public ManagedConnectionFactoryBuilder idleTimeout(long idleTimeout, TimeUnit unit) {
        this.builder.idleTimeout(unit.toMillis(idleTimeout));
        return this;
    }

    public ManagedConnectionFactoryBuilder maxLifetime(long maxLifetimeMs) {
        this.builder.maxLifetime(maxLifetimeMs);
        return this;
    }

    public ManagedConnectionFactoryBuilder maxLifetime(long maxLifetime, TimeUnit unit) {
        this.builder.maxLifetime(unit.toMillis(maxLifetime));
        return this;
    }

    public ManagedConnectionFactoryBuilder properties(Properties properties) {
        this.configure(properties::get);
        return this;
    }

    public ManagedConnectionFactoryBuilder properties(Map<String, Object> properties) {
        this.configure(properties::get);
        return this;
    }

    private void configure(Function<String, Object> property) {
        Object maxLifetime;
        Object idleTimeout;
        Object connectionTimeout;
        Object houseKeepingPeriod;
        Object aliveBypassWindow;
        Object maxPoolSize;
        Object minIdle;
        Object clientID;
        Object password;
        Object userName;
        Object name = property.apply("name");
        if (name != null) {
            this.name(name.toString());
        }
        if ((userName = property.apply("userName")) != null) {
            this.userName(userName.toString());
        }
        if ((password = property.apply("password")) != null) {
            this.password(password.toString());
        }
        if ((clientID = property.apply("clientID")) != null) {
            this.clientID(clientID.toString());
        }
        if ((minIdle = property.apply("minIdle")) != null) {
            this.minIdle(this.toInt(minIdle, "minIdle"));
        }
        if ((maxPoolSize = property.apply("maxPoolSize")) != null) {
            this.maxPoolSize(this.toInt(maxPoolSize, "maxPoolSize"));
        }
        if ((aliveBypassWindow = property.apply("aliveBypassWindow")) != null) {
            this.aliveBypassWindow(this.toInt(aliveBypassWindow, "aliveBypassWindow"));
        }
        if ((houseKeepingPeriod = property.apply("houseKeepingPeriod")) != null) {
            this.houseKeepingPeriod(this.toInt(houseKeepingPeriod, "houseKeepingPeriod"));
        }
        if ((connectionTimeout = property.apply("connectionTimeout")) != null) {
            this.connectionTimeout(this.toInt(connectionTimeout, "connectionTimeout"));
        }
        if ((idleTimeout = property.apply("idleTimeout")) != null) {
            this.idleTimeout(this.toInt(idleTimeout, "idleTimeout"));
        }
        if ((maxLifetime = property.apply("maxLifetime")) != null) {
            this.maxLifetime(this.toInt(maxLifetime, "maxLifetime"));
        }
    }

    private int toInt(Object v, String property) {
        try {
            return Integer.parseInt(v.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Can't parse property \"" + property + "\" as int");
        }
    }

    public ConnectionFactory build() throws Exception {
        if (this.connectionFactory == null && this.xaConnectionFactory == null) {
            throw new NullPointerException("connectionFactory must be set");
        }
        if (this.managedConnectionFactory == null) {
            ExceptionSorter es = this.exceptionSorter != null ? this.exceptionSorter : new NoExceptionsAreFatalSorter();
            ManagedConnectionFactoryImpl mcf = new ManagedConnectionFactoryImpl(this.connectionFactory, this.xaConnectionFactory, es);
            mcf.setUserName(this.userName);
            mcf.setPassword(this.password);
            mcf.setClientID(this.clientID);
            this.managedConnectionFactory = mcf;
        }
        this.builder.managedConnectionFactory(this.managedConnectionFactory);
        ConnectionManager cm = this.builder.build();
        return (ConnectionFactory)this.managedConnectionFactory.createConnectionFactory(cm);
    }
}

