/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.result;

import aQute.bnd.exceptions.ConsumerWithException;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.exceptions.FunctionWithException;
import aQute.bnd.exceptions.SupplierWithException;
import aQute.bnd.result.Result;
import aQute.bnd.result.ResultException;
import java.util.Objects;
import java.util.Optional;

final class Ok<V>
implements Result<V> {
    private final V value;

    Ok(V value) {
        this.value = value;
    }

    @Override
    public boolean isOk() {
        return true;
    }

    @Override
    public boolean isErr() {
        return false;
    }

    @Override
    public Optional<V> value() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public Optional<String> error() {
        return Optional.empty();
    }

    @Override
    public V unwrap() {
        return this.value;
    }

    @Override
    public V unwrap(CharSequence message) throws ResultException {
        Objects.requireNonNull(message);
        return this.value;
    }

    @Override
    public V orElse(V orElse) {
        return this.value;
    }

    @Override
    public V orElseGet(SupplierWithException<? extends V> orElseSupplier) {
        Objects.requireNonNull(orElseSupplier);
        return this.value;
    }

    @Override
    public <R extends Throwable> V orElseThrow(FunctionWithException<? super String, ? extends R> throwableSupplier) throws R {
        Objects.requireNonNull(throwableSupplier);
        return this.value;
    }

    @Override
    public <U> Result<U> map(FunctionWithException<? super V, ? extends U> mapper) {
        try {
            return Result.ok(mapper.apply(this.value));
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    @Override
    public Result<V> mapErr(FunctionWithException<? super String, ? extends CharSequence> mapper) {
        Objects.requireNonNull(mapper);
        return this;
    }

    @Override
    public <U> Result<U> flatMap(FunctionWithException<? super V, ? extends Result<? extends U>> mapper) {
        try {
            Result<? extends U> result = Objects.requireNonNull(mapper.apply(this.value));
            return result;
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    @Override
    public Result<V> recover(FunctionWithException<? super String, ? extends V> recover) {
        Objects.requireNonNull(recover);
        return this;
    }

    @Override
    public Result<V> recoverWith(FunctionWithException<? super String, ? extends Result<? extends V>> recover) {
        Objects.requireNonNull(recover);
        return this;
    }

    @Override
    public void accept(ConsumerWithException<? super V> ok, ConsumerWithException<? super String> err) {
        Objects.requireNonNull(err);
        try {
            ok.accept(this.value);
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    @Override
    public <U> Result<U> asError() {
        throw new ResultException("Not an Err value");
    }

    public String toString() {
        return String.format("Ok(%s)", this.value);
    }
}

