/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="shell", name="java", description="Executes a Java standard application.")
@Service
public class JavaAction
implements Action {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-m", aliases={"--method"}, description="Invoke a named method", required=false, multiValued=false)
    private String methodName = "main";
    @Argument(index=0, name="className", description="The name of the class to invoke", required=true, multiValued=false)
    private String className;
    @Argument(index=1, name="arguments", description="Arguments to pass to the method of the given class", required=false, multiValued=false)
    private List<String> args;

    public Object execute() throws Exception {
        boolean info = this.log.isInfoEnabled();
        Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(this.className);
        if (info) {
            this.log.info("Using type: " + String.valueOf(type));
        }
        Method method = type.getMethod(this.methodName, String[].class);
        if (info) {
            this.log.info("Using method: " + String.valueOf(method));
        }
        if (info) {
            this.log.info("Invoking w/arguments: {}", this.args);
        }
        Object result = method.invoke(null, this.args);
        if (info) {
            this.log.info("Result: " + String.valueOf(result));
        }
        return null;
    }
}

