/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class PatternHelper {
    private PatternHelper() {
    }

    public static boolean matchPattern(String name, String pattern) {
        if (name == null || pattern == null) {
            return false;
        }
        if (name.equalsIgnoreCase(pattern)) {
            return true;
        }
        if (PatternHelper.matchWildcard(name, pattern)) {
            return true;
        }
        return PatternHelper.matchRegex(name, pattern);
    }

    private static boolean matchWildcard(String name, String pattern) {
        if (pattern.endsWith("*")) {
            String text = pattern.substring(0, pattern.length() - 1);
            return name.toLowerCase(Locale.ENGLISH).startsWith(text.toLowerCase(Locale.ENGLISH));
        }
        return false;
    }

    private static boolean matchRegex(String name, String pattern) {
        try {
            Pattern compiled = Pattern.compile(pattern, 2);
            Matcher matcher = compiled.matcher(name);
            return matcher.matches();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public static boolean isExcludePatternMatch(String key, String ... excludePatterns) {
        for (String pattern : excludePatterns) {
            if (!PatternHelper.matchPattern(key, pattern)) continue;
            return true;
        }
        return false;
    }
}

