/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.ssh.KarafJaasAuthenticator;
import org.apache.karaf.shell.ssh.SshTerminal;
import org.apache.karaf.shell.support.ShellUtil;
import org.apache.karaf.util.jaas.JaasHelper;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.shell.ShellFactory;

public class ShellFactoryImpl
implements ShellFactory {
    private SessionFactory sessionFactory;

    public ShellFactoryImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Command createShell(ChannelSession channelSession) {
        return new ShellImpl();
    }

    public static String getEncoding(Environment env) {
        String ctype = env.getEnv().getOrDefault("LC_TYPE", System.getenv("LC_CTYPE"));
        String envEncoding = ShellFactoryImpl.extractEncodingFromCtype(ctype);
        if (envEncoding != null) {
            return envEncoding;
        }
        return System.getProperty("input.encoding", Charset.defaultCharset().name());
    }

    static String extractEncodingFromCtype(String ctype) {
        if (ctype != null && ctype.indexOf(46) > 0) {
            String encodingAndModifier = ctype.substring(ctype.indexOf(46) + 1);
            if (encodingAndModifier.indexOf(64) > 0) {
                return encodingAndModifier.substring(0, encodingAndModifier.indexOf(64));
            }
            return encodingAndModifier;
        }
        return null;
    }

    public class ShellImpl
    implements Command {
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback callback;
        private ServerSession session;
        private Session shell;
        private SshTerminal terminal;
        private boolean closed;

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        public void start(ChannelSession channelSession, Environment environment) throws IOException {
            this.session = channelSession.getServerSession();
            try {
                Subject subject = (Subject)this.session.getAttribute(KarafJaasAuthenticator.SUBJECT_ATTRIBUTE_KEY);
                String encoding = ShellFactoryImpl.getEncoding(environment);
                this.terminal = new SshTerminal(environment, this.in, this.out, encoding);
                PrintStream pout = new PrintStream(this.terminal.output(), true, encoding);
                PrintStream perr = this.err instanceof PrintStream ? (PrintStream)this.err : (this.out == this.err ? pout : new PrintStream(this.err, true, encoding));
                this.shell = ShellFactoryImpl.this.sessionFactory.create(this.in, pout, perr, (Terminal)this.terminal, encoding, this::destroy);
                for (Map.Entry e : environment.getEnv().entrySet()) {
                    this.shell.put((String)e.getKey(), e.getValue());
                }
                this.shell.put(Subject.class.getName(), (Object)subject);
                JaasHelper.runAs(subject, () -> new Thread((Runnable)this.shell, "Karaf ssh console user " + ShellUtil.getCurrentUserName()).start());
            }
            catch (Exception e) {
                throw new IOException("Unable to start shell", e);
            }
        }

        public void destroy() {
            if (!this.closed) {
                this.closed = true;
                this.callback.onExit(0);
                this.session.close(true);
            }
        }

        public void destroy(ChannelSession channelSession) {
            this.destroy();
        }
    }
}

