/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.config.impl;

import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.util.collections.CopyOnWriteArrayIdentityList;
import org.slf4j.LoggerFactory;

public class OsgiConfiguration
extends Configuration {
    private final List<JaasRealm> realms = new CopyOnWriteArrayIdentityList<JaasRealm>();
    private Configuration defaultConfiguration;

    public void init() {
        try {
            this.defaultConfiguration = Configuration.getConfiguration();
        }
        catch (Throwable ex) {
            LoggerFactory.getLogger(OsgiConfiguration.class).warn("Unable to retrieve default configuration", ex);
        }
        Configuration.setConfiguration(this);
    }

    public void close() {
        this.realms.clear();
        Configuration.setConfiguration(this.defaultConfiguration);
    }

    public void register(JaasRealm realm, Map<String, ?> properties) {
        if (realm != null) {
            this.realms.add(realm);
        }
    }

    public void unregister(JaasRealm realm, Map<String, ?> properties) {
        if (realm != null) {
            this.realms.remove(realm);
        }
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        JaasRealm realm = null;
        for (JaasRealm r : this.realms) {
            if (!r.getName().equals(name) || realm != null && r.getRank() <= realm.getRank()) continue;
            realm = r;
        }
        if (realm != null) {
            return realm.getEntries();
        }
        if (this.defaultConfiguration != null) {
            return this.defaultConfiguration.getAppConfigurationEntry(name);
        }
        return null;
    }

    @Override
    public void refresh() {
        if (this.defaultConfiguration != null) {
            this.defaultConfiguration.refresh();
        }
    }
}

