/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.filter;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.guava30.shaded.common.cache.Cache;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetPageFilterCollector {
    public static final Logger LOGGER = LoggerFactory.getLogger(ParquetPageFilterCollector.class);
    public static final Cache<String, AtomicLong> queryTotalParquetPages = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static final Cache<String, AtomicLong> queryFilteredParquetPages = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static final Cache<String, AtomicLong> queryAfterFilterParquetPages = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private static final AutoReadWriteLock LOCK = new AutoReadWriteLock(new ReentrantReadWriteLock());

    private ParquetPageFilterCollector() {
    }

    public static void addQueryMetrics(String queryId, long totalPages, long filteredPages, long afterFilterPages) {
        long start = System.currentTimeMillis();
        try (AutoReadWriteLock.AutoLock writeLock = LOCK.lockForWrite();){
            ParquetPageFilterCollector.addQueryCounter(queryId, queryTotalParquetPages, totalPages);
            ParquetPageFilterCollector.addQueryCounter(queryId, queryFilteredParquetPages, filteredPages);
            ParquetPageFilterCollector.addQueryCounter(queryId, queryAfterFilterParquetPages, afterFilterPages);
        }
        catch (Exception e) {
            LOGGER.error("Error when add query metrics.", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        if (end - start > 100L) {
            LOGGER.warn("Parquet page filter collector cost too much time: {} ms ", (Object)(end - start));
        }
    }

    private static void addQueryCounter(String queryId, Cache<String, AtomicLong> counter, long step) throws ExecutionException {
        AtomicLong pageCnt = (AtomicLong)counter.get((Object)queryId, () -> new AtomicLong(0L));
        pageCnt.addAndGet(step);
    }

    public static void logParquetPages(String queryId) {
        try {
            AtomicLong totalPages = (AtomicLong)queryTotalParquetPages.getIfPresent((Object)queryId);
            if (totalPages != null && totalPages.get() > 0L) {
                AtomicLong filteredPages = (AtomicLong)queryFilteredParquetPages.get((Object)queryId, () -> new AtomicLong(0L));
                AtomicLong afterFilteredPages = (AtomicLong)queryAfterFilterParquetPages.get((Object)queryId, () -> new AtomicLong(0L));
                LOGGER.info("Query total parquet pages {}, filtered pages {}, after filter pages {}, filter rate {}", new Object[]{totalPages.get(), filteredPages.get(), afterFilteredPages.get(), (double)filteredPages.get() / (double)totalPages.get()});
            }
            queryTotalParquetPages.invalidate((Object)queryId);
            queryFilteredParquetPages.invalidate((Object)queryId);
            queryAfterFilterParquetPages.invalidate((Object)queryId);
        }
        catch (ExecutionException e) {
            LOGGER.error("Error when log query metrics.", (Throwable)e);
        }
    }
}

