/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.commands.ConvertTargetFile;
import org.apache.spark.sql.delta.commands.ConvertTargetFileManifest;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.PartitionUtils$;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=4AAC\u0006\u00011!A!\u0003\u0001B\u0001B\u0003%Q\u0005\u0003\u0005*\u0001\t\u0015\r\u0011\"\u0011+\u0011!A\u0004A!A!\u0002\u0013Y\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011\t\u0003!\u0011!Q\u0001\n\rCQ!\u0013\u0001\u0005\u0002)C\u0001\u0002\u0015\u0001\t\u0006\u0004%I!\u0015\u0005\tE\u0002A)\u0019!C!G\")!\u000e\u0001C!W\n\u00192)\u0019;bY><g)\u001b7f\u001b\u0006t\u0017NZ3ti*\u0011A\"D\u0001\tG>lW.\u00198eg*\u0011abD\u0001\u0006I\u0016dG/\u0019\u0006\u0003!E\t1a]9m\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\n\u0004\u0001e\t\u0003C\u0001\u000e \u001b\u0005Y\"B\u0001\u000f\u001e\u0003\u0011a\u0017M\\4\u000b\u0003y\tAA[1wC&\u0011\u0001e\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\t\u001aS\"A\u0006\n\u0005\u0011Z!!G\"p]Z,'\u000f\u001e+be\u001e,GOR5mK6\u000bg.\u001b4fgR\u0004\"AJ\u0014\u000e\u0003=I!\u0001K\b\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0011\t\f7/\u001a)bi\",\u0012a\u000b\t\u0003YUr!!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0005A:\u0012A\u0002\u001fs_>$hHC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014'\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b2\u0003%\u0011\u0017m]3QCRD\u0007%\u0001\u0007dCR\fGn\\4UC\ndW\r\u0005\u0002<\u00016\tAH\u0003\u0002>}\u000591-\u0019;bY><'BA \u0010\u0003!\u0019\u0017\r^1msN$\u0018BA!=\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0003A\u0019XM]5bY&T\u0018M\u00197f\u0007>tg\r\u0005\u0002E\u000f6\tQI\u0003\u0002G#\u0005!Q\u000f^5m\u0013\tAUIA\rTKJL\u0017\r\\5{C\ndWmQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\bF\u0003L\u00196su\n\u0005\u0002#\u0001!)!C\u0002a\u0001K!)\u0011F\u0002a\u0001W!)\u0011H\u0002a\u0001u!)!I\u0002a\u0001\u0007\u0006i\u0001/\u0019:uSRLwN\u001c'jgR,\u0012A\u0015\t\u0004'ZCV\"\u0001+\u000b\u0005U\u000b\u0014AC2pY2,7\r^5p]&\u0011q\u000b\u0016\u0002\u0004'\u0016\f\b\u0003B-[Wqk\u0011!M\u0005\u00037F\u0012a\u0001V;qY\u0016\u0014\u0004\u0003B/aW-j\u0011A\u0018\u0006\u0003?R\u000b\u0011\"[7nkR\f'\r\\3\n\u0005\u0005t&aA'ba\u0006A\u0011\r\u001c7GS2,7/F\u0001e!\r1SmZ\u0005\u0003M>\u0011q\u0001R1uCN,G\u000f\u0005\u0002#Q&\u0011\u0011n\u0003\u0002\u0012\u0007>tg/\u001a:u)\u0006\u0014x-\u001a;GS2,\u0017!B2m_N,G#\u00017\u0011\u0005ek\u0017B\u000182\u0005\u0011)f.\u001b;")
public class CatalogFileManifest
implements ConvertTargetFileManifest {
    private Seq<Tuple2<String, Map<String, String>>> partitionList;
    private Dataset<ConvertTargetFile> allFiles;
    private final SparkSession spark;
    private final String basePath;
    private final CatalogTable catalogTable;
    private final SerializableConfiguration serializableConf;
    private volatile byte bitmap$0;

    @Override
    public Iterator<ConvertTargetFile> getFiles() {
        return ConvertTargetFileManifest.getFiles$(this);
    }

    @Override
    public String basePath() {
        return this.basePath;
    }

    private Seq<Tuple2<String, Map<String, String>>> partitionList$lzycompute() {
        CatalogFileManifest catalogFileManifest = this;
        synchronized (catalogFileManifest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Seq seq;
                if (this.catalogTable.partitionSchema().isEmpty()) {
                    seq = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.basePath()), (Object)Predef$.MODULE$.Map().empty()), (List)Nil$.MODULE$);
                } else {
                    Seq partitions = this.spark.sessionState().catalog().listPartitions(this.catalogTable.identifier(), this.spark.sessionState().catalog().listPartitions$default$2());
                    seq = (Seq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> {
                        String partitionDir = (String)partition.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                            String partitionDir = PartitionUtils$.MODULE$.getPathFragment((Map<String, String>)partition.spec(), $this.catalogTable.partitionSchema());
                            return new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(this.basePath())).stripSuffix("/")).append("/").append(partitionDir).toString();
                        });
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionDir), (Object)partition.spec());
                    }, Seq$.MODULE$.canBuildFrom());
                }
                this.partitionList = seq;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.partitionList;
    }

    private Seq<Tuple2<String, Map<String, String>>> partitionList() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.partitionList$lzycompute() : this.partitionList;
    }

    private Dataset<ConvertTargetFile> allFiles$lzycompute() {
        CatalogFileManifest catalogFileManifest = this;
        synchronized (catalogFileManifest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                if (this.partitionList().isEmpty()) {
                    throw DeltaErrors$.MODULE$.convertToDeltaNoPartitionFound(this.catalogTable.identifier().unquotedString());
                }
                Broadcast conf = this.spark.sparkContext().broadcast((Object)this.serializableConf, ClassTag$.MODULE$.apply(SerializableConfiguration.class));
                int parallelism = this.spark.sessionState().conf().parallelPartitionDiscoveryParallelism();
                RDD qual$1 = this.spark.sparkContext().parallelize(this.partitionList(), this.spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                int x$1 = package$.MODULE$.min(parallelism, this.partitionList().length());
                Ordering x$2 = qual$1.repartition$default$2(x$1);
                RDD qual$2 = qual$1.repartition(x$1, x$2);
                Function1 & Serializable & scala.Serializable x$3 = (Function1 & Serializable & scala.Serializable)partitions -> partitions.flatMap((Function1 & Serializable & scala.Serializable)partition -> DeltaFileOperations$.MODULE$.localListDirs(((SerializableConfiguration)conf.value()).value(), (Seq<String>)((Seq)new .colon.colon((Object)((String)partition._1()), (List)Nil$.MODULE$)), false, DeltaFileOperations$.MODULE$.localListDirs$default$4(), DeltaFileOperations$.MODULE$.localListDirs$default$5()).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)CatalogFileManifest.$anonfun$allFiles$4(x$14))).map((Function1 & Serializable & scala.Serializable)x$15 -> new ConvertTargetFile((SerializableFileStatus)x$15, (Option<Map<String, String>>)new Some(partition._2()))));
                boolean x$4 = qual$2.mapPartitions$default$2();
                RDD rdd = qual$2.mapPartitions((Function1)x$3, x$4, ClassTag$.MODULE$.apply(ConvertTargetFile.class));
                this.allFiles = this.spark.createDataset(rdd, org.apache.spark.sql.delta.implicits.package$.MODULE$.convertTargetFileEncoder()).cache();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.allFiles;
    }

    @Override
    public Dataset<ConvertTargetFile> allFiles() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.allFiles$lzycompute() : this.allFiles;
    }

    @Override
    public void close() {
        this.allFiles().unpersist();
    }

    public static final /* synthetic */ boolean $anonfun$allFiles$4(SerializableFileStatus x$14) {
        return !x$14.isDir();
    }

    public CatalogFileManifest(SparkSession spark, String basePath, CatalogTable catalogTable, SerializableConfiguration serializableConf) {
        this.spark = spark;
        this.basePath = basePath;
        this.catalogTable = catalogTable;
        this.serializableConf = serializableConf;
        ConvertTargetFileManifest.$init$(this);
    }
}

