/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.google.common.collect;

import alluxio.shaded.client.com.google.common.annotations.GwtCompatible;
import alluxio.shaded.client.com.google.common.base.Predicate;
import alluxio.shaded.client.com.google.common.collect.ElementTypesAreNonnullByDefault;
import alluxio.shaded.client.com.google.common.collect.FilteredEntryMultimap;
import alluxio.shaded.client.com.google.common.collect.FilteredSetMultimap;
import alluxio.shaded.client.com.google.common.collect.ParametricNullness;
import alluxio.shaded.client.com.google.common.collect.SetMultimap;
import alluxio.shaded.client.com.google.common.collect.Sets;
import alluxio.shaded.client.javax.annotation.CheckForNull;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class FilteredEntrySetMultimap<K, V>
extends FilteredEntryMultimap<K, V>
implements FilteredSetMultimap<K, V> {
    FilteredEntrySetMultimap(SetMultimap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> predicate) {
        super(unfiltered, predicate);
    }

    @Override
    public SetMultimap<K, V> unfiltered() {
        return (SetMultimap)this.unfiltered;
    }

    @Override
    public Set<V> get(@ParametricNullness K key) {
        return (Set)super.get(key);
    }

    @Override
    public Set<V> removeAll(@CheckForNull Object key) {
        return (Set)super.removeAll(key);
    }

    @Override
    public Set<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        return (Set)super.replaceValues(key, values);
    }

    @Override
    Set<Map.Entry<K, V>> createEntries() {
        return Sets.filter(this.unfiltered().entries(), this.entryPredicate());
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return (Set)super.entries();
    }
}

