/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.runtime.AbstractImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

public class ConsList<E>
extends AbstractImmutableList<E> {
    private final E first;
    private final List<E> rest;

    public static <E> List<E> of(E first, List<? extends E> rest) {
        if (rest instanceof ConsList || rest instanceof ImmutableList && !rest.isEmpty()) {
            return new ConsList<E>(first, rest);
        }
        return ImmutableList.builder().add(first).addAll(rest).build();
    }

    private ConsList(E first, List<E> rest) {
        this.first = first;
        this.rest = rest;
    }

    @Override
    public E get(int index) {
        ConsList c = this;
        while (index != 0) {
            --index;
            if (!(c.rest instanceof ConsList)) {
                return c.rest.get(index);
            }
            c = (ConsList)c.rest;
        }
        return c.first;
    }

    @Override
    public int size() {
        int s = 1;
        ConsList c = this;
        while (c.rest instanceof ConsList) {
            c = (ConsList)c.rest;
            ++s;
        }
        return s + c.rest.size();
    }

    @Override
    public int hashCode() {
        return this.toList().hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof List && this.toList().equals(o);
    }

    public String toString() {
        return this.toList().toString();
    }

    @Override
    protected final List<E> toList() {
        ArrayList<E> list = new ArrayList<E>();
        ConsList c = this;
        while (true) {
            list.add(c.first);
            if (!(c.rest instanceof ConsList)) {
                list.addAll(c.rest);
                return list;
            }
            c = (ConsList)c.rest;
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.toList().listIterator();
    }

    @Override
    public Iterator<E> iterator() {
        return this.toList().iterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.toList().listIterator(index);
    }

    @Override
    public @PolyNull Object[] toArray(ConsList<@PolyNull E> this) {
        return this.toList().toArray();
    }

    @Override
    public <T> @Nullable T[] toArray(T @Nullable [] a) {
        int s = this.size();
        if (s > ((Object[])Nullness.castNonNull(a)).length) {
            a = Arrays.copyOf(a, s, a.getClass());
        } else if (s < a.length) {
            a[s] = Nullness.castNonNull(null);
        }
        int i = 0;
        ConsList c = this;
        while (true) {
            a[i++] = c.first;
            if (!(c.rest instanceof ConsList)) {
                Object[] a2 = c.rest.toArray();
                System.arraycopy(a2, 0, a, i, a2.length);
                return a;
            }
            c = (ConsList)c.rest;
        }
    }

    @Override
    public int indexOf(@Nullable Object o) {
        return this.toList().indexOf(o);
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return this.toList().lastIndexOf(o);
    }
}

