/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.cache;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import lombok.Generated;
import org.apache.kylin.common.util.CompressionUtils;
import org.apache.kylin.rest.cache.KylinCache;
import org.apache.kylin.rest.service.CommonQueryCacheSupporter;
import org.apache.kylin.rest.util.SerializeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKylinCache
implements KylinCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractKylinCache.class);

    protected boolean isExceptionQuery(String type) {
        return type.equals(CommonQueryCacheSupporter.Type.EXCEPTION_QUERY_CACHE.rootCacheName);
    }

    protected String getTypeProjectPrefix(String type, String project) {
        return String.format(Locale.ROOT, "%s-%s", type, project);
    }

    protected byte[] convertKeyToByte(String type, Object key) {
        try {
            String prefixAndType = "Kylin-" + type;
            byte[] typeBytes = this.getBytesFromString(prefixAndType);
            byte[] keyBytes = SerializeUtil.serialize((Object)key);
            byte[] trueKeyBytes = new byte[keyBytes.length + typeBytes.length];
            System.arraycopy(typeBytes, 0, trueKeyBytes, 0, typeBytes.length);
            System.arraycopy(keyBytes, 0, trueKeyBytes, typeBytes.length, keyBytes.length);
            return trueKeyBytes;
        }
        catch (Exception e) {
            log.error("serialize fail!", (Throwable)e);
            return new byte[0];
        }
    }

    protected byte[] convertValueToByte(Object value) {
        try {
            return CompressionUtils.compress((byte[])SerializeUtil.serialize((Object)value));
        }
        catch (Exception e) {
            log.error("serialize failed!", (Throwable)e);
            return new byte[0];
        }
    }

    protected byte[] getBytesFromString(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    protected Object convertByteToObject(byte[] bytes) {
        try {
            return SerializeUtil.deserialize((byte[])CompressionUtils.decompress((byte[])bytes));
        }
        catch (Exception e) {
            log.error("deserialize fail!", (Throwable)e);
            return null;
        }
    }
}

