/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.metrics.MetricsTag;
import org.apache.kylin.common.metrics.prometheus.PrometheusMetrics;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.eventbus.Subscribe;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.query.QueryMetrics;
import org.apache.kylin.rest.util.SpringContext;

public class QueryMetricsListener {
    @Subscribe
    public void recordMetric(QueryMetrics queryMetric) {
        String project = queryMetric.getProjectName();
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        HashMap tags = Maps.newHashMap();
        tags.put(MetricsTag.HOST.getVal(), queryMetric.getServer().concat("-").concat(project));
        MetricsGroup.counterInc((MetricsName)MetricsName.QUERY, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
        this.updateQueryTimeMetrics(queryMetric.getQueryDuration(), project, tags);
        this.updateQueryTypeMetrics(queryMetric, project, tags);
        MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_HOST, (MetricsCategory)MetricsCategory.HOST, (String)queryMetric.getServer());
        MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_SCAN_BYTES_HOST, (MetricsCategory)MetricsCategory.HOST, (String)queryMetric.getServer(), (long)queryMetric.getTotalScanBytes());
        MetricsGroup.histogramUpdate((MetricsName)MetricsName.QUERY_LATENCY, (MetricsCategory)MetricsCategory.PROJECT, (String)queryMetric.getProjectName(), (Map)tags, (long)queryMetric.getQueryDuration());
        MetricsGroup.histogramUpdate((MetricsName)MetricsName.QUERY_TIME_HOST, (MetricsCategory)MetricsCategory.HOST, (String)queryMetric.getServer(), (long)queryMetric.getQueryDuration());
        MetricsGroup.histogramUpdate((MetricsName)MetricsName.QUERY_SCAN_BYTES, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags, (long)queryMetric.getTotalScanBytes());
        this.recordQueryPrometheusMetric(queryMetric, modelManager, (MeterRegistry)SpringContext.getBean(MeterRegistry.class));
    }

    public void recordQueryPrometheusMetric(QueryMetrics queryMetric, NDataModelManager modelManager, MeterRegistry meterRegistry) {
        if (!KylinConfig.getInstanceFromEnv().isPrometheusMetricsEnabled()) {
            return;
        }
        Tags projectTag = Tags.of((String)MetricsTag.PROJECT.getVal(), (String)queryMetric.getProjectName());
        DistributionSummary.builder((String)PrometheusMetrics.QUERY_SECONDS.getValue()).tags(new String[]{MetricsTag.PUSH_DOWN.getVal(), queryMetric.isPushdown() + "", MetricsTag.CACHE.getVal(), queryMetric.isCacheHit() + "", MetricsTag.HIT_INDEX.getVal(), queryMetric.isIndexHit() + "", MetricsTag.HIT_EXACTLY_INDEX.getVal(), queryMetric.getQueryHistoryInfo().isExactlyMatch() + "", MetricsTag.SUCCEED.getVal(), queryMetric.isSucceed() + "", MetricsTag.HIT_SNAPSHOT.getVal(), queryMetric.isTableSnapshotUsed() + "", MetricsTag.PROJECT.getVal(), queryMetric.getProjectName(), MetricsTag.CONSTANTS.getVal(), MetricsTag.CONSTANTS.getVal().equalsIgnoreCase(queryMetric.getEngineType()) + ""}).distributionStatisticExpiry(Duration.ofDays(1L)).sla(KylinConfig.getInstanceFromEnv().getMetricsQuerySlaSeconds()).description("Query duration").register(meterRegistry).record((double)queryMetric.getQueryDuration() * 1.0 / 1000.0);
        if (queryMetric.isSucceed()) {
            DistributionSummary.builder((String)PrometheusMetrics.QUERY_RESULT_ROWS.getValue()).tags((Iterable)projectTag).description("Number of rows returned by query").distributionStatisticExpiry(Duration.ofDays(1L)).register(meterRegistry).record((double)queryMetric.getResultRowCount());
            Counter.builder((String)PrometheusMetrics.QUERY_JOBS.getValue()).tags((Iterable)projectTag).description("Number of spark job by query engine").register(meterRegistry).increment((double)queryMetric.getQueryJobCount());
            Counter.builder((String)PrometheusMetrics.QUERY_STAGES.getValue()).tags((Iterable)projectTag).description("Number of spark stage by query engine").register(meterRegistry).increment((double)queryMetric.getQueryStageCount());
            Counter.builder((String)PrometheusMetrics.QUERY_TASKS.getValue()).tags((Iterable)projectTag).description("Number of spark task by query engine").register(meterRegistry).increment((double)queryMetric.getQueryTaskCount());
        }
        if (queryMetric.isIndexHit()) {
            DistributionSummary.builder((String)PrometheusMetrics.QUERY_SCAN_BYTES.getValue()).tags(new String[]{MetricsTag.MODEL.getVal(), queryMetric.getRealizationMetrics().stream().map(e -> modelManager.getDataModelDesc(e.getModelId())).filter(Objects::nonNull).map(NDataModel::getAlias).collect(Collectors.joining(",")), MetricsTag.PROJECT.getVal(), queryMetric.getProjectName()}).distributionStatisticExpiry(Duration.ofDays(1L)).publishPercentiles(new double[]{0.8, 0.9}).register(meterRegistry).record((double)queryMetric.getTotalScanBytes());
        }
    }

    private void updateQueryTypeMetrics(QueryMetrics queryMetrics, String project, Map<String, String> tags) {
        if ("FAILED".equals(queryMetrics.getQueryStatus())) {
            MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_FAILED, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
            MetricsGroup.meterMark((MetricsName)MetricsName.QUERY_FAILED_RATE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
        }
        if (queryMetrics.isPushdown()) {
            MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_PUSH_DOWN, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
            MetricsGroup.meterMark((MetricsName)MetricsName.QUERY_PUSH_DOWN_RATE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
        }
        if ("CONSTANTS".equals(queryMetrics.getEngineType())) {
            MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_CONSTANTS, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
            MetricsGroup.meterMark((MetricsName)MetricsName.QUERY_CONSTANTS_RATE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
        }
        if (queryMetrics.isTimeout()) {
            MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_TIMEOUT, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
            MetricsGroup.meterMark((MetricsName)MetricsName.QUERY_TIMEOUT_RATE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
        }
        if (queryMetrics.isCacheHit()) {
            MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_CACHE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
        }
        if (queryMetrics.getRealizationMetrics() != null) {
            boolean hitAggIndex = queryMetrics.getRealizationMetrics().stream().anyMatch(realization -> realization != null && "Agg Index".equals(realization.getIndexType()));
            boolean hitTableIndex = queryMetrics.getRealizationMetrics().stream().anyMatch(realization -> realization != null && "Table Index".equals(realization.getIndexType()));
            if (hitAggIndex) {
                MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_AGG_INDEX, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
            }
            if (hitTableIndex) {
                MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_TABLE_INDEX, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
            }
        }
    }

    @VisibleForTesting
    public void updateQueryTimeMetrics(long duration, String project, Map<String, String> tags) {
        if (duration <= 1000L) {
            MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_LT_1S, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
        } else if (duration <= 3000L) {
            MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_1S_3S, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
        } else if (duration <= 5000L) {
            MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_3S_5S, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
        } else if (duration <= 10000L) {
            MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_5S_10S, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
        } else {
            MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_SLOW, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
            MetricsGroup.meterMark((MetricsName)MetricsName.QUERY_SLOW_RATE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
        }
        MetricsGroup.counterInc((MetricsName)MetricsName.QUERY_TOTAL_DURATION, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags, (long)duration);
    }
}

