/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponse
extends EnvelopeResponse<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorResponse.class);
    private String stacktrace;
    private String exception;
    private String url;
    private String suggestion;
    @JsonProperty(value="error_code")
    public String errorCode;
    public static final String STACK_MSG = "Kylin Service Intercept Stack Feature Enabled.";

    public ErrorResponse(String url, Throwable exception) {
        this.url = url;
        this.exception = exception.getLocalizedMessage();
        this.data = null;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String stackTraceAsString = Throwables.getStackTraceAsString((Throwable)exception);
        if (exception instanceof KylinException) {
            this.msg = exception.getLocalizedMessage();
            KylinException kylinException = (KylinException)exception;
            this.code = kylinException.getCode();
            this.suggestion = kylinException.getSuggestionString();
            this.errorCode = kylinException.getErrorCodeString();
            if (kylinException.isThrowTrace()) {
                if (config.isGlobalStackInterceptionEnabled()) {
                    this.stacktrace = STACK_MSG;
                    log.error(stackTraceAsString);
                } else {
                    this.stacktrace = stackTraceAsString;
                }
            }
            this.data = kylinException.getData();
        } else {
            String errorCodeString = CommonErrorCode.UNKNOWN_ERROR_CODE.toErrorCode().getLocalizedString();
            if (exception.getClass() == JsonParseException.class) {
                errorCodeString = CommonErrorCode.FAILED_PARSE_JSON.toErrorCode().getLocalizedString();
            }
            this.msg = errorCodeString + " " + exception.getLocalizedMessage();
            this.code = "999";
            if (config.isGlobalStackInterceptionEnabled()) {
                this.stacktrace = STACK_MSG;
                log.error(stackTraceAsString);
            } else {
                this.stacktrace = Throwables.getStackTraceAsString((Throwable)exception);
            }
        }
    }

    @Generated
    public String getStacktrace() {
        return this.stacktrace;
    }

    @Generated
    public String getException() {
        return this.exception;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getSuggestion() {
        return this.suggestion;
    }

    @Generated
    public String getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public void setStacktrace(String stacktrace) {
        this.stacktrace = stacktrace;
    }

    @Generated
    public void setException(String exception) {
        this.exception = exception;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    @Generated
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorResponse)) {
            return false;
        }
        ErrorResponse other = (ErrorResponse)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$stacktrace = this.getStacktrace();
        String other$stacktrace = other.getStacktrace();
        if (this$stacktrace == null ? other$stacktrace != null : !this$stacktrace.equals(other$stacktrace)) {
            return false;
        }
        String this$exception = this.getException();
        String other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$suggestion = this.getSuggestion();
        String other$suggestion = other.getSuggestion();
        if (this$suggestion == null ? other$suggestion != null : !this$suggestion.equals(other$suggestion)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        return !(this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ErrorResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $stacktrace = this.getStacktrace();
        result = result * 59 + ($stacktrace == null ? 43 : $stacktrace.hashCode());
        String $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $suggestion = this.getSuggestion();
        result = result * 59 + ($suggestion == null ? 43 : $suggestion.hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ErrorResponse(stacktrace=" + this.getStacktrace() + ", exception=" + this.getException() + ", url=" + this.getUrl() + ", suggestion=" + this.getSuggestion() + ", errorCode=" + this.getErrorCode() + ")";
    }

    @Generated
    public ErrorResponse() {
    }
}

