/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.resourcegroup.KylinInstance;
import org.apache.kylin.metadata.resourcegroup.RequestTypeEnum;
import org.apache.kylin.metadata.resourcegroup.ResourceGroup;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupManager;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupMappingInfo;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.GlutenCacheResponse;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.GlutenCacheRequestLimits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RouteService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RouteService.class);
    public static final String CACHE_GLUTEN_API = "/kylin/api/cache/gluten_cache";
    public static final String CACHE_GLUTEN_ASYNC_API = "/kylin/api/cache/gluten_cache_async";
    private final ExecutorService asyncExecutors = new ThreadPoolExecutor(20, 20, 30L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("RouteScheduler"));

    public Boolean deleteAllFolderMultiTenantMode(HttpServletRequest request) {
        try {
            ResourceGroupManager rgManager = ResourceGroupManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            Map<String, List<KylinInstance>> resourceGroupServerNode = this.getResourceGroupServerNode(rgManager, RequestTypeEnum.QUERY);
            ConcurrentMap asyncFutures = Maps.newConcurrentMap();
            long startTime = System.currentTimeMillis();
            int routeServerCount = (int)resourceGroupServerNode.entrySet().stream().filter(entry -> CollectionUtils.isNotEmpty((Collection)((Collection)entry.getValue()))).count();
            CountDownLatch result = new CountDownLatch(routeServerCount);
            for (Map.Entry<String, List<KylinInstance>> entry2 : resourceGroupServerNode.entrySet()) {
                List<KylinInstance> kylinInstances = entry2.getValue();
                if (!CollectionUtils.isNotEmpty(kylinInstances)) continue;
                KylinInstance server = kylinInstances.get(RandomUtil.nextInt((int)kylinInstances.size()));
                log.info("deleteAllFolder execute to groupId [{}] server [{}]", (Object)entry2.getKey(), (Object)server.getInstance());
                this.executeAsyncTask(asyncFutures, () -> this.deleteAllFolder(server.getInstance(), request, result));
            }
            long kylinMultiTenantRouteTaskTimeOut = KylinConfig.getInstanceFromEnv().getKylinMultiTenantRouteTaskTimeOut();
            this.cancelTimeoutAsyncTask(kylinMultiTenantRouteTaskTimeOut, asyncFutures, startTime, "deleteAllFolderMultiTenantMode");
            return result.getCount() == 0L;
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public Boolean deleteAllFolder(String instance, HttpServletRequest request, CountDownLatch result) throws Exception {
        String uri = StringUtils.stripEnd((String)request.getRequestURI(), (String)"/");
        String url = "http://" + instance + uri + "/tenant_node";
        EnvelopeResponse response = this.generateTaskForRemoteHost(request, url);
        Boolean data = (Boolean)response.getData();
        log.info("deleteAllFolder instance[{}] result : [{}]", (Object)instance, (Object)data);
        if (data.booleanValue()) {
            result.countDown();
        }
        return data;
    }

    public void cancelTimeoutAsyncTask(long timeout, Map<Future<?>, Long> asyncFutures, long startTime, String message) throws InterruptedException {
        while (MapUtils.isNotEmpty(asyncFutures)) {
            asyncFutures.forEach((asyncTask, start) -> {
                if (this.getRemainingTime(timeout, (long)start) <= 0L) {
                    asyncTask.cancel(true);
                }
            });
            long doneTaskCount = asyncFutures.keySet().stream().filter(Future::isDone).count();
            if (doneTaskCount == (long)asyncFutures.size()) {
                log.info("all running asyncTask[{}] is done", (Object)message);
                break;
            }
            if (this.getRemainingTime(timeout, startTime) <= 0L) {
                log.warn("cancel all running asyncTask[{}], DoneAsyncTask count: [{}], AllAsyncTask count : [{}]", new Object[]{message, doneTaskCount, asyncFutures.size()});
                asyncFutures.keySet().stream().filter(asyncTask -> !asyncTask.isDone()).forEach(asyncTask -> asyncTask.cancel(true));
                break;
            }
            TimeUnit.SECONDS.sleep(10L);
        }
    }

    private long getRemainingTime(long timeout, long startTime) {
        return timeout - (System.currentTimeMillis() - startTime);
    }

    public <T> void executeAsyncTask(Map<Future<?>, Long> asyncFutures, Callable<T> task) {
        Future<T> future = this.asyncExecutors.submit(task);
        asyncFutures.put(future, System.currentTimeMillis());
    }

    public Map<String, List<KylinInstance>> getResourceGroupServerNode(ResourceGroupManager rgManager, RequestTypeEnum requestType) {
        HashMap servers = Maps.newHashMap();
        ResourceGroup allResourceGroups = rgManager.getResourceGroup();
        Set queryResourceGroups = allResourceGroups.getResourceGroupMappingInfoList().stream().filter(resourceGroupMappingInfo -> resourceGroupMappingInfo.getRequestType() == requestType).map(ResourceGroupMappingInfo::getResourceGroupId).collect(Collectors.toSet());
        allResourceGroups.getKylinInstances().stream().filter(kylinInstance -> queryResourceGroups.contains(kylinInstance.getResourceGroupId())).forEach(instance -> {
            List instances = servers.getOrDefault(instance.getResourceGroupId(), Lists.newArrayList());
            instances.add(instance);
            servers.put(instance.getResourceGroupId(), instances);
        });
        return servers;
    }

    public boolean needRoute() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ResourceGroupManager rgManger = ResourceGroupManager.getInstance((KylinConfig)kylinConfig);
        return kylinConfig.isKylinMultiTenantEnabled() && rgManger.isResourceGroupEnabled();
    }

    public void asyncRouteForMultiTenantMode(HttpServletRequest servletRequest, String url) {
        try {
            ResourceGroupManager rgManager = ResourceGroupManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            Map<String, List<KylinInstance>> resourceGroupServerNode = this.getResourceGroupServerNode(rgManager, RequestTypeEnum.BUILD);
            ConcurrentMap asyncFutures = Maps.newConcurrentMap();
            long startTime = System.currentTimeMillis();
            for (Map.Entry<String, List<KylinInstance>> entry : resourceGroupServerNode.entrySet()) {
                List<KylinInstance> kylinInstances = entry.getValue();
                if (!CollectionUtils.isNotEmpty(kylinInstances)) continue;
                KylinInstance server = kylinInstances.get(RandomUtil.nextInt((int)kylinInstances.size()));
                this.executeAsyncTask(asyncFutures, () -> {
                    String fullUrl = "http://" + server.getInstance() + url;
                    return this.generateTaskForRemoteHost(servletRequest, fullUrl);
                });
            }
            long kylinMultiTenantRouteTaskTimeOut = KylinConfig.getInstanceFromEnv().getKylinMultiTenantRouteTaskTimeOut();
            this.cancelTimeoutAsyncTask(kylinMultiTenantRouteTaskTimeOut, asyncFutures, startTime, "cleanupStorageMultiTenantMode");
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public String getProjectByJobIdUseInFilter(String jobId) {
        Preconditions.checkNotNull((Object)jobId);
        List allProjects = this.getManager(NProjectManager.class).listAllProjects();
        for (ProjectInstance projectInstance : allProjects) {
            ExecutableManager executableManager = this.getManager(ExecutableManager.class, projectInstance.getName());
            AbstractExecutable job = executableManager.getJob(jobId);
            if (!Objects.nonNull(job)) continue;
            log.info("Job[{}] project is [{}]", (Object)jobId, (Object)job.getProject());
            return job.getProject();
        }
        log.warn("Job[{}] can't get project, will route to _global node", (Object)jobId);
        return "_global";
    }

    public String getProjectByModelNameUseInFilter(String modelName) {
        Preconditions.checkNotNull((Object)modelName);
        List allProjects = this.getManager(NProjectManager.class).listAllProjects();
        for (ProjectInstance project : allProjects) {
            NDataModel model = this.getMatchModels(modelName, project.getName());
            if (Objects.isNull(model)) continue;
            log.info("[ModelName{}] project is [{}]", (Object)modelName, (Object)project.getName());
            return project.getName();
        }
        log.warn("ModelName[{}] can't get project, will route to _global node", (Object)modelName);
        return "_global";
    }

    private NDataModel getMatchModels(String modelAlias, String projectName) {
        return this.getManager(NDataModelManager.class, projectName).listAllModels().stream().filter(model -> model.getAlias().equalsIgnoreCase(modelAlias)).findFirst().orElse(null);
    }

    public boolean routeGlutenCache(List<String> cacheCommands, HttpServletRequest servletRequest) throws Exception {
        try (SetLogCategory ignore = new SetLogCategory("build");){
            boolean bl = this.routeGlutenCacheInner(cacheCommands, servletRequest, CACHE_GLUTEN_API, false);
            return bl;
        }
    }

    public boolean routeGlutenCacheInner(List<String> cacheCommands, HttpServletRequest servletRequest, String url, boolean checkLimits) throws Exception {
        if (CollectionUtils.isEmpty(cacheCommands)) {
            log.warn("route url[{}] but cacheCommands is empty !!!", (Object)url);
            return true;
        }
        long startTime = System.currentTimeMillis();
        byte[] requestEntity = JsonUtil.writeValueAsBytes(cacheCommands);
        ConcurrentMap asyncFutures = Maps.newConcurrentMap();
        List queryServers = this.clusterManager.getQueryServers();
        CountDownLatch result = new CountDownLatch(queryServers.size());
        for (ServerInfoResponse queryServer : queryServers) {
            this.executeAsyncTask(asyncFutures, () -> this.cacheGluten(queryServer.getHost(), servletRequest, url, requestEntity, result));
        }
        int glutenCacheRequestTimeout = KylinConfig.getInstanceFromEnv().getGlutenCacheRequestTimeout();
        this.cancelTimeoutAsyncTask(glutenCacheRequestTimeout, asyncFutures, startTime, "routeGlutenCache");
        if (checkLimits && this.checkGlutenCacheLimits(asyncFutures)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getQueryTooManyRunning());
        }
        log.info("route url[{}] failed count is [{}]", (Object)url, (Object)result.getCount());
        return result.getCount() == 0L;
    }

    public EnvelopeResponse cacheGluten(String instance, HttpServletRequest request, String url, byte[] requestEntity, CountDownLatch result) throws Exception {
        try (SetLogCategory ignore = new SetLogCategory("build");){
            String fullUrl = "http://" + instance + url;
            EnvelopeResponse response = this.generateTaskForRemoteHost(request, fullUrl, requestEntity);
            log.info("cacheGluten instance is [{}], result is [{}]", (Object)instance, response);
            if (StringUtils.equals((CharSequence)url, (CharSequence)CACHE_GLUTEN_API)) {
                GlutenCacheResponse data = (GlutenCacheResponse)JsonUtil.convert((Object)response.getData(), GlutenCacheResponse.class);
                if (data.getResult().booleanValue()) {
                    result.countDown();
                }
            } else if (StringUtils.equals((CharSequence)url, (CharSequence)CACHE_GLUTEN_ASYNC_API)) {
                result.countDown();
            }
            EnvelopeResponse envelopeResponse = response;
            return envelopeResponse;
        }
    }

    public boolean checkGlutenCacheLimits(Map<Future<?>, Long> tasks) {
        boolean limitFlag = false;
        for (Future<?> doneTask : tasks.keySet()) {
            try {
                EnvelopeResponse response = (EnvelopeResponse)doneTask.get();
                if (!StringUtils.startsWith((CharSequence)response.getMsg(), (CharSequence)ServerErrorCode.PERMISSION_DENIED.toErrorCode().getCodeString())) continue;
                limitFlag = true;
                break;
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return limitFlag;
    }

    public void routeGlutenCacheAsync(List<String> cacheCommands, HttpServletRequest servletRequest) throws Exception {
        try (GlutenCacheRequestLimits ignored = new GlutenCacheRequestLimits();
             SetLogCategory ignore = new SetLogCategory("query");){
            this.routeGlutenCacheInner(cacheCommands, servletRequest, CACHE_GLUTEN_ASYNC_API, true);
        }
    }
}

