/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Sets;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DependentColumn {
    @JsonProperty
    String column;
    @JsonProperty(value="dependent_column_identity")
    String dependentColumnIdentity;
    @JsonProperty(value="dependent_values")
    String[] dependentValues;

    public DependentColumn() {
    }

    public DependentColumn(String column, String dependentColumnIdentity, String[] dependentValues) {
        this.column = column;
        this.dependentColumnIdentity = dependentColumnIdentity;
        this.dependentValues = dependentValues;
    }

    public String getColumn() {
        return this.column;
    }

    public String getDependentColumnIdentity() {
        return this.dependentColumnIdentity;
    }

    public String[] getDependentValues() {
        return this.dependentValues;
    }

    public DependentColumn merge(DependentColumn other) {
        Preconditions.checkArgument((other != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)other.column.equalsIgnoreCase(this.column));
        Preconditions.checkArgument((boolean)other.dependentColumnIdentity.equalsIgnoreCase(this.dependentColumnIdentity));
        HashSet values = Sets.newHashSet((Object[])this.dependentValues);
        values.addAll(Arrays.asList(other.dependentValues));
        return new DependentColumn(this.column, this.dependentColumnIdentity, values.toArray(new String[0]));
    }
}

