/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigDecimalSerializer
extends DataTypeSerializer<BigDecimal> {
    private static final Logger logger = LoggerFactory.getLogger(BigDecimalSerializer.class);
    final DataType type;
    final int maxLength;
    transient int avoidVerbose = 0;

    public BigDecimalSerializer(DataType type) {
        this.type = type;
        this.maxLength = 2 + (type.getPrecision() + 1) / 2;
    }

    public void serialize(BigDecimal value, ByteBuffer out) {
        byte[] bytes;
        if (value.scale() > this.type.getScale()) {
            if (this.avoidVerbose++ % 10000 == 0) {
                logger.warn("value's scale has exceeded the " + this.type.getScale() + ", cut it off, to ensure encoded value do not exceed maxLength " + this.maxLength + " times:" + this.avoidVerbose);
            }
            value = value.setScale(this.type.getScale(), 6);
        }
        if ((bytes = value.unscaledValue().toByteArray()).length + 2 > this.maxLength) {
            throw new IllegalArgumentException("'" + value + "' exceeds the expected length for type " + this.type);
        }
        BytesUtil.writeVInt((int)value.scale(), (ByteBuffer)out);
        BytesUtil.writeVInt((int)bytes.length, (ByteBuffer)out);
        out.put(bytes);
    }

    public BigDecimal deserialize(ByteBuffer in) {
        int scale = BytesUtil.readVInt((ByteBuffer)in);
        int n = BytesUtil.readVInt((ByteBuffer)in);
        byte[] bytes = new byte[n];
        in.get(bytes);
        return new BigDecimal(new BigInteger(bytes), scale);
    }

    @Override
    public int peekLength(ByteBuffer in) {
        int mark = in.position();
        int scale = BytesUtil.readVInt((ByteBuffer)in);
        int n = BytesUtil.readVInt((ByteBuffer)in);
        int len = in.position() - mark + n;
        in.position(mark);
        return len;
    }

    @Override
    public int maxLength() {
        return this.maxLength;
    }

    @Override
    public int getStorageBytesEstimate() {
        return 8;
    }

    @Override
    public BigDecimal valueOf(String str) {
        return new BigDecimal(str);
    }
}

