/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.Serializable;
import lombok.Generated;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.table.ATable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ColumnDesc
implements Serializable {
    private static final String BACK_TICK = Quoting.BACK_TICK.string;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="datatype")
    private String datatype;
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String comment;
    @JsonProperty(value="data_gen")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataGen;
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String index;
    @JsonProperty(value="cc_expr")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String computedColumnExpr = null;
    @JsonProperty(value="case_sensitive_name")
    public String caseSensitiveName;
    @JsonProperty(value="is_partitioned")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isPartitioned = false;
    private DataType type;
    private DataType upgradedType;
    private ATable table;
    private int zeroBasedIndex = -1;
    private boolean isNullable = true;

    public ColumnDesc() {
    }

    public ColumnDesc(ColumnDesc other) {
        this.id = other.id;
        this.name = other.name;
        this.datatype = other.datatype;
        this.comment = other.comment;
        this.dataGen = other.dataGen;
        this.index = other.index;
        this.computedColumnExpr = other.computedColumnExpr;
        this.caseSensitiveName = other.caseSensitiveName;
        this.isPartitioned = other.isPartitioned;
        this.table = other.table;
    }

    public ColumnDesc(String id, String name, String datatype, String comment, String dataGen, String index, String computedColumnExpr) {
        this.id = id;
        this.name = name;
        this.datatype = datatype;
        this.comment = comment;
        this.dataGen = dataGen;
        this.index = index;
        this.computedColumnExpr = computedColumnExpr;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
        this.type = DataType.getType(datatype);
    }

    public DataType getUpgradedType() {
        if (this.upgradedType == null) {
            return this.type;
        }
        return this.upgradedType;
    }

    public void setId(String id) {
        this.id = id;
        if (id != null) {
            this.zeroBasedIndex = Integer.parseInt(id) - 1;
        }
    }

    public String getOriginalName() {
        return this.name;
    }

    public String getName() {
        return StringUtils.upperCase((String)this.name);
    }

    public String getIdentity() {
        return this.table.getName() + "." + this.getName();
    }

    public String getBackTickIdentity() {
        return BACK_TICK + this.table.getName() + BACK_TICK + "." + BACK_TICK + this.getName() + BACK_TICK;
    }

    public String getBackTickName() {
        return BACK_TICK + this.getName() + BACK_TICK;
    }

    @JsonSetter(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public String getCaseSensitiveName() {
        return this.caseSensitiveName == null ? this.name : this.caseSensitiveName;
    }

    @JsonSetter(value="case_sensitive_name")
    public void setCaseSensitiveName(String caseSensitiveName) {
        this.caseSensitiveName = caseSensitiveName;
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public int getTypePrecision() {
        return this.type.getPrecision();
    }

    public int getTypeScale() {
        return this.type.getScale();
    }

    public String getComputedColumnExpr() {
        Preconditions.checkState((this.computedColumnExpr != null ? 1 : 0) != 0);
        return this.computedColumnExpr;
    }

    public String getDoubleQuoteInnerExpr() {
        Preconditions.checkState((this.computedColumnExpr != null ? 1 : 0) != 0);
        int quoteCnt = StringUtils.countMatches((CharSequence)this.computedColumnExpr, (char)'\'');
        if (quoteCnt == 0 || quoteCnt == 1) {
            return this.computedColumnExpr.replace('`', '\"');
        }
        return StringHelper.backtickToDoubleQuote((String)this.computedColumnExpr);
    }

    public boolean isComputedColumn() {
        return this.computedColumnExpr != null;
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public void setPartitioned(boolean partitioned) {
        this.isPartitioned = partitioned;
    }

    public void init(ATable table) {
        DataType normalized;
        this.table = table;
        if (this.id != null) {
            this.zeroBasedIndex = Integer.parseInt(this.id) - 1;
        }
        if ((normalized = DataType.getType(this.datatype)) == null) {
            this.setDatatype(null);
        } else {
            this.setDatatype(normalized.toString());
        }
    }

    public static ColumnDesc mockup(ATable table, int oneBasedColumnIndex, String name, String datatype) {
        ColumnDesc desc = new ColumnDesc();
        desc.setId(String.valueOf(oneBasedColumnIndex));
        desc.setName(name);
        desc.setDatatype(datatype);
        desc.init(table);
        return desc;
    }

    public String getCanonicalName() {
        String tableName = null;
        if (this.table != null) {
            tableName = this.table.getIdentity();
        }
        return tableName + "." + this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean isSameTable;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDesc other = (ColumnDesc)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        boolean bl = this.table == null ? other.table == null : (isSameTable = this.table.getIdentity().equals(other.table.getIdentity()));
        if (!isSameTable) {
            return false;
        }
        if (this.isComputedColumn() && other.isComputedColumn()) {
            return StringUtils.equals((CharSequence)this.computedColumnExpr, (CharSequence)other.getComputedColumnExpr());
        }
        return !this.isComputedColumn() && !other.isComputedColumn();
    }

    public String toString() {
        return "ColumnDesc{id='" + this.id + "', name='" + this.name + "', datatype='" + this.datatype + "'}";
    }

    public ColumnDesc copy() {
        return new ColumnDesc(this);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDatatype() {
        return this.datatype;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public String getDataGen() {
        return this.dataGen;
    }

    @Generated
    public String getIndex() {
        return this.index;
    }

    @Generated
    public void setComputedColumnExpr(String computedColumnExpr) {
        this.computedColumnExpr = computedColumnExpr;
    }

    @Generated
    public DataType getType() {
        return this.type;
    }

    @Generated
    public void setUpgradedType(DataType upgradedType) {
        this.upgradedType = upgradedType;
    }

    @Generated
    public ATable getTable() {
        return this.table;
    }

    @Generated
    public void setTable(ATable table) {
        this.table = table;
    }

    @Generated
    public int getZeroBasedIndex() {
        return this.zeroBasedIndex;
    }

    @Generated
    public boolean isNullable() {
        return this.isNullable;
    }

    @Generated
    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }
}

