/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.calcite.util.CancelFlag;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowQueryDetector
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger((String)"query");
    private static final ConcurrentHashMap<Thread, QueryEntry> runningQueries = new ConcurrentHashMap();
    private static final ConcurrentMap<String, CanceledSlowQueryStatus> canceledSlowQueriesStatus = Maps.newConcurrentMap();
    private final int detectionIntervalMs;
    private final int queryTimeoutMs;

    public SlowQueryDetector() {
        super("SlowQueryDetector");
        this.setDaemon(true);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        this.detectionIntervalMs = kylinConfig.getSlowQueryDefaultDetectIntervalSeconds() * 1000;
        this.queryTimeoutMs = kylinConfig.getQueryTimeoutSeconds() * 1000;
    }

    public SlowQueryDetector(int detectionIntervalMs, int queryTimeoutMs) {
        super("SlowQueryDetector");
        this.setDaemon(true);
        this.detectionIntervalMs = detectionIntervalMs;
        this.queryTimeoutMs = queryTimeoutMs;
    }

    public static ConcurrentMap<String, CanceledSlowQueryStatus> getCanceledSlowQueriesStatus() {
        return canceledSlowQueriesStatus;
    }

    @VisibleForTesting
    public static void addCanceledSlowQueriesStatus(ConcurrentMap<String, CanceledSlowQueryStatus> slowQueriesStatus) {
        canceledSlowQueriesStatus.putAll(slowQueriesStatus);
    }

    @VisibleForTesting
    public static void clearCanceledSlowQueriesStatus() {
        canceledSlowQueriesStatus.clear();
    }

    public void queryStart(String stopId) {
        runningQueries.put(SlowQueryDetector.currentThread(), new QueryEntry(System.currentTimeMillis(), SlowQueryDetector.currentThread(), QueryContext.current().getQueryId(), QueryContext.current().getUserSQL(), stopId, false, QueryContext.current().getQueryTagInfo().isAsyncQuery(), false, null, CancelFlag.getContextCancelFlag()));
    }

    public void addJobIdForAsyncQueryJob(String jobId) {
        QueryEntry queryEntry = runningQueries.get(SlowQueryDetector.currentThread());
        if (queryEntry != null) {
            queryEntry.setJobId(jobId);
        }
    }

    public void stopQuery(String id) {
        for (QueryEntry e : SlowQueryDetector.getRunningQueries().values()) {
            if ((!e.isAsyncQuery() || !id.equals(e.getQueryId())) && (e.isAsyncQuery() || !id.equals(e.getStopId()))) continue;
            e.setStopByUser(true);
            this.doStopQuery(e);
            break;
        }
    }

    private void doStopQuery(QueryEntry e) {
        if (e.getJobId() == null) {
            e.getPlannerCancelFlag().requestCancel();
            logger.error("Trying to cancel query: {}", (Object)e.getThread().getName());
            e.getThread().interrupt();
        } else {
            logger.error("Trying to cancel query job : {},{}", (Object)e.getThread().getName(), (Object)e.getJobId());
            EventBusFactory.getInstance().postSync((Object)new CliCommandExecutor.JobKilled(e.getJobId()));
        }
    }

    public void queryEnd() {
        QueryEntry entry = runningQueries.remove(SlowQueryDetector.currentThread());
        if (null != entry && null != canceledSlowQueriesStatus.get(entry.queryId)) {
            canceledSlowQueriesStatus.remove(entry.queryId);
            logger.debug("Remove query [{}] from canceledSlowQueriesStatus", (Object)entry.queryId);
        }
    }

    @Override
    public void run() {
        while (true) {
            this.checkStopByUser();
            this.checkTimeout();
            try {
                Thread.sleep(this.detectionIntervalMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private void checkStopByUser() {
        for (QueryEntry e : runningQueries.values()) {
            if (!e.isStopByUser) continue;
            this.doStopQuery(e);
        }
    }

    private void checkTimeout() {
        for (QueryEntry e : runningQueries.values()) {
            if (!e.setInterruptIfTimeout()) continue;
            try {
                CanceledSlowQueryStatus canceledSlowQueryStatus = (CanceledSlowQueryStatus)canceledSlowQueriesStatus.get(e.getQueryId());
                if (null == canceledSlowQueryStatus) {
                    canceledSlowQueriesStatus.putIfAbsent(e.getQueryId(), new CanceledSlowQueryStatus(e.getQueryId(), 1, System.currentTimeMillis(), e.getRunningTime()));
                    logger.debug("Query [{}] has been canceled 1 times, put to canceledSlowQueriesStatus", (Object)e.queryId);
                    continue;
                }
                int canceledTimes = canceledSlowQueryStatus.getCanceledTimes() + 1;
                canceledSlowQueriesStatus.put(e.getQueryId(), new CanceledSlowQueryStatus(e.getQueryId(), canceledTimes, System.currentTimeMillis(), e.getRunningTime()));
                logger.debug("Query [{}] has been canceled {} times", (Object)e.getQueryId(), (Object)canceledTimes);
            }
            catch (Exception ex) {
                logger.error("Record slow query status failed!", (Throwable)ex);
            }
        }
    }

    @Generated
    public static ConcurrentHashMap<Thread, QueryEntry> getRunningQueries() {
        return runningQueries;
    }

    public class QueryEntry {
        final long startTime;
        final Thread thread;
        final String queryId;
        final String sql;
        final String stopId;
        boolean isStopByUser;
        final boolean isAsyncQuery;
        boolean isTimeoutStop;
        String jobId;
        final CancelFlag plannerCancelFlag;

        public long getRunningTime() {
            return (System.currentTimeMillis() - this.startTime) / 1000L;
        }

        public synchronized boolean setInterruptIfTimeout() {
            if (this.isAsyncQuery) {
                return false;
            }
            long runningMs = System.currentTimeMillis() - this.startTime;
            if (runningMs >= (long)SlowQueryDetector.this.queryTimeoutMs) {
                this.isTimeoutStop = true;
                this.plannerCancelFlag.requestCancel();
                this.thread.interrupt();
                logger.error("Trying to cancel query: {}", (Object)this.thread.getName());
                return true;
            }
            return false;
        }

        public synchronized CancelFlag getPlannerCancelFlag() {
            return this.plannerCancelFlag;
        }

        @Generated
        public long getStartTime() {
            return this.startTime;
        }

        @Generated
        public Thread getThread() {
            return this.thread;
        }

        @Generated
        public String getQueryId() {
            return this.queryId;
        }

        @Generated
        public String getSql() {
            return this.sql;
        }

        @Generated
        public String getStopId() {
            return this.stopId;
        }

        @Generated
        public boolean isStopByUser() {
            return this.isStopByUser;
        }

        @Generated
        public boolean isAsyncQuery() {
            return this.isAsyncQuery;
        }

        @Generated
        public boolean isTimeoutStop() {
            return this.isTimeoutStop;
        }

        @Generated
        public String getJobId() {
            return this.jobId;
        }

        @Generated
        public void setStopByUser(boolean isStopByUser) {
            this.isStopByUser = isStopByUser;
        }

        @Generated
        public void setTimeoutStop(boolean isTimeoutStop) {
            this.isTimeoutStop = isTimeoutStop;
        }

        @Generated
        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Generated
        public QueryEntry(long startTime, Thread thread, String queryId, String sql, String stopId, boolean isStopByUser, boolean isAsyncQuery, boolean isTimeoutStop, String jobId, CancelFlag plannerCancelFlag) {
            this.startTime = startTime;
            this.thread = thread;
            this.queryId = queryId;
            this.sql = sql;
            this.stopId = stopId;
            this.isStopByUser = isStopByUser;
            this.isAsyncQuery = isAsyncQuery;
            this.isTimeoutStop = isTimeoutStop;
            this.jobId = jobId;
            this.plannerCancelFlag = plannerCancelFlag;
        }
    }

    public static class CanceledSlowQueryStatus {
        public final String queryId;
        public final int canceledTimes;
        public final long lastCanceledTime;
        public final float queryDurationTime;

        @Generated
        public String getQueryId() {
            return this.queryId;
        }

        @Generated
        public int getCanceledTimes() {
            return this.canceledTimes;
        }

        @Generated
        public long getLastCanceledTime() {
            return this.lastCanceledTime;
        }

        @Generated
        public float getQueryDurationTime() {
            return this.queryDurationTime;
        }

        @Generated
        public CanceledSlowQueryStatus(String queryId, int canceledTimes, long lastCanceledTime, float queryDurationTime) {
            this.queryId = queryId;
            this.canceledTimes = canceledTimes;
            this.lastCanceledTime = lastCanceledTime;
            this.queryDurationTime = queryDurationTime;
        }
    }
}

