/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.util.List;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractProposer;

public class IndexPlanSelectProposer
extends AbstractProposer {
    public IndexPlanSelectProposer(AbstractContext smartContext) {
        super(smartContext);
    }

    @Override
    public void execute() {
        List<AbstractContext.ModelContext> modelContexts = this.proposeContext.getModelContexts();
        if (modelContexts == null || modelContexts.isEmpty()) {
            return;
        }
        for (AbstractContext.ModelContext modelContext : modelContexts) {
            IndexPlan indexPlan = this.findExisting(modelContext.getTargetModel());
            if (indexPlan == null) continue;
            modelContext.setOriginIndexPlan(indexPlan);
            modelContext.setTargetIndexPlan(indexPlan.copy());
        }
    }

    private IndexPlan findExisting(NDataModel model) {
        return model == null ? null : this.proposeContext.getOriginIndexPlan(model.getUuid());
    }

    @Override
    public String getIdentifierName() {
        return "IndexPlanSelectProposer";
    }
}

